/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.declaration;

import br.com.objectos.code.java.declaration.ParameterTypeName;
import br.com.objectos.code.java.declaration.VarArgs;
import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.expression.LambdaParameter;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.type.ArrayTypeName;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.comuns.lang.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor8;

public class ParameterCode
extends AbstractCodeElement
implements LambdaParameter {
    private final ParameterTypeName typeName;
    private final String name;

    ParameterCode(ParameterTypeName typeName, String name) {
        this.typeName = typeName;
        this.name = name;
    }

    public static ParameterCode of(VariableElement element) {
        Preconditions.checkNotNull((Object)element, (String)"element == null");
        Element enclosingElement = element.getEnclosingElement();
        return enclosingElement.accept(FromVariableElementFactory.INSTANCE, element);
    }

    public static ParameterCode of(Class<?> type, String name) {
        ClassName typeName = ClassName.of(type);
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        return new ParameterCode(typeName, name);
    }

    public static ParameterCode of(ParameterTypeName typeName, String name) {
        Preconditions.checkNotNull((Object)typeName, (String)"typeName == null");
        Preconditions.checkNotNull((Object)name, (String)"name == null");
        return new ParameterCode(typeName, name);
    }

    static ParameterCode ofUnchecked(ParameterTypeName typeName, String name) {
        return new ParameterCode(typeName, name);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter writer) {
        return writer.writeCodeElement(this.typeName).writeWord(this.name);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ParameterCode)) {
            return false;
        }
        ParameterCode that = (ParameterCode)obj;
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.name, that.name);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.typeName, this.name);
    }

    public final boolean isVarArgs() {
        return this.typeName.isVarArgs();
    }

    public final String name() {
        return this.name;
    }

    public final ParameterTypeName typeName() {
        return this.typeName;
    }

    private static class FromVariableElementFactory
    extends SimpleElementVisitor8<ParameterCode, VariableElement> {
        static FromVariableElementFactory INSTANCE = new FromVariableElementFactory();

        private FromVariableElementFactory() {
        }

        @Override
        public final ParameterCode visitExecutable(ExecutableElement e, VariableElement p) {
            return e.isVarArgs() ? this.visitExecutableVarArgs(e, p) : this.visitExecutableStandard(e, p);
        }

        private ParameterCode visitExecutableStandard(ExecutableElement e, VariableElement p) {
            TypeMirror type = p.asType();
            return new ParameterCode(TypeName.ofUnchecked(type), p.getSimpleName().toString());
        }

        private ParameterCode visitExecutableVarArgs(ExecutableElement e, VariableElement p) {
            List<? extends VariableElement> parameters = e.getParameters();
            VariableElement last = parameters.get(parameters.size() - 1);
            if (!last.equals(p)) {
                return this.visitExecutableStandard(e, p);
            }
            TypeMirror type = p.asType();
            ArrayTypeName typeName = (ArrayTypeName)TypeName.ofUnchecked(type);
            return new ParameterCode(VarArgs.of(typeName), p.getSimpleName().toString());
        }

        @Override
        protected final ParameterCode defaultAction(Element e, VariableElement p) {
            throw new UnsupportedOperationException("Cannot instantiate ParameterCode from " + (Object)((Object)e.getKind()));
        }
    }
}

