/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.element.NewLine;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.BlockStatement;
import br.com.objectos.code.java.statement.FormattedStatement;
import br.com.objectos.code.java.statement.Statement;
import br.com.objectos.comuns.collections.GrowableList;

public class StatementOrBlockBuilder {
    private final GrowableList<BlockElement> blockElements = GrowableList.newList();
    private int blockStatementCount;
    private int statementCount;
    private boolean forceBlock;
    private Statement lastStatement;

    StatementOrBlockBuilder() {
    }

    final CodeElement build() {
        if (!this.forceBlock && this.statementCount == 1 && this.blockStatementCount == 0) {
            return this.buildStatement();
        }
        return this.buildBlock();
    }

    final void forceBlock() {
        this.forceBlock = true;
    }

    public final StatementOrBlockBuilder nl() {
        this.blockElements.add((Object)NewLine.nl());
        return this;
    }

    public final StatementOrBlockBuilder withStatement(BlockStatement statement) {
        this.blockElements.add((Object)statement);
        ++this.blockStatementCount;
        return this;
    }

    final StatementOrBlockBuilder withStatement(Statement statement) {
        this.blockElements.add((Object)statement);
        this.lastStatement = statement;
        ++this.statementCount;
        return this;
    }

    private CodeElement buildBlock() {
        return Block.of(this.blockElements);
    }

    private CodeElement buildStatement() {
        if (this.blockElements.size() == 1) {
            return this.lastStatement;
        }
        return FormattedStatement.of(this.blockElements);
    }
}

