/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.AbstractCodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.Section;
import br.com.objectos.code.java.statement.BlockStatement;
import br.com.objectos.code.java.statement.CaseSwitchElement;
import br.com.objectos.code.java.statement.DefaultSwitchElement;
import br.com.objectos.code.java.statement.SwitchElement;
import br.com.objectos.comuns.collections.ImmutableList;

final class SwitchGroup
extends AbstractCodeElement
implements SwitchElement {
    private final SwitchElement caseElement;
    private final ImmutableList<BlockStatement> body;

    private SwitchGroup(SwitchElement caseElement, ImmutableList<BlockStatement> body) {
        this.caseElement = caseElement;
        this.body = body;
    }

    static SwitchElement of(CaseSwitchElement caseElement, BlockStatement ... statements) {
        return SwitchGroup.of0(caseElement, statements);
    }

    static SwitchGroup of(DefaultSwitchElement caseElement, BlockStatement ... statements) {
        return SwitchGroup.of0(caseElement, statements);
    }

    private static SwitchGroup of0(SwitchElement caseElement, BlockStatement ... statements) {
        ImmutableList body = ImmutableList.newListWithAll((Object[])statements);
        return new SwitchGroup(caseElement, (ImmutableList<BlockStatement>)body);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        w.writeCodeElement(this.caseElement);
        w.beginSection(Section.BLOCK);
        for (BlockStatement element : this.body) {
            w.nextLine();
            w.writeCodeElement(element);
            w.spaceOff();
            w.write(';');
        }
        return w.endSection();
    }
}

