/*
 * @authors   Rohan Sahay, rohansahay@elear.solutions
 *            Krishna, krishnasarma@elear.solutions
 *            Akshay Mende, akshaymende@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

import java.util.ArrayList;

/**
 * Interface comprising signatures of callbacks used by {@link CallbackMultiplexer}
 * to notify its subscribers.
 */
public interface CallbacksInterface {
  void connectStatusCallback(Network network);

  void deviceInfoCallback(Device device);

  void resourceCallback(Resource resource);

  void resourceCapabilityCallback(Capability capability);

  void resourceAttributeCallback(Attribute attribute);

  void commandStatusCallback(CommandResponse<?> command);

  void networkListCallback(ArrayList<Network> networksList);

  void deviceManagementStatusCallback(Device device, CommandResponse<?> executedCommand,
                                      Resource[] resourcesImpacted);

  void infoRequestCallback(InfoRequest infoRequest);

  void infoResponseStatusCallback(Command.State state, InfoResponse infoResponse);

  void messageCallback(String title, String message, MessageType messageType);

  void advertiseResourceCallback(Resource resource);

  void infoRequestStatusCallback(Command.State state, InfoRequest infoRequest);

  void infoResponseCallback(InfoRequest request, InfoResponse infoResponse);

  void resourceIncludedCallback(ArrayList<Resource> resources);

  void resourceExcludedCallback(Resource resource);

  void tunnelStatusCallback(Capability tunnel, long tunnelHandle, CapabilityTunnel.State state,
                            int port);

  void zoneInfoCallback(Zone zone);

  void zoneDeletedCallback(Network network, int zoneId);

  void sceneInfoCallback(Scene scene);

  void sceneDeletedCallback(Network network, int sceneId);

  void ruleInfoCallback(Rule rule);

  void ruleDeletedCallback(Network network, int ruleId);

  void nodeConnectionStatusCallback(Network network, long nodeId, NodeType nodeType,
                                    boolean isOnline);

  void networkManagementCommandCallback(Network network, CommandResponse<?> command);

  void networkDataCallback(Network network);

  /**
   * {@link Command.State#SUCCESS} and {@link Command.State#FAILURE} are only possible.
   */
  void leaveNetworkStatusCallback(Network network, Command.State status);

  void errorCallback(Throwable tr);

  void receiveDataCallback(Network network, long sourceNodeId, String data);

  void contentInfoCallback(Network network, long sourceNodeId, long contentTime, String data);

  void networkMetadataCallback(Network network);
}
