/*
 * @author   Krishna, krishnasarma@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

/**
 * Creator interface with method signatures that aid in instantiation of {@link Network},
 * {@link Device}, {@link Zone}, {@link Scene}, {@link Rule}, {@link Resource},
 * {@link Capability}, {@link Attribute} objects.
 * NOTE: create the objects instead of trying to manage and recycle the objects.
 *       Most of the recycling is handled internally already.
 */
public interface Creator {
  Network createNetwork(String id);

  Device createDevice(long deviceNodeId, Network parent);

  Zone createZone(int zoneId, Network parent);

  Scene createScene(int sceneId, Network parent);

  Rule createRule(int id, Network parent);

  Resource createResource(String eui, Device parentDevice, Zone parentZone);

  Resource createAdvertResource(String eui, Device parentDevice);

  // NOTE: try not to override this method. Since, it requires all the capabilities to be extended
  Capability createCapability(int capabilityId, Resource parent);

  Attribute createAttribute(int id, Capability parent);
}
