/*
 * @authors   Krishna, krishnasarma@elear.solutions
 *            Akshay Mende, akshaymende@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

import java.util.ArrayList;

/**
 * A layer to receive the callbacks and open it to be implemented by the
 * developer.
 * This interface provides default implementation for signatures in {@link CallbacksInterface}.
 */
public interface DefaultCallbacksInterface extends CallbacksInterface {
  @Override
  default void connectStatusCallback(Network network) {
  }

  @Override
  default void deviceInfoCallback(Device device) {
  }

  @Override
  default void resourceCallback(Resource resource) {
  }

  @Override
  default void resourceCapabilityCallback(Capability capability) {
  }

  @Override
  default void resourceAttributeCallback(Attribute attribute) {
  }

  @Override
  default void commandStatusCallback(CommandResponse<?> command) {
  }

  @Override
  default void networkListCallback(ArrayList<Network> networksList) {
  }

  @Override
  default void deviceManagementStatusCallback(Device device, CommandResponse<?> executedCommand,
                                              Resource[] resourcesImpacted) {
  }

  @Override
  default void infoRequestCallback(InfoRequest infoRequest) {
  }

  @Override
  default void infoResponseStatusCallback(Command.State state, InfoResponse infoResponse) {
  }

  @Override
  default void messageCallback(String title, String message, MessageType messageType) {
  }

  @Override
  default void advertiseResourceCallback(Resource resource) {
  }

  @Override
  default void infoRequestStatusCallback(Command.State state, InfoRequest infoRequest) {
  }

  @Override
  default void infoResponseCallback(InfoRequest request, InfoResponse infoResponse) {
  }

  @Override
  default void resourceIncludedCallback(ArrayList<Resource> resources) {
  }

  @Override
  default void resourceExcludedCallback(Resource resource) {
  }

  @Override
  default void tunnelStatusCallback(Capability tunnel, long tunnelHandle,
                                    CapabilityTunnel.State state, int port) {
  }

  @Override
  default void zoneInfoCallback(Zone zone) {
  }

  @Override
  default void zoneDeletedCallback(Network network, int zoneId) {
  }

  @Override
  default void sceneInfoCallback(Scene scene) {
  }

  @Override
  default void sceneDeletedCallback(Network network, int sceneId) {
  }

  @Override
  default void ruleInfoCallback(Rule rule) {
  }

  @Override
  default void ruleDeletedCallback(Network network, int ruleId) {
  }

  @Override
  default void nodeConnectionStatusCallback(Network network, long nodeId, NodeType nodeType,
                                            boolean isOnline) {
  }

  @Override
  default void networkManagementCommandCallback(Network network, CommandResponse<?> command) {
  }

  @Override
  default void networkDataCallback(Network network) {
  }

  @Override
  default void leaveNetworkStatusCallback(Network network, Command.State status) {
  }

  @Override
  default void errorCallback(Throwable tr) {
  }

  @Override
  default void receiveDataCallback(Network network, long sourceNodeId, String data) {
  }

  @Override
  default void contentInfoCallback(Network network, long sourceNodeId, long contentTime,
                                   String data) {
  }

  @Override
  default void networkMetadataCallback(Network network) {
  }
}
