/*
 * @author    Krishna, krishnasarma@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

interface IdProvider {
  Capability.CommandId getCommandId(int cmdId);

  Capability.AttributeId getAttributeId(int attrId);

  IdProvider CAP_ON_OFF_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityOnOff.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityOnOff.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_LEVEL_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityLevel.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityLevel.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_COLOR_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityColor.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityColor.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_LOCK_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityDoorLock.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityDoorLock.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_ENERGY_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityEnergyMetering.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityEnergyMetering.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_MOTION_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityMotionSensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityMotionSensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_OCCUPANCY_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityOccupancySensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityOccupancySensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_CONTACT_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityContactSensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityContactSensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_FLUID_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityFluidLevelSensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityFluidLevelSensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_FIRE_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityFireSensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityFireSensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_TEMP_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityTemperatureSensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityTemperatureSensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_LUMINANCE_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityIlluminance.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityIlluminance.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_POWER_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityPowerLevels.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityPowerLevels.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_TUNNEL_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityTunnel.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityTunnel.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_HUMIDITY_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityHumiditySensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityHumiditySensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_KEY_PRESS_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityKeyPressSensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityKeyPressSensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_WARN_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityWarning.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityWarning.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_NETWORK_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityNetworkConfiguration.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityNetworkConfiguration.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_MEDIA_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityMediaStreaming.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityMediaStreaming.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_STORAGE_CONFIG_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityStorageConfig.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityStorageConfig.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_STORAGE_CONTROL_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityStorageControl.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityStorageControl.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_MOTOR_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityMotorControl.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityMotorControl.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_IMAGE_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityImageControl.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityImageControl.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_SNAP_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilitySnapshot.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilitySnapshot.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_STATIONARY_POS_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityStationaryPosition.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityStationaryPosition.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_REAL_TIME_POS_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityRealTimePosition.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityRealTimePosition.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_VIBRATION_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityVibrationSensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityVibrationSensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_AIR_Q_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityAirQualitySensing.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityAirQualitySensing.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_WINDOW_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityWindowCovering.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityWindowCovering.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_REMOTE_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityRemoteControl.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityRemoteControl.AttributeId.getEnum(attrId);
    }
  };

  IdProvider CAP_HVAC_PROVIDER = new IdProvider() {
    @Override
    public Capability.CommandId getCommandId(int cmdId) {
      return CapabilityHvacControl.CommandId.getEnum(cmdId);
    }

    @Override
    public Capability.AttributeId getAttributeId(int attrId) {
      return CapabilityHvacControl.AttributeId.getEnum(attrId);
    }
  };
}
