/*
 * @author   Krishna, krishnasarma@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

/**
 * An enum denoting possible values of message types for {@link NativeCallbacks#messageCallback}.
 */
public enum MessageType {
  PROMPT,    // Prompt to user to take offline action
  INFO,      // Informational messages for the user
  ERROR,     // Error Message
  WARNING,   // Warning messages
  CRITICAL,  // Critical or emergency condition requiring the user's attention
  PROTOCOL;  // These are protocol messages; not to be displayed on the UI

  static MessageType getEnum(int index) {
    return Utils.findEnum(index, values());
  }

  int getInt() {
    return ordinal();
  }
}
