/*
 * @authors   Rohan Sahay, rohansahay@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

import java.nio.ByteBuffer;

/**
 * A layer to translate JAVA functions to corresponding C functions, using native function calls.
 */
class Native {

  static native int nativeInit(String cwdPath, String appAccessList,
                               String clientId, String downloadPath,
                               long fastRetryDuration, long backgroundMaxRetryPeriod,
                               long foregroundMaxRetryPeriod, long keepAliveInterval,
                               long keepAliveTimeout);

  static native int nativeConnect(String networkId, int clusterPort, Object context);

  static native int nativeDisconnect(String networkId);

  static native int nativeLeaveNetwork(String networkId, Object context);

  static native int nativeGetAllNetworks(Object context);

  static native Network[] nativeGetSavedNetworks();

  static native int nativeSendResourceCommand(String networkId, long deviceNodeId,
                                              String resourceEui,
                                              int capabilityId, int cmdId, long timeout,
                                              Object context,
                                              String jsonCommand);

  static native int nativeSendInfoResponse(String networkId, long requestNodeId, long requestId,
                                           long cmdSeqNum,
                                           String infoResponseJson, Object context);

  static native int nativeOpenTunnel(String networkId, long deviceNodeId, String resourceEui,
                                     String forwardHostName, int fwdHostPort,
                                     String listeningHostName,
                                     int listeningHostPort, int ipVersion, int tunnelProtocol,
                                     int tunnelType,
                                     int transportType, long timeout, Object context);

  static native int nativeCloseTunnel(String networkId, long tunnelHandle, long timeout);

  static native int nativeSetTokens(String response);

  static native int nativeGetAccessTokens(Object context);

  static native int nativeSendDeviceManagementCommand(String networkId, long deviceNodeId,
                                                      long timeout,
                                                      String jsonCommand, Object context);

  static native int nativeSendNetworkManagementCommand(String networkId, long timeout,
                                                       String jsonCommand,
                                                       Object context);

  static native int nativeExecuteScene(String networkId, int sceneId,
                                       String sceneName, String sceneMetadata,
                                       String[] resourceActions);

  static native int nativeConnectWithInvite(String inviteUrl, String networkId, String networkName,
                                            int networkType, int userRole, int accessType,
                                            long nodeId,
                                            Object context);

  static native int nativeSendInfoRequest(String networkId, long deviceNodeId, long requestId,
                                          long timeout,
                                          String messageText, String infoRequestJson,
                                          Object context);

  static native int nativeStartMediaStream(String networkId, long deviceNodeId, String resourceEui,
                                           int capabilityId,
                                           long streamId, int streamSessionId,
                                           String streamDescription, int[] channelPorts,
                                           int[] transportTypes, int sessionType, long timeout,
                                           Object context);

  static native int nativeStopMediaStream(long streamHandle);

  static native int nativeSendMediaStreamData(long streamHandle, int channelPort, long frameIndex,
                                              int frameType,
                                              long frameDuration, long framePts, int bufferSize,
                                              ByteBuffer data);

  static native int[] nativeGetAvailableChannelPorts(String networkId, long deviceNodeId,
                                                     int portCount);

  static native String nativeGetHandlingNetworkId(long streamHandle);

  static native long nativeGetHandlingDeviceId(long streamHandle);

  static native String nativeGetHandlingResourceId(long streamHandle);

  static native long nativeGetHandlingStreamId(long streamHandle);

  static native int nativeGetHandlingStreamSessionId(long streamHandle);

  static native int[] nativeGetHandlingChannelPorts(long streamHandle);

  static native int nativeSetConnectivityMode(int mode);

  static native int nativeCaptureSnapshot(String networkId, long deviceNodeId, String resourceEui,
                                          String downloadPath, int heightPx, int widthPx,
                                          long timeout, Object context);

  static native int nativeInvalidateAccessToken();

  static native String nativeGetVersion();

  static native int nativeInformNetworkChange();

  static native int nativeSendContentInfo(String networkId, long contentTime, String data,
                                          long[] nodeIds);

  static native int nativeSendData(String networkId, String data, long[] nodeIds);
}
