/*
 * @authors   Rohan Sahay, rohansahay@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

import java.nio.ByteBuffer;

@SuppressWarnings("unused")
class NativeCallbacks {

  private static final String TAG = "NativeCallbacks";

  static Object longToObj(long val) {
    return val;
  }

  static Object boolToObj(boolean val) {
    return val;
  }

  static Object doubleToObj(double val) {
    return val;
  }

  static Object createNetworkArray(int size) {
    return new Network[size];
  }

  static Object createNetwork(String id, String name, int netType, int userRole, int accessType) {
    try {
      Network network = Factory.createNetwork(id);

      network.internalSetName(name);
      network.internalSetNetworkType(Network.NetworkType.getEnum(netType));
      network.internalSetUserRole(Network.UserRole.getEnum(userRole));
      network.internalSetAccessType(Network.AccessType.getEnum(accessType));

      return network;
    } catch (Throwable tr) {
      logAndRaiseError(tr);
      throw new IllegalArgumentException(tr);
    }
  }

  static void connectStatusCallback(String networkId, int networkState,
                                    Object nativeNetworkContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .connectStatusCallback(networkId, networkState, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void leaveNetworkStatusCallback(int status, Object nativeContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .leaveNetworkStatusCallback(status, nativeContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void deviceInfoCallback(boolean trigger, boolean append, String networkId,
                                 long deviceNodeId, String name, String devicePsn,
                                 String productName,
                                 String make, String model, String firmwareVersion, int powerSource,
                                 int receiverType, boolean extendable,
                                 int[] protocolsSupported, String[] resourceEuis,
                                 Object nativeNetworkContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .deviceInfoCallback(trigger, append, networkId, deviceNodeId, name, devicePsn,
              productName, make, model, firmwareVersion, powerSource, receiverType, extendable,
              protocolsSupported, resourceEuis, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void resourceSummaryCallback(boolean trigger, String networkId, long deviceNodeId,
                                      String resourceEui, String name, String metadata,
                                      String manufacturer, String model, String firmware,
                                      int powerSource, int receiverType,
                                      Object nativeNetworkContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .resourceSummaryCallback(trigger, networkId, deviceNodeId, resourceEui, name, metadata,
              manufacturer, model, firmware, powerSource, receiverType, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void resourceCapabilityCallback(boolean trigger, String networkId, long deviceNodeId,
                                         String resourceEui,
                                         int capabilityId, String name, int[] standardCommandArr,
                                         Object nativeNetworkContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .resourceCapabilityCallback(trigger, networkId, deviceNodeId, resourceEui, capabilityId,
              name, standardCommandArr, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void resourceAttributeCallback(boolean trigger, String networkId, long deviceNodeId,
                                        String resourceEui, int capabilityId,
                                        int attributeId, String name, String description,
                                        long minReportingInterval, long maxReportingInterval,
                                        int dataType, int arrayLength, Object minValue,
                                        Object maxValue, Object defaultValue,
                                        Object currentValue, boolean realtimeUpdate,
                                        Object nativeNetworkContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .resourceAttributeCallback(trigger, networkId, deviceNodeId, resourceEui, capabilityId,
              attributeId, name, description, minReportingInterval, maxReportingInterval, dataType,
              arrayLength, minValue, maxValue, defaultValue, currentValue, realtimeUpdate,
              nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void commandStatusCallback(int status, String responseJson, Object nativeNetworkContext,
                                    Object nativeCommandContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .commandStatusCallback(status, responseJson, nativeNetworkContext, nativeCommandContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void networkListCallback(String[] networkIds, String[] networkNames, int[] netTypes,
                                  int[] userRoles, int[] accessTypes, Object nativeRequestContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .networkListCallback(networkIds, networkNames, netTypes, userRoles, accessTypes,
              nativeRequestContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void authCallback(String authorizationEndpoint, String tokenEndpoint) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .authCallback(authorizationEndpoint, tokenEndpoint);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void deviceManagementStatusCallback(String networkId, long deviceNodeId, int status,
                                             String[] impactedResourcesEuiArr,
                                             Object nativeNetworkContext,
                                             Object nativeCommandContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .deviceManagementStatusCallback(networkId, deviceNodeId, status, impactedResourcesEuiArr,
              nativeNetworkContext, nativeCommandContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void infoResponseStatusCallback(int status, Object nativeContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .infoResponseStatusCallback(status, nativeContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void infoRequestCallback(String networkId, long requestNodeId, long responseNodeId,
                                  long requestId, long cmdSeqNum,
                                  String infoRequestJson, Object nativeNetworkContext,
                                  Object nativeCommandContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .infoRequestCallback(networkId, requestNodeId, responseNodeId, requestId, cmdSeqNum,
              infoRequestJson, nativeNetworkContext, nativeCommandContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void infoResponseCallback(String networkId, long requestNodeId, long requestId,
                                   long cmdSeqNum,
                                   String infoResponseJson, Object nativeNetworkContext,
                                   Object nativeCommandContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .infoResponseCallback(networkId, requestNodeId, requestId, cmdSeqNum, infoResponseJson,
              nativeNetworkContext, nativeCommandContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void infoRequestStatusCallback(int status, Object nativeContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .infoRequestStatusCallback(status, nativeContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void messageCallback(String title, String message, int messageType,
                              Object nativeNetworkContext, Object nativeCommandContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .messageCallback(title, message, messageType, nativeNetworkContext, nativeCommandContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void advertiseResourceCallback(String networkId, long deviceNodeId, String resourceEui,
                                        String resourceName, int protocol,
                                        Object nativeNetworkContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .advertiseResourceCallback(networkId, deviceNodeId, resourceEui, resourceName, protocol,
              nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void resourceIncludedCallback(String networkId, long[] deviceNodeIds,
                                       String[] resourceEuis, Object nativeNetworkContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .resourceIncludedCallback(networkId, deviceNodeIds, resourceEuis, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void resourceExcludedCallback(String networkId, long deviceNodeId, String resourceEui,
                                       Object nativeNetworkContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .resourceExcludedCallback(networkId, deviceNodeId, resourceEui, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void tunnelStatusCallback(long tunnelHandle, int status, int port,
                                   Object nativeTunnelContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .tunnelStatusCallback(tunnelHandle, status, port, nativeTunnelContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void zoneInfoCallback(boolean trigger, String networkId, int zoneId, String zoneName,
                               long[] deviceNodeIds, String[] resourceEuis, String[] resourceNames,
                               Object context) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .zoneInfoCallback(trigger, networkId, zoneId, zoneName, deviceNodeIds, resourceEuis,
              resourceNames, context);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void zoneDeletedCallback(String networkId, int zoneId, Object context) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .zoneDeletedCallback(networkId, zoneId, context);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void sceneInfoCallback(boolean trigger, String networkId, int sceneId, String sceneName,
                                String metadata, String[] resourceCommands, Object context) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .sceneInfoCallback(trigger, networkId, sceneId, sceneName, metadata, resourceCommands,
              context);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void sceneDeletedCallback(String networkId, int sceneId, Object context) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .sceneDeletedCallback(networkId, sceneId, context);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void ruleInfoCallback(boolean trigger, String networkId, int ruleId, String ruleName,
                               String[] resourceConditions, String[] scheduleConditions,
                               String[] resourceActions, String[] sceneActions,
                               Object nativeContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .ruleInfoCallback(trigger, networkId, ruleId, ruleName, resourceConditions,
              scheduleConditions, resourceActions, sceneActions, nativeContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void ruleDeletedCallback(String networkId, int ruleId, Object nativeContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .ruleDeletedCallback(networkId, ruleId, nativeContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void networkManagementStatusCallback(String networkId, int commandStatus, int errorCode,
                                              String errorMessage, String fieldName,
                                              Object commandContext,
                                              Object networkContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .networkManagementStatusCallback(networkId, commandStatus, errorCode, errorMessage,
              fieldName, commandContext, networkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void accessTokenCallback(String accessToken, int status, Object context) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .accessTokenCallback(accessToken, status, context);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void nodeConnectionStatusCallback(String networkId, long nodeId, int nativeNodeType,
                                           boolean isOnline, Object nativeContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .nodeConnectionStatusCallback(networkId, nodeId, nativeNodeType, isOnline, nativeContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void networkDataCallback(String networkId, int[] resTempZoneIds, String[] resTempIds,
                                  String[] resTempNames, String[] resTempIcons, long[] deviceIds,
                                  int[] zoneIds, int[] sceneIds, int[] ruleIds, Object context) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .networkDataCallback(networkId, resTempZoneIds, resTempIds, resTempNames, resTempIcons,
              deviceIds, zoneIds, sceneIds, ruleIds, context);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void mediaStreamStatusCallback(long streamHandle, int channelPort, int status,
                                        Object networkContext, Object streamContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .mediaStreamStatusCallback(streamHandle, channelPort, status, networkContext,
              streamContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void mediaStreamReceiveCallback(long streamHandle, int channelPort, long frameIndex,
                                         int frameType, long frameDuration, long framePts,
                                         ByteBuffer data, Object networkContext,
                                         Object streamContext) {

    try {
      CocoClient.getInstance().getCallbacksHandler()
          .mediaStreamReceiveCallback(streamHandle, channelPort, frameIndex, frameType,
              frameDuration, framePts, data, networkContext, streamContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void snapshotReceiveCallback(String filePath, int status, Object snapshotContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .snapshotReceiveCallback(filePath, status, snapshotContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void receiveDataCallback(long sourceNodeId, String data, Object nativeNetworkContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .receiveDataCallback(sourceNodeId, data, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void contentInfoCallback(long sourceNodeId, long contentTimestamp, String data,
                                  Object nativeNetworkContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .contentInfoCallback(sourceNodeId, contentTimestamp, data, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void networkMetadataCallback(String metadata, Object nativeNetworkContext) {
    try {
      CocoClient.getInstance().getCallbacksHandler()
          .networkMetadataCallback(metadata, nativeNetworkContext);
    } catch (Throwable tr) {
      logAndRaiseError(tr);
    }
  }

  static void logAndRaiseError(Throwable tr) {
    Log.e(TAG, "logAndRaiseError: error", tr);

    Exception ex;

    if (tr instanceof Exception) {
      ex = (Exception) tr;
    } else {
      ex = new Exception(tr);
    }

    try {
      CocoClient.getInstance().getCallbacksHandler().errorCallback(ex);
    } catch (Throwable throwable) {
      // ignored
    }
  }
}
