/*
 * @authors   Krishna, krishnasarma@elear.solutions
 *            Akshay Mende, akshaymende@elear.solutions
 *
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

import java.nio.ByteBuffer;

abstract class NativeCallbacksInterface {

  protected abstract void connectStatusCallback(String networkId, int networkState,
                                                Object nativeNetworkContext);

  protected abstract void leaveNetworkStatusCallback(int status, Object nativeContext);

  protected abstract void deviceInfoCallback(boolean trigger, boolean append, String networkId,
                                             long deviceNodeId, String name, String devicePsn,
                                             String productName, String make, String model,
                                             String firmwareVersion, int powerSource,
                                             int receiverType,
                                             boolean extendable, int[] protocolsSupported,
                                             String[] resourceEuis, Object nativeNetworkContext);

  protected abstract void resourceSummaryCallback(boolean trigger, String networkId,
                                                  long deviceNodeId, String resourceEui,
                                                  String name,
                                                  String metadata, String manufacturer,
                                                  String model, String firmware, int powerSource,
                                                  int receiverType, Object nativeNetworkContext);

  protected abstract void resourceCapabilityCallback(boolean trigger, String networkId,
                                                     long deviceNodeId, String resourceEui,
                                                     int capabilityId, String name,
                                                     int[] standardCommandArr,
                                                     Object nativeNetworkContext);

  protected abstract void resourceAttributeCallback(boolean trigger, String networkId,
                                                    long deviceNodeId, String resourceEui,
                                                    int capabilityId,
                                                    int attributeId, String name,
                                                    String description, long minReportingInterval,
                                                    long maxReportingInterval,
                                                    int dataType, int arrayLength, Object minValue,
                                                    Object maxValue, Object defaultValue,
                                                    Object currentValue, boolean realtimeUpdate,
                                                    Object nativeNetworkContext);

  protected abstract void commandStatusCallback(int status, String responseJson,
                                                Object nativeNetworkContext,
                                                Object nativeCommandContext);

  protected abstract void networkListCallback(String[] networkIds, String[] networkNames,
                                              int[] netTypes,
                                              int[] userRoles, int[] accessTypes,
                                              Object nativeRequestContext);

  protected abstract void authCallback(String authorizationEndpoint, String tokenEndpoint);

  protected abstract void deviceManagementStatusCallback(String networkId, long deviceNodeId,
                                                         int status,
                                                         String[] impactedResourcesEuiArr,
                                                         Object nativeNetworkContext,
                                                         Object nativeCommandContext);

  protected abstract void infoResponseStatusCallback(int status, Object nativeContext);

  protected abstract void infoRequestCallback(String networkId, long requestNodeId,
                                              long responseNodeId, long requestId, long cmdSeqNum,
                                              String infoRequestJson, Object nativeNetworkContext,
                                              Object nativeCommandContext);

  protected abstract void infoResponseCallback(String networkId, long requestNodeId, long requestId,
                                               long cmdSeqNum,
                                               String infoResponseJson, Object nativeNetworkContext,
                                               Object nativeCommandContext);

  protected abstract void infoRequestStatusCallback(int status, Object nativeContext);

  protected abstract void messageCallback(String title, String message, int messageType,
                                          Object nativeNetworkContext, Object nativeCommandContext);

  protected abstract void advertiseResourceCallback(String networkId, long deviceNodeId,
                                                    String resourceEui,
                                                    String resourceName, int protocol,
                                                    Object nativeNetworkContext);

  protected abstract void resourceIncludedCallback(String networkId, long[] deviceNodeIds,
                                                   String[] resourceEuis,
                                                   Object nativeNetworkContext);

  protected abstract void resourceExcludedCallback(String networkId, long deviceNodeId,
                                                   String resourceEui, Object nativeNetworkContext);

  protected abstract void tunnelStatusCallback(long tunnelHandle, int status, int port,
                                               Object nativeTunnelContext);

  protected abstract void zoneInfoCallback(boolean trigger, String networkId, int zoneId,
                                           String zoneName,
                                           long[] deviceNodeIds, String[] resourceEuis,
                                           String[] resourceNames, Object context);

  protected abstract void zoneDeletedCallback(String networkId, int zoneId, Object context);

  protected abstract void sceneInfoCallback(boolean trigger, String networkId, int sceneId,
                                            String sceneName,
                                            String metadata, String[] resourceCommands,
                                            Object context);

  protected abstract void sceneDeletedCallback(String networkId, int sceneId, Object context);

  protected abstract void ruleInfoCallback(boolean trigger, String networkId, int ruleId,
                                           String ruleName,
                                           String[] resourceConditions, String[] scheduleConditions,
                                           String[] resourceActions, String[] sceneActions,
                                           Object nativeContext);

  protected abstract void ruleDeletedCallback(String networkId, int ruleId, Object nativeContext);

  protected abstract void accessTokenCallback(String accessToken, int status, Object context);

  protected abstract void networkManagementStatusCallback(String networkId, int commandStatus,
                                                          int errorCode,
                                                          String errorMessage, String fieldName,
                                                          Object commandContext,
                                                          Object networkContext);

  protected abstract void nodeConnectionStatusCallback(String networkId, long nodeId,
                                                       int nativeNodeType, boolean isOnline,
                                                       Object nativeContext);

  protected abstract void errorCallback(Exception exception);

  protected abstract void networkDataCallback(String networkId, int[] resTempZoneIds,
                                              String[] resTempIds,
                                              String[] resTempNames, String[] resTempIcons,
                                              long[] deviceIds,
                                              int[] zoneIds, int[] sceneIds, int[] ruleIds,
                                              Object context);

  protected abstract void mediaStreamStatusCallback(long streamHandle, int channelPort, int status,
                                                    Object networkContext, Object streamContext);

  protected abstract void snapshotReceiveCallback(String filePath, int status,
                                                  Object snapshotContext);

  protected abstract void mediaStreamReceiveCallback(long streamHandle, int channelPort,
                                                     long frameIndex,
                                                     int frameType, long frameDuration,
                                                     long framePts,
                                                     ByteBuffer data, Object networkContext,
                                                     Object streamContext);

  protected abstract void receiveDataCallback(long sourceNodeId, String data,
                                              Object nativeNetworkContext);

  protected abstract void contentInfoCallback(long sourceNodeId, long contentTimestamp, String data,
                                              Object nativeNetworkContext);

  protected abstract void networkMetadataCallback(String metadata, Object nativeNetworkContext);
}
