/*
 * @authors   Krishna, krishnasarma@elear.solutions
 *            Akshay Mende, akshaymende@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

import java.nio.ByteBuffer;

/**
 * This interface mimics signatures for api methods in {@link Native}.
 */
public abstract class NativeInterface {

  protected abstract void init(String cwdPath, String appAccessList, String clientId,
                               String downloadPath, CocoClient.ConnectivityTimers timers);

  protected abstract Network[] getSavedNetworks();

  protected abstract void getAllNetworks(CocoClient.NetworkListListener listener);

  protected abstract void connect(Network network, int port);

  protected abstract void disconnect(Network network);

  protected abstract void leaveNetwork(Network network, Network.LeaveStatusListener listener);

  protected abstract void sendInfoResponse(InfoResponse infoResponse,
                                           Device.InfoResponseStatusListener listener);

  protected abstract void sendResourceCommand(Capability capability,
                                              Command<? extends Capability.CommandId> command,
                                              Capability.CommandStatusListener<?> listener);

  protected abstract void setTokens(String response);

  protected abstract void openTunnel(Capability tunnel, String forwardHostName, int forwardHostPort,
                                     String listeningHostName, int listeningHostPort,
                                     CapabilityTunnel.IpVersion ipVersion,
                                     CapabilityTunnel.Protocol tunnelProtocol,
                                     CapabilityTunnel.TunnelType tunnelType,
                                     CapabilityTunnel.TransportType transportType, long timeout,
                                     CapabilityTunnel.TunnelStatusListener listener);

  protected abstract void closeTunnel(Capability tunnel, long tunnelHandle, long timeout);

  protected abstract void getAccessTokens(CocoClient.AccessTokensListener listener);

  protected abstract void sendNetworkManagementCommand(
      Network network, Command<Network.CommandId> command,
      Network.NetworkManagementStatusListener listener);

  protected abstract void sendDeviceManagementCommand(
      Device device, Command<Device.CommandId> command,
      Device.DeviceManagementStatusListener listener);

  protected abstract void executeScene(Scene scene);

  protected abstract void connectWithInvite(Network network, String inviteUrl, long nodeId);

  protected abstract void sendInfoRequest(InfoRequest infoRequest,
                                          Device.InfoRequestStatusListener listener);

  protected abstract void startMediaStream(Capability capability, long streamId,
                                           int streamSessionId, String streamDescription,
                                           int[] channelPorts,
                                           CapabilityMediaStreaming.TransportType[] transportTypes,
                                           CapabilityMediaStreaming.MediaSessionType sessionType,
                                           long timeout,
                                           CapabilityMediaStreaming.MediaStreamListener listener);

  protected abstract void stopMediaStream(long streamHandle);

  protected abstract void captureSnapshot(Capability capability, String downloadPath, int heightPx,
                                          int widthPx, long timeout,
                                          CapabilitySnapshot.SnapshotListener listener);

  protected abstract int sendMediaStreamData(long streamHandle, int channelPort, long frameIndex,
                                             int frameType, long frameDuration, long framePts,
                                             ByteBuffer data);

  protected abstract int[] getAvailableChannelPorts(Device device, int portCount);

  protected abstract Resource getHandlingResource(long streamHandle);

  protected abstract long getHandlingStreamId(long streamHandle);

  protected abstract int getHandlingStreamSessionId(long streamHandle);

  protected abstract int[] getHandlingChannelPorts(long streamHandle);

  protected abstract void setConnectivityMode(CocoClient.ConnectivityMode mode);

  protected abstract void invalidateAccessToken();

  protected abstract String getVersion();

  protected abstract void informNetworkChange();

  protected abstract void sendData(Network network, String data, long[] nodeIds);

  protected abstract void sendContentInfo(Network network, long contentTime, String data,
                                          long[] nodeIds);
}
