/*
 * @author    Krishna, krishnasarma@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

/**
 * This is an interface to be implemented by the developer to provide custom
 * values to the cwdPath, clientId, etc.
 */
public interface PlatformInterface {
  String getCwdPath();

  String getClientId();

  String getAppAccessList();

  void authCallback(String authorizationEndpoint, String tokenEndpoint);

  default void accessTokensCallback(String token, Command.State status) {
  }

  default String getDownloadPath() {
    return getCwdPath();
  }
}
