/*
 * @author    Krishna, krishnasarma@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

/**
 * The enum denoting the power source of the resource.
 */
public enum PowerSource {
  UNKNOWN,
  MAINS_SINGLE_PHASE,
  MAINS_3_PHASE,
  MAINS_UNKNOWN_PHASE,
  BATTERY,
  DC_SOURCE,
  EMERGENCY_CONST_POWER,
  EMERGENCY_TRANSFER_SWITCH,
  NOT_AVAILABLE;

  static PowerSource getEnum(int index) {
    return Utils.findEnum(index, values());
  }

  int getInt() {
    return ordinal();
  }
}
