/*
 * @author    Krishna, krishnasarma@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

/**
 * This is the RadioProtocol class which represents the radio type of
 * resource and the protocols supported by the device.
 */
public enum RadioProtocol {
  ZWAVE,
  ZIGBEE,
  TUYA;

  static RadioProtocol getEnum(int index) {
    return Utils.findEnum(index, values());
  }

  public int getInt() {
    return ordinal();
  }

  private static final class RadioProtocolParser implements JsonSerializer<RadioProtocol>,
      JsonDeserializer<RadioProtocol> {

    @Override
    public RadioProtocol deserialize(JsonElement json, Type typeOfT,
                                     JsonDeserializationContext context) throws
        JsonParseException {
      int protocol = json.getAsInt();
      return getEnum(protocol);
    }

    @Override
    public JsonElement serialize(RadioProtocol radioProtocol, Type typeOfSrc,
                                 JsonSerializationContext context) {
      return new JsonPrimitive(radioProtocol.getInt());
    }
  }

  static void init() {
    Command.GSON_BUILDER.registerTypeAdapter(RadioProtocol.class, new RadioProtocolParser());
  }
}
