/*
 * @authors   Krishna, krishnasarma@elear.solutions
 *            Akshay Mende, akshaymende@elear.solutions
 * @copyright Copyright (c) 2019-2020 Elear Solutions Tech Private Limited. All rights
 *            reserved.
 * @license   To any person (the "Recipient") obtaining a copy of this software and
 *            associated documentation files (the "Software"):\n
 *            All information contained in or disclosed by this software is
 *            confidential and proprietary information of Elear Solutions Tech
 *            Private Limited and all rights therein are expressly reserved.
 *            By accepting this material the recipient agrees that this material and
 *            the information contained therein is held in confidence and in trust
 *            and will NOT be used, copied, modified, merged, published, distributed,
 *            sublicensed, reproduced in whole or in part, nor its contents revealed
 *            in any manner to others without the express written permission of
 *            Elear Solutions Tech Private Limited.
 */

package buzz.getcoco.iot;

/**
 * Exception carrying status of the command.
 */
public class StateException extends Exception {

  private static final long serialVersionUID = 6610331834166722969L;

  private final Command.State state;

  /**
   * Constructor for this exception.
   *
   * @param state state of the command (networkManagement/deviceManagement/resourceManagement)
   */
  public StateException(Command.State state) {
    super(String.valueOf(state));

    this.state = state;
  }

  public Command.State getState() {
    return state;
  }
}
