/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.DataTypeFormatter;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;

public class Attribute {
    @SerializedName(value="attributeId")
    private final int id;
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private String description;
    @SerializedName(value="attributeDataType")
    private DataType dataType;
    @SerializedName(value="arrayLength")
    private int arrayLength;
    @SerializedName(value="minValue")
    private Object minValue;
    @SerializedName(value="maxValue")
    private Object maxValue;
    @SerializedName(value="defaultValue")
    private Object defaultValue;
    @SerializedName(value="value")
    private Object currentValue;
    @SerializedName(value="minReportingInterval")
    private long minReportingInterval;
    @SerializedName(value="maxReportingInterval")
    private long maxReportingInterval;
    private transient boolean isRealTimeUpdate = false;
    private transient boolean ready = false;
    private transient Capability parent;

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(DataType.class, (Object)new DataTypeParser());
    }

    protected Attribute(int id, Capability parent) {
        this.id = id;
        this.parent = parent;
        this.dataType = null;
    }

    public final int getMapKey() {
        return this.id;
    }

    public final Capability.AttributeId getId() {
        return this.parent.getId().getAttributeId(this.id);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public Capability getParent() {
        return this.parent;
    }

    public long getMaxReportingInterval() {
        return this.maxReportingInterval;
    }

    public long getMinReportingInterval() {
        return this.minReportingInterval;
    }

    public int getArrayLength() {
        return this.arrayLength;
    }

    public <T> T getElement(int position) {
        Object value = null;
        Object currentValue = this.getCurrentValue();
        if (currentValue instanceof boolean[]) {
            value = ((boolean[])currentValue)[position];
        }
        if (currentValue instanceof int[]) {
            value = ((int[])currentValue)[position];
        }
        if (currentValue instanceof long[]) {
            value = ((long[])currentValue)[position];
        }
        if (currentValue instanceof float[]) {
            value = Float.valueOf(((float[])currentValue)[position]);
        }
        if (currentValue instanceof double[]) {
            value = ((double[])currentValue)[position];
        }
        if (currentValue instanceof String[]) {
            value = ((String[])currentValue)[position];
        }
        return (T)Utils.castUp(value);
    }

    public final boolean isRealTimeUpdate() {
        return this.isRealTimeUpdate;
    }

    protected final void internalSetRealtimeUpdate(boolean isRealTimeUpdate) {
        this.isRealTimeUpdate = isRealTimeUpdate;
    }

    protected void internalSetName(String name) {
        this.name = name;
    }

    protected void internalSetDescription(String description) {
        this.description = description;
    }

    protected void internalSetDataType(int dataType) {
        this.dataType = DataType.getEnum(dataType);
    }

    protected void internalSetArrayLength(int arrayLength) {
        this.arrayLength = arrayLength;
    }

    protected void internalSetMinValue(Object minValue) {
        this.minValue = minValue;
    }

    protected void internalSetMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    protected void internalSetCurrentValue(Object currentValue) {
        this.currentValue = currentValue;
    }

    protected void internalSetDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected void internalSetMinReportingInterval(long minReportingInterval) {
        this.minReportingInterval = minReportingInterval;
    }

    protected void internalSetMaxReportingInterval(long maxReportingInterval) {
        this.maxReportingInterval = maxReportingInterval;
    }

    protected void internalMarkAsReady() {
        this.ready = true;
    }

    public String getAsString() {
        Object currentValue = this.getCurrentValue();
        return currentValue instanceof String ? (String)currentValue : null;
    }

    public boolean isStringValue() {
        return this.getCurrentValue() instanceof String;
    }

    public Number getAsNumber() {
        Object currentValue = this.getCurrentValue();
        return currentValue instanceof Number ? (Number)((Number)currentValue) : (Number)null;
    }

    public boolean isNumberValue() {
        return this.getCurrentValue() instanceof Number;
    }

    public boolean isBooleanValue() {
        return this.getCurrentValue() instanceof Boolean;
    }

    public Boolean getAsBoolean() {
        Object currentValue = this.getCurrentValue();
        return currentValue instanceof Boolean ? (Boolean)currentValue : null;
    }

    public Number[] getAsNumberArr() {
        Object[] castVal;
        Object currentValue = this.getCurrentValue();
        if (null == currentValue) {
            return null;
        }
        ArrayList<Number> retVal = new ArrayList<Number>(this.arrayLength);
        if (currentValue instanceof int[]) {
            for (int val : castVal = (int[])currentValue) {
                retVal.add(val);
            }
        }
        if (currentValue instanceof long[]) {
            for (int val : castVal = (Object[])((long[])currentValue)) {
                retVal.add(Long.valueOf(val));
            }
        }
        if (currentValue instanceof float[]) {
            int[] nArray = castVal = (Object[])((float[])currentValue);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                double val = nArray[i];
                retVal.add(val);
            }
        }
        if (currentValue instanceof double[]) {
            for (int val : castVal = (Object[])((double[])currentValue)) {
                retVal.add(Double.valueOf(val));
            }
        }
        return retVal.toArray(new Number[0]);
    }

    public boolean[] getAsBooleanArr() {
        Object currentValue = this.getCurrentValue();
        boolean[] castVal = currentValue instanceof boolean[] ? (boolean[])currentValue : null;
        return null == castVal ? null : Arrays.copyOf(castVal, castVal.length);
    }

    public String[] getAsStringArr() {
        Object currentValue = this.getCurrentValue();
        String[] castVal = currentValue instanceof String[] ? (String[])currentValue : null;
        return null == castVal ? null : Arrays.copyOf(castVal, castVal.length);
    }

    protected void internalSetParent(Capability parent) {
        this.parent = parent;
    }

    public String toString() {
        return "Attribute{id=" + (null != this.getParent() ? this.getId() : Integer.valueOf(this.getMapKey())) + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", dataType=" + (Object)((Object)this.dataType) + ", arrayLength=" + this.arrayLength + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", defaultValue=" + this.defaultValue + ", currentValue=" + this.currentValue + ", minReportingInterval=" + this.minReportingInterval + ", maxReportingInterval=" + this.maxReportingInterval + ", ready=" + this.ready + '}';
    }

    public boolean isReady() {
        return this.parent.isReady() && this.ready;
    }

    public final int hashCode() {
        return this.getMapKey();
    }

    public static enum DataType {
        BOOLEAN,
        BOOLEAN_ARR,
        STRING,
        STRING_ARR,
        UINT8,
        UINT8_ARR,
        UINT16,
        UINT16_ARR,
        UINT32,
        UINT32_ARR,
        UINT64,
        UINT64_ARR,
        INT8,
        INT8_ARR,
        INT16,
        INT16_ARR,
        INT32,
        INT32_ARR,
        INT64,
        INT64_ARR,
        FLOAT,
        FLOAT_ARR,
        DOUBLE,
        DOUBLE_ARR,
        JSON,
        JSON_ARR;


        static DataType getEnum(int index) {
            return (DataType)Utils.findEnum((int)index, (Enum[])DataType.values());
        }

        int getInt() {
            return this.ordinal();
        }

        public DataTypeFormatter.SimpleDataType toSimpleDataType() {
            switch (this) {
                case JSON: 
                case STRING: {
                    return DataTypeFormatter.SimpleDataType.STRING;
                }
                case BOOLEAN: {
                    return DataTypeFormatter.SimpleDataType.BOOLEAN;
                }
                case BOOLEAN_ARR: {
                    return DataTypeFormatter.SimpleDataType.BOOLEAN_ARR;
                }
                case JSON_ARR: 
                case STRING_ARR: {
                    return DataTypeFormatter.SimpleDataType.STRING_ARR;
                }
                case UINT8: 
                case UINT16: 
                case UINT32: 
                case UINT64: 
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: 
                case FLOAT: 
                case DOUBLE: {
                    return DataTypeFormatter.SimpleDataType.NUMBER;
                }
                case UINT8_ARR: 
                case UINT16_ARR: 
                case UINT32_ARR: 
                case UINT64_ARR: 
                case INT8_ARR: 
                case INT16_ARR: 
                case INT32_ARR: 
                case INT64_ARR: 
                case FLOAT_ARR: 
                case DOUBLE_ARR: {
                    return DataTypeFormatter.SimpleDataType.NUMBER_ARR;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class DataTypeParser
    implements JsonSerializer<DataType>,
    JsonDeserializer<DataType> {
        private DataTypeParser() {
        }

        public DataType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int dataType = json.getAsInt();
            return DataType.getEnum(dataType);
        }

        public JsonElement serialize(DataType dataType, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)dataType.getInt());
        }
    }
}

