/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.CapabilityWrapper;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandIdInterface;
import buzz.getcoco.iot.CommandResponse;
import buzz.getcoco.iot.IdProvider;
import buzz.getcoco.iot.Listener;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Capability
implements Iterable<Attribute> {
    @SerializedName(value="capabilityId")
    private final CapabilityId id;
    @SerializedName(value="capabilityName")
    private String name;
    @SerializedName(value="commandArray")
    private final Set<Integer> standardCommandSet = new HashSet<Integer>();
    private transient Resource parent;
    private transient boolean ready = false;
    @SerializedName(value="attributeMap")
    private Map<Integer, Attribute> attributeMap;
    private transient CapabilityWrapper capabilityWrapper = null;

    protected Capability(int id, Resource parent) {
        this.id = CapabilityId.getEnum(id);
        this.parent = parent;
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(CapabilityId.class, (Object)new CapabilityIdParser());
    }

    protected <T extends CommandId> void interceptCommand(Command<T> command) {
    }

    public final <T extends CommandId> void sendResourceCommand(Command<T> command, CommandStatusListener<T> listener) {
        this.interceptCommand(command);
        CocoClient.getInstance().getNativeHandler().sendResourceCommand(this, command, listener);
    }

    public boolean supports(CommandId commandId) {
        if (!this.ready) {
            return false;
        }
        if (null == commandId) {
            return this.standardCommandSet.size() > 0;
        }
        return this.standardCommandSet.contains(commandId.getInt());
    }

    public final CapabilityId getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final Resource getParent() {
        return this.parent;
    }

    public Map<Integer, Attribute> getAttributeMap() {
        if (null == this.attributeMap) {
            this.attributeMap = new ConcurrentHashMap<Integer, Attribute>();
        }
        return this.attributeMap;
    }

    public <T extends Attribute> T getAttribute(int attributeId) {
        return (T)((Attribute)Utils.castUp(this.getAttributeMap().get(attributeId)));
    }

    public <T extends Attribute> T getAttribute(AttributeId attributeId) {
        if (this.getAttributeId(attributeId.getInt()) != attributeId) {
            throw new IllegalArgumentException("invalid id: " + attributeId);
        }
        return this.getAttribute(attributeId.getInt());
    }

    protected boolean containsAttribute(int attributeId) {
        return this.getAttributeMap().containsKey(attributeId);
    }

    public boolean containsAttribute(AttributeId attributeId) {
        return this.containsAttribute(attributeId.getInt());
    }

    protected void internalAddAttribute(Attribute attribute) {
        this.getAttributeMap().put(attribute.getMapKey(), attribute);
        CapabilityWrapper wrapper = this.getCapabilityWrapper();
        if (null != wrapper) {
            wrapper.internalAddAttribute(attribute);
        }
    }

    protected void internalRemoveAttribute(int attributeId) {
        this.getAttributeMap().remove(attributeId);
        CapabilityWrapper wrapper = this.getCapabilityWrapper();
        if (null != wrapper) {
            wrapper.internalRemoveAttribute(attributeId);
        }
    }

    protected void internalSetParent(Resource parent) {
        this.parent = parent;
        CapabilityWrapper wrapper = this.getCapabilityWrapper();
        if (null != wrapper) {
            wrapper.internalSetParent(parent);
        }
    }

    public void setCapabilityWrapper(CapabilityWrapper capabilityWrapper) {
        if (null == capabilityWrapper) {
            throw new NullPointerException();
        }
        this.capabilityWrapper = capabilityWrapper;
    }

    public CapabilityWrapper getCapabilityWrapper() {
        return this.capabilityWrapper;
    }

    public final int hashCode() {
        return this.getId().ordinal();
    }

    private AttributeId getAttributeId(int id) {
        return this.getId().getAttributeId(id);
    }

    private CommandId getCommandId(int id) {
        return this.getId().getCommandId(id);
    }

    public List<CommandId> getSupportedCommands() {
        ArrayList<CommandId> commands = new ArrayList<CommandId>();
        for (int rawCommand : this.standardCommandSet) {
            commands.add(this.getCommandId(rawCommand));
        }
        return commands;
    }

    protected abstract Command<? extends CommandId> extendedCreateCommand(int var1, JsonElement var2);

    protected <T extends CommandIdInterface> CommandResponse.Args<T> createCommandResponseArgs(T commandId, JsonElement jsonResponse) {
        return CommandResponse.createEmptyResponseArgs();
    }

    protected Command<? extends CommandId> createCommand(int commandId, JsonElement commandParams) {
        Command<? extends CommandId> generatedCommand;
        if (null == commandParams) {
            commandParams = new JsonObject();
        }
        if (null != (generatedCommand = this.extendedCreateCommand(commandId, commandParams))) {
            generatedCommand.setCommandId(this.getCommandId(commandId));
        }
        return generatedCommand;
    }

    public boolean isReady() {
        return this.parent.isReady() && this.ready;
    }

    protected void internalSetName(String name) {
        this.name = name;
        CapabilityWrapper wrapper = this.getCapabilityWrapper();
        if (null != wrapper) {
            wrapper.internalSetName(name);
        }
    }

    protected void clearAndSetStandardCommandSet(int[] commands) {
        if (null == commands) {
            return;
        }
        this.standardCommandSet.clear();
        for (int command : commands) {
            this.standardCommandSet.add(command);
        }
        CapabilityWrapper wrapper = this.getCapabilityWrapper();
        if (null != wrapper) {
            wrapper.clearAndSetStandardCommandSet(commands);
        }
    }

    protected void internalMarkAsReady() {
        this.ready = true;
        CapabilityWrapper wrapper = this.getCapabilityWrapper();
        if (null != wrapper) {
            wrapper.markAsReady();
        }
    }

    public String toString() {
        return "Capability{id=" + (Object)((Object)this.id) + ", name='" + this.name + '\'' + ", standardCommandSet=" + this.standardCommandSet + ", ready=" + this.ready + '}';
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.getAttributeMap().values().iterator();
    }

    private static final class CapabilityIdParser
    implements JsonSerializer<CapabilityId>,
    JsonDeserializer<CapabilityId> {
        private CapabilityIdParser() {
        }

        public CapabilityId deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return CapabilityId.getEnum(jsonElement.getAsInt());
        }

        public JsonElement serialize(CapabilityId capabilityId, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)capabilityId.getInt());
        }
    }

    public static interface CommandStatusListener<T extends CommandId>
    extends Listener {
        public void onCommandStatus(CommandResponse<T> var1, Throwable var2);
    }

    public static enum CapabilityId {
        ON_OFF_CONTROL(IdProvider.CAP_ON_OFF_PROVIDER),
        LEVEL_CTRL(IdProvider.CAP_LEVEL_PROVIDER),
        COLOR_CTRL(IdProvider.CAP_COLOR_PROVIDER),
        LOCK_CONTROL(IdProvider.CAP_LOCK_PROVIDER),
        ENERGY_METERING(IdProvider.CAP_ENERGY_PROVIDER),
        MOTION_SENSING(IdProvider.CAP_MOTION_PROVIDER),
        OCCUPANCY_SENSING(IdProvider.CAP_OCCUPANCY_PROVIDER),
        CONTACT_SENSING(IdProvider.CAP_CONTACT_PROVIDER),
        FLUID_LEVEL_MEASUREMENT(IdProvider.CAP_FLUID_PROVIDER),
        FIRE_SENSING(IdProvider.CAP_FIRE_PROVIDER),
        TEMPERATURE_MEASUREMENT(IdProvider.CAP_TEMP_PROVIDER),
        ILLUMINANCE_MEASUREMENT(IdProvider.CAP_LUMINANCE_PROVIDER),
        POWER_LEVEL_MEASUREMENT(IdProvider.CAP_POWER_PROVIDER),
        TUNNEL_CONTROL(IdProvider.CAP_TUNNEL_PROVIDER),
        REL_HUMIDITY_MEASUREMENT(IdProvider.CAP_HUMIDITY_PROVIDER),
        KEY_PRESS_SENSING(IdProvider.CAP_KEY_PRESS_PROVIDER),
        WARNING_DEV_CONTROL(IdProvider.CAP_WARN_PROVIDER),
        NETWORK_CONFIGURATION(IdProvider.CAP_NETWORK_PROVIDER),
        MEDIA_STREAM(IdProvider.CAP_MEDIA_PROVIDER),
        STORAGE_CONFIG(IdProvider.CAP_STORAGE_CONFIG_PROVIDER),
        STORAGE_CONTROL(IdProvider.CAP_STORAGE_CONTROL_PROVIDER),
        MOTOR_CONTROL(IdProvider.CAP_MOTOR_PROVIDER),
        IMAGE_CONTROL(IdProvider.CAP_IMAGE_PROVIDER),
        SNAPSHOT(IdProvider.CAP_SNAP_PROVIDER),
        STATIONARY_POS(IdProvider.CAP_STATIONARY_POS_PROVIDER),
        REAL_TIME_POS(IdProvider.CAP_REAL_TIME_POS_PROVIDER),
        VIBRATION_SENSING(IdProvider.CAP_VIBRATION_PROVIDER),
        AIR_QUALITY_SENSING(IdProvider.CAP_AIR_Q_PROVIDER),
        WINDOW_COVERING(IdProvider.CAP_WINDOW_PROVIDER),
        REMOTE_CONTROL(IdProvider.CAP_REMOTE_PROVIDER),
        HVAC_CONTROL(IdProvider.CAP_HVAC_PROVIDER);

        private final IdProvider provider;

        private CapabilityId(IdProvider provider) {
            this.provider = provider;
        }

        public static CapabilityId getEnum(int index) {
            return (CapabilityId)Utils.findEnum((int)index, (Enum[])CapabilityId.values());
        }

        public int getInt() {
            return this.ordinal();
        }

        public AttributeId getAttributeId(int attrId) {
            return this.provider.getAttributeId(attrId);
        }

        public CommandId getCommandId(int cmdId) {
            return this.provider.getCommandId(cmdId);
        }
    }

    public static interface AttributeId
    extends CommandIdInterface {
        public CapabilityId getCapabilityId();
    }

    public static interface CommandId
    extends CommandIdInterface {
    }
}

