/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityColor
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.COLOR_CTRL;

    protected CapabilityColor(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case SET_COLOR_RGB: {
                command = (Command)gson.fromJson(commandParams, SetRgb.class);
                break;
            }
            case SET_COLOR_HSL: {
                command = (Command)gson.fromJson(commandParams, SetHsl.class);
                break;
            }
            case SET_COLOR_TEMP: {
                command = (Command)gson.fromJson(commandParams, SetTemperature.class);
                break;
            }
            case SET_COLOR_COMPONENTS: {
                command = (Command)gson.fromJson(commandParams, SetColorComponents.class);
                break;
            }
            case GET_COLOR_RGB: {
                command = (Command)gson.fromJson(commandParams, GetRgb.class);
                break;
            }
            case GET_COLOR_HSL: {
                command = (Command)gson.fromJson(commandParams, GetHsl.class);
                break;
            }
            case GET_COLOR_TEMP: {
                command = (Command)gson.fromJson(commandParams, GetColorTemperature.class);
                break;
            }
            case GET_COLOR_COMPONENTS: {
                command = (Command)gson.fromJson(commandParams, GetColorComponents.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class GetColorComponents
    extends Command<CommandId> {
        public GetColorComponents() {
            super(CommandId.GET_COLOR_COMPONENTS);
        }
    }

    public static class GetColorTemperature
    extends Command<CommandId> {
        public GetColorTemperature() {
            super(CommandId.GET_COLOR_TEMP);
        }
    }

    public static class GetHsl
    extends Command<CommandId> {
        public GetHsl() {
            super(CommandId.GET_COLOR_HSL);
        }
    }

    public static class GetRgb
    extends Command<CommandId> {
        public GetRgb() {
            super(CommandId.GET_COLOR_RGB);
        }
    }

    public static class SetColorComponents
    extends Command<CommandId> {
        @SerializedName(value="colorCompIdArr")
        public int[] colorComponentIds;
        @SerializedName(value="colorCompValuesArr")
        public int[] colorComponentsValues;
        @SerializedName(value="useDefaultTransTimeFlag")
        public boolean useDefaultTransitionTime;
        @SerializedName(value="transitionTimeMs")
        public int transitionTime;

        public SetColorComponents(boolean useDefaultTransitionTime) {
            super(CommandId.SET_COLOR_COMPONENTS);
            this.useDefaultTransitionTime = useDefaultTransitionTime;
        }
    }

    public static class SetTemperature
    extends Command<CommandId> {
        @SerializedName(value="colorTemperatureKelvin")
        public int temperatureKelvin;
        @SerializedName(value="useDefaultTransTimeFlag")
        public boolean useDefaultTransitionTime;
        @SerializedName(value="transitionTimeMs")
        public int transitionTime;

        public SetTemperature(boolean useDefaultTransitionTime) {
            super(CommandId.SET_COLOR_TEMP);
            this.useDefaultTransitionTime = useDefaultTransitionTime;
        }
    }

    public static class SetHsl
    extends Command<CommandId> {
        @SerializedName(value="hueDegrees")
        public int hue;
        @SerializedName(value="saturationPct")
        public int saturation;
        @SerializedName(value="luminancePct")
        public int luminance;
        @SerializedName(value="useDefaultTransTimeFlag")
        public boolean useDefaultTransitionTime;
        @SerializedName(value="transitionTimeMs")
        public int transitionTime;

        public SetHsl(boolean useDefaultTransitionTime) {
            super(CommandId.SET_COLOR_HSL);
            this.useDefaultTransitionTime = useDefaultTransitionTime;
        }
    }

    public static class SetRgb
    extends Command<CommandId> {
        @SerializedName(value="red")
        public int red;
        @SerializedName(value="green")
        public int green;
        @SerializedName(value="blue")
        public int blue;
        @SerializedName(value="useDefaultTransTimeFlag")
        public boolean useDefaultTransitionTime;
        @SerializedName(value="transitionTimeMs")
        public int transitionTime;

        public SetRgb(boolean useDefaultTransitionTime) {
            super(CommandId.SET_COLOR_RGB);
            this.useDefaultTransitionTime = useDefaultTransitionTime;
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        SET_COLOR_RGB,
        SET_COLOR_HSL,
        SET_COLOR_TEMP,
        SET_COLOR_COMPONENTS,
        GET_COLOR_RGB,
        GET_COLOR_HSL,
        GET_COLOR_TEMP,
        GET_COLOR_COMPONENTS;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        RED,
        GREEN,
        BLUE,
        HUE_DEGREES,
        SATURATION_PCT,
        LUMINANCE_PCT,
        COLOR_TEMP_KELVIN,
        COMP_ID_ARR,
        COMP_VALUES_ARR,
        COLOR_X,
        COLOR_Y,
        COLOR_MODE,
        HSL,
        RGB;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

