/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityImageControl
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.IMAGE_CONTROL;

    protected CapabilityImageControl(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case SET_AF_MODE: {
                command = (Command)gson.fromJson(commandParams, SetAfMode.class);
                break;
            }
            case SET_AE_MODE: {
                command = (Command)gson.fromJson(commandParams, SetAeMode.class);
                break;
            }
            case SET_AWB_MODE: {
                command = (Command)gson.fromJson(commandParams, SetAwbMode.class);
                break;
            }
            case SET_ZOOM: {
                command = (Command)gson.fromJson(commandParams, SetZoom.class);
                break;
            }
            case SET_IR_CUT_MODE: {
                command = (Command)gson.fromJson(commandParams, SetIrCutMode.class);
                break;
            }
            case SET_PRESET: {
                command = (Command)gson.fromJson(commandParams, SetPreset.class);
                break;
            }
            case SET_HUE: {
                command = (Command)gson.fromJson(commandParams, SetHue.class);
                break;
            }
            case SET_SATURATION: {
                command = (Command)gson.fromJson(commandParams, SetSaturation.class);
                break;
            }
            case SET_CONTRAST: {
                command = (Command)gson.fromJson(commandParams, SetContrast.class);
                break;
            }
            case SET_BRIGHTNESS: {
                command = (Command)gson.fromJson(commandParams, SetBrightness.class);
                break;
            }
            case SET_TEXT: {
                command = (Command)gson.fromJson(commandParams, SetText.class);
                break;
            }
            case SET_FLIP: {
                command = (Command)gson.fromJson(commandParams, SetFlip.class);
                break;
            }
            case SET_MIRROR: {
                command = (Command)gson.fromJson(commandParams, SetMirror.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class SetFlip
    extends Command<CommandId> {
        @SerializedName(value="onFlag")
        public boolean enable;

        public SetFlip() {
            super(CommandId.SET_FLIP);
        }
    }

    public static class SetMirror
    extends Command<CommandId> {
        @SerializedName(value="onFlag")
        public boolean enable;

        public SetMirror() {
            super(CommandId.SET_MIRROR);
        }
    }

    public static class SetText
    extends Command<CommandId> {
        @SerializedName(value="text")
        public String text;
        @SerializedName(value="xPosition")
        public int xpos;
        @SerializedName(value="yPosition")
        public int ypos;

        public SetText() {
            super(CommandId.SET_TEXT);
        }
    }

    public static class SetBrightness
    extends Command<CommandId> {
        public SetBrightness() {
            super(CommandId.SET_BRIGHTNESS);
        }
    }

    public static class SetContrast
    extends Command<CommandId> {
        public SetContrast() {
            super(CommandId.SET_CONTRAST);
        }
    }

    public static class SetSaturation
    extends Command<CommandId> {
        public SetSaturation() {
            super(CommandId.SET_SATURATION);
        }
    }

    public static class SetHue
    extends Command<CommandId> {
        public SetHue() {
            super(CommandId.SET_HUE);
        }
    }

    public static class SetPreset
    extends Command<CommandId> {
        public SetPreset() {
            super(CommandId.SET_PRESET);
        }
    }

    public static class SetIrCutMode
    extends Command<CommandId> {
        public SetIrCutMode() {
            super(CommandId.SET_IR_CUT_MODE);
        }
    }

    public static class SetZoom
    extends Command<CommandId> {
        public SetZoom() {
            super(CommandId.SET_ZOOM);
        }
    }

    public static class SetAwbMode
    extends Command<CommandId> {
        public SetAwbMode() {
            super(CommandId.SET_AWB_MODE);
        }
    }

    public static class SetAeMode
    extends Command<CommandId> {
        public SetAeMode() {
            super(CommandId.SET_AE_MODE);
        }
    }

    public static class SetAfMode
    extends Command<CommandId> {
        public SetAfMode() {
            super(CommandId.SET_AF_MODE);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        SET_AF_MODE,
        SET_AE_MODE,
        SET_AWB_MODE,
        SET_ZOOM,
        SET_IR_CUT_MODE,
        SET_PRESET,
        SET_HUE,
        SET_SATURATION,
        SET_CONTRAST,
        SET_BRIGHTNESS,
        SET_FLIP,
        SET_MIRROR,
        SET_TEXT;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        AF_MODE_FLAG,
        AE_MODE_FLAG,
        AWB_MODE_FLAG,
        ZOOM_TYPE,
        IR_CUT_MODE_TYPE,
        IMG_PRESET_TYPE,
        IMG_HUE_PCT,
        IMG_SATURATION_PCT,
        IMG_CONTRAST_PCT,
        IMG_BRIGHTNESS_PCT,
        IMG_FLIP_FLAG,
        IMG_MIRROR_FLAG,
        IMG_TEXT,
        IMG_TEXT_X_POSITION,
        IMG_TEXT_Y_POSITION;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

