/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityMotionSensing
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.MOTION_SENSING;

    protected CapabilityMotionSensing(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case ENABLE: {
                command = (Command)gson.fromJson(commandParams, Enable.class);
                break;
            }
            case DISABLE: {
                command = (Command)gson.fromJson(commandParams, Disable.class);
                break;
            }
            case SET_ROI: {
                command = (Command)gson.fromJson(commandParams, SetRoi.class);
                break;
            }
            case SET_SENSITIVITY: {
                command = (Command)gson.fromJson(commandParams, SetSensitivity.class);
                break;
            }
            case REMOVE_ROI: {
                command = (Command)gson.fromJson(commandParams, RemoveRoi.class);
                break;
            }
            case REMOVE_ALL_ROI: {
                command = (Command)gson.fromJson(commandParams, RemoveAllRoi.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class Disable
    extends Command<CommandId> {
        public Disable() {
            super(CommandId.DISABLE);
        }
    }

    public static class Enable
    extends Command<CommandId> {
        public Enable() {
            super(CommandId.ENABLE);
        }
    }

    public static class SetSensitivity
    extends Command<CommandId> {
        @SerializedName(value="sensitivityPct")
        public int sensitivity;

        public SetSensitivity() {
            super(CommandId.SET_SENSITIVITY);
        }
    }

    public static class RemoveAllRoi
    extends Command<CommandId> {
        public RemoveAllRoi() {
            super(CommandId.REMOVE_ALL_ROI);
        }
    }

    public static class RemoveRoi
    extends Command<CommandId> {
        public RemoveRoi() {
            super(CommandId.REMOVE_ROI);
        }
    }

    public static class SetRoi
    extends Command<CommandId> {
        public SetRoi() {
            super(CommandId.SET_ROI);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        ENABLE,
        DISABLE,
        SET_ROI,
        REMOVE_ROI,
        REMOVE_ALL_ROI,
        SET_SENSITIVITY;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        DETECTED_FLAG,
        SENSING_ENABLED,
        IMAGE_WIDTH,
        IMAGE_HEIGHT,
        ROI_WIDTH,
        ROI_HEIGHT,
        ROI_INDICES_COUNT,
        ROI_INDICES_ARR,
        SENSITIVITY_PCT;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

