/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;

public class CapabilityMotorControl
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.MOTOR_CONTROL;

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(PanDirection.class, (Object)new PanDirectionParser());
        Command.GSON_BUILDER.registerTypeAdapter(TiltDirection.class, (Object)new TiltDirectionParser());
    }

    protected CapabilityMotorControl(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case PAN: {
                command = (Command)gson.fromJson(commandParams, Pan.class);
                break;
            }
            case TILT: {
                command = (Command)gson.fromJson(commandParams, Tilt.class);
                break;
            }
            case SET_PRESET: {
                command = (Command)gson.fromJson(commandParams, SetPreset.class);
                break;
            }
            case CLEAR_PRESET: {
                command = (Command)gson.fromJson(commandParams, ClearPreset.class);
                break;
            }
            case GO_TO_PRESET: {
                command = (Command)gson.fromJson(commandParams, GoToPreset.class);
                break;
            }
            case START_TRACK: {
                command = (Command)gson.fromJson(commandParams, StartTrack.class);
                break;
            }
            case STOP_TRACK: {
                command = (Command)gson.fromJson(commandParams, StopTrack.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class StopTrack
    extends Command<CommandId> {
        public StopTrack() {
            super(CommandId.STOP_TRACK);
        }
    }

    public static class StartTrack
    extends Command<CommandId> {
        public StartTrack() {
            super(CommandId.START_TRACK);
        }
    }

    public static class GoToPreset
    extends Command<CommandId> {
        public GoToPreset() {
            super(CommandId.GO_TO_PRESET);
        }
    }

    public static class ClearPreset
    extends Command<CommandId> {
        public ClearPreset() {
            super(CommandId.CLEAR_PRESET);
        }
    }

    public static class SetPreset
    extends Command<CommandId> {
        public SetPreset() {
            super(CommandId.SET_PRESET);
        }
    }

    public static class Tilt
    extends Command<CommandId> {
        @SerializedName(value="direction")
        public TiltDirection direction;
        @SerializedName(value="degree")
        public int degree;
        @SerializedName(value="speed")
        public int speed;

        public Tilt() {
            super(CommandId.TILT);
        }
    }

    public static class Pan
    extends Command<CommandId> {
        @SerializedName(value="direction")
        public PanDirection direction;
        @SerializedName(value="degree")
        public int degree;
        @SerializedName(value="speed")
        public int speed;

        public Pan() {
            super(CommandId.PAN);
        }
    }

    public static enum TiltDirection implements Direction
    {
        UP,
        DOWN;


        public static TiltDirection getEnum(int index) {
            return (TiltDirection)Utils.findEnum((int)index, (Enum[])TiltDirection.values());
        }

        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum PanDirection implements Direction
    {
        LEFT,
        RIGHT;


        public static PanDirection getEnum(int index) {
            return (PanDirection)Utils.findEnum((int)index, (Enum[])PanDirection.values());
        }

        public int getInt() {
            return this.ordinal();
        }
    }

    public static interface Direction {
        public static final Direction LEFT = PanDirection.LEFT;
        public static final Direction RIGHT = PanDirection.RIGHT;
        public static final Direction UP = TiltDirection.UP;
        public static final Direction DOWN = TiltDirection.DOWN;
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        PAN_DOF,
        TILT_DOF,
        SPEED_RPM,
        PRESET_POINT_ARR,
        TRACK_PRESET_POINT_ARR,
        TRACK_ACTIVE_FLAG,
        TRACK_REPEAT_COUNT,
        TRACK_DELAY_MS;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        PAN,
        TILT,
        SET_PRESET,
        CLEAR_PRESET,
        GO_TO_PRESET,
        START_TRACK,
        STOP_TRACK;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    private static final class TiltDirectionParser
    implements JsonDeserializer<TiltDirection>,
    JsonSerializer<TiltDirection> {
        private TiltDirectionParser() {
        }

        public TiltDirection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return TiltDirection.getEnum(json.getAsInt());
        }

        public JsonElement serialize(TiltDirection src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    private static final class PanDirectionParser
    implements JsonDeserializer<PanDirection>,
    JsonSerializer<PanDirection> {
        private PanDirectionParser() {
        }

        public PanDirection deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return PanDirection.getEnum(json.getAsInt());
        }

        public JsonElement serialize(PanDirection src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }
}

