/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;

public class CapabilityPowerLevels
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.POWER_LEVEL_MEASUREMENT;

    protected CapabilityPowerLevels(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case FETCH_BATTERY_VOLTAGE_MV: {
                command = (Command)gson.fromJson(commandParams, FetchBatteryVoltage.class);
                break;
            }
            case FETCH_BATTERY_LEVEL_PCT: {
                command = (Command)gson.fromJson(commandParams, FetchBatteryLevel.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class FetchBatteryLevel
    extends Command<CommandId> {
        public FetchBatteryLevel() {
            super(CommandId.FETCH_BATTERY_LEVEL_PCT);
        }
    }

    public static class FetchBatteryVoltage
    extends Command<CommandId> {
        public FetchBatteryVoltage() {
            super(CommandId.FETCH_BATTERY_VOLTAGE_MV);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        FETCH_BATTERY_VOLTAGE_MV,
        FETCH_BATTERY_LEVEL_PCT;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        VOLTAGE_MV,
        LEVEL_PCT,
        VOLT_LOW_FLAG,
        LEVEL_LOW_FLAG,
        LEVEL_CRITICAL_FLAG;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

