/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityStationaryPosition;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityRealTimePosition
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.REAL_TIME_POS;

    protected CapabilityRealTimePosition(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int cmdId, JsonElement commandParams) {
        CommandId commandId = CommandId.getEnum(cmdId);
        return new Command<CommandId>(commandId);
    }

    public static class BeaconLocation
    extends CapabilityStationaryPosition.Position {
        @SerializedName(value="beaconIdStr")
        public String beaconIdStr;
        @SerializedName(value="deviceResourceName")
        public String deviceResourceNameStr;
        @SerializedName(value="radiusOfBeacon")
        public double radiusOfBeacon;
        @SerializedName(value="errorPrecision")
        public double errorPrecision;
        @SerializedName(value="rssi")
        public int rssi;
        @SerializedName(value="measuredPower")
        public int measuredPower;
    }

    public static enum CommandId implements Capability.CommandId
    {


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        BEACON_LOC;


        public static Capability.AttributeId getEnum(int index) {
            return (Capability.AttributeId)((Object)Utils.findEnum((int)index, (Enum[])AttributeId.values()));
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }
}

