/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandIdInterface;
import buzz.getcoco.iot.CommandResponse;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.Identifier;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Parameter;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;

public class CapabilityRemoteControl
extends Capability {
    private static final String TAG = "CapabilityRemoteControl";
    public static final Capability.CapabilityId ID = Capability.CapabilityId.REMOTE_CONTROL;

    protected CapabilityRemoteControl(int id, Resource parent) {
        super(id, parent);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(Category.class, (Object)new CategoryParser());
        Command.GSON_BUILDER.registerTypeAdapter(ProgramMode.class, (Object)new ProgramModeParser());
        Command.GSON_BUILDER.registerTypeAdapter(ExecuteCommand.class, (Object)new ExecuteCommandParser());
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case TEST_COMMAND: {
                TypeToken<TestCommand<Command<Capability.CommandId>>> typeToken = new TypeToken<TestCommand<Command<Capability.CommandId>>>(){};
                command = (Command)gson.fromJson(commandParams, typeToken.getType());
                Log.d(TAG, "extendedCreateCommand: creating test command with type: " + typeToken);
                break;
            }
            case EXECUTE_COMMAND: {
                TypeToken<ExecuteCommand<Command<Capability.CommandId>>> typeToken = new TypeToken<ExecuteCommand<Command<Capability.CommandId>>>(){};
                command = (Command)gson.fromJson(commandParams, typeToken.getType());
                Log.d(TAG, "extendedCreateCommand: creating execute command with type: " + typeToken);
                break;
            }
            case ADD_APPLIANCE: {
                command = (Command)gson.fromJson(commandParams, AddAppliance.class);
                break;
            }
            case REMOVE_APPLIANCE: {
                command = (Command)gson.fromJson(commandParams, RemoveAppliance.class);
                break;
            }
            case SET_APPLIANCE_NAME: {
                command = (Command)gson.fromJson(commandParams, SetApplianceName.class);
                break;
            }
            case SET_APPLIANCE_PAIRING_CODE: {
                command = (Command)gson.fromJson(commandParams, SetAppliancePairingCode.class);
                break;
            }
            case SET_SEARCH_MODE: {
                command = (Command)gson.fromJson(commandParams, SetSearchMode.class);
                break;
            }
            case ENTER_LEARN_MODE: {
                command = (Command)gson.fromJson(commandParams, EnterLearnMode.class);
                break;
            }
            case CANCEL_LEARN_MODE: {
                command = (Command)gson.fromJson(commandParams, CancelLearnMode.class);
                break;
            }
            case RENAME_BUTTON: {
                command = (Command)gson.fromJson(commandParams, RenameButton.class);
                break;
            }
            case TEST_LEARNED_COMMAND: {
                command = (Command)gson.fromJson(commandParams, TestLearnedCommand.class);
                break;
            }
            case SAVE_LEARNED_COMMAND: {
                command = (Command)gson.fromJson(commandParams, SaveLearnedCommand.class);
                break;
            }
            case EXECUTE_LEARNED_COMMAND: {
                command = (Command)gson.fromJson(commandParams, ExecuteLearnedCommand.class);
                break;
            }
            case REMOVE_BUTTON: {
                command = (Command)gson.fromJson(commandParams, RemoveButton.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    @Override
    protected <T extends CommandIdInterface> CommandResponse.Args<T> createCommandResponseArgs(T commandId, JsonElement jsonResponse) {
        if (CommandId.SET_SEARCH_MODE == commandId) {
            Gson gson = Command.GSON_BUILDER.create();
            SetSearchModeResponse response = (SetSearchModeResponse)gson.fromJson(jsonResponse, SetSearchModeResponse.class);
            return (CommandResponse.Args)CommandResponse.castArgs(response);
        }
        if (CommandId.ADD_APPLIANCE == commandId) {
            Gson gson = Command.GSON_BUILDER.create();
            AddApplianceResponse response = (AddApplianceResponse)gson.fromJson(jsonResponse, AddApplianceResponse.class);
            return (CommandResponse.Args)CommandResponse.castArgs(response);
        }
        return super.createCommandResponseArgs(commandId, jsonResponse);
    }

    public void searchBrands(int searchCount, int offsetIndex, Parameter.SearchType st, InfoRequest.SortOrder so, InfoRequest.SortType soT, Category cat, String brandSearchQuery, Device.InfoRequestStatusListener cbs) {
        Resource r = this.getParent();
        Object d = r.getParent();
        Network n = ((Device)d).getParent();
        InfoRequest req = new InfoRequest(null, Collections.singletonList(new Parameter<InfoRequest.Search>(Parameter.Key.REMOTE_SEARCH, new InfoRequest.Search(searchCount, offsetIndex, st, new Identifier.SourceIdentifier(n.getId(), ((Device)d).getId(), r.getId()), soT, so, new InfoRequest.BrandSearchCriteria(cat, brandSearchQuery)))));
        ((Device)d).sendInfoRequest(req, cbs);
    }

    private static final class ExecuteCommandParser
    implements JsonDeserializer<ExecuteCommand<?>> {
        private ExecuteCommandParser() {
        }

        public ExecuteCommand<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext dsc) throws JsonParseException {
            JsonObject jo = jsonElement.getAsJsonObject();
            String applianceId = jo.get("applianceId").getAsString();
            int cmdId = jo.get("commandId").getAsInt();
            Capability.CapabilityId capId = (Capability.CapabilityId)((Object)dsc.deserialize(jo.get("capabilityId"), Capability.CapabilityId.class));
            Command<? extends Capability.CommandId> command = Factory.createCapability(capId.getInt(), null).createCommand(cmdId, jo.get("commandParamValuesStruct"));
            return new ExecuteCommand<Command<? extends Capability.CommandId>>(applianceId, capId, command);
        }
    }

    private static final class ProgramModeParser
    implements JsonSerializer<ProgramMode>,
    JsonDeserializer<ProgramMode> {
        private ProgramModeParser() {
        }

        public JsonElement serialize(ProgramMode programMode, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)programMode.mode);
        }

        public ProgramMode deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("invalid type: " + json);
            }
            return new ProgramMode(json.getAsInt());
        }
    }

    private static final class CategoryParser
    implements JsonSerializer<Category>,
    JsonDeserializer<Category> {
        private CategoryParser() {
        }

        public JsonElement serialize(Category category, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)category.rawValue);
        }

        public Category deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("invalid type: " + json);
            }
            return new Category(json.getAsInt());
        }
    }

    public static final class RemoteControlButtonInfo {
        @SerializedName(value="buttonId")
        private final String buttonId;
        @SerializedName(value="buttonName")
        private final String settings;

        public RemoteControlButtonInfo(String buttonId, String settings) {
            this.buttonId = buttonId;
            this.settings = settings;
        }

        public String getButtonId() {
            return this.buttonId;
        }

        public String getSettings() {
            return this.settings;
        }
    }

    public static class SetSearchModeResponse
    extends CommandResponse.Args<CommandId> {
        @SerializedName(value="pairingCodes")
        public int[] pairingCodes;
    }

    public static class AddApplianceResponse
    extends CommandResponse.Args<CommandId> {
        @SerializedName(value="applianceId")
        public String applianceId;
    }

    public static class SaveLearnedCommand
    extends Command<CommandId> {
        public SaveLearnedCommand() {
            super(CommandId.SAVE_LEARNED_COMMAND);
        }
    }

    public static class TestLearnedCommand
    extends Command<CommandId> {
        public TestLearnedCommand() {
            super(CommandId.TEST_LEARNED_COMMAND);
        }
    }

    public static class RemoveButton
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="buttonId")
        public final String buttonId;

        public RemoveButton(String applianceId, String buttonId) {
            super(CommandId.REMOVE_BUTTON);
            this.applianceId = applianceId;
            this.buttonId = buttonId;
        }
    }

    public static class RenameButton
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="buttonId")
        public final String buttonId;
        @SerializedName(value="buttonName")
        public final String buttonName;

        public RenameButton(String applianceId, String buttonId, String buttonName) {
            super(CommandId.RENAME_BUTTON);
            this.applianceId = applianceId;
            this.buttonId = buttonId;
            this.buttonName = buttonName;
        }
    }

    public static class ExecuteLearnedCommand
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="buttonId")
        public final String buttonId;

        public ExecuteLearnedCommand(String applianceId, String buttonId) {
            super(CommandId.EXECUTE_LEARNED_COMMAND);
            this.applianceId = applianceId;
            this.buttonId = buttonId;
        }
    }

    public static class CancelLearnMode
    extends Command<CommandId> {
        public CancelLearnMode() {
            super(CommandId.CANCEL_LEARN_MODE);
        }
    }

    public static class EnterLearnMode
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="buttonName")
        public final String buttonName;

        public EnterLearnMode(String applianceId, String buttonName) {
            super(CommandId.ENTER_LEARN_MODE);
            this.applianceId = applianceId;
            this.buttonName = buttonName;
        }
    }

    public static class SetSearchMode
    extends Command<CommandId> {
        public SetSearchMode() {
            super(CommandId.SET_SEARCH_MODE);
        }
    }

    public static class RemoveAppliance
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;

        public RemoveAppliance(String applianceId) {
            super(CommandId.REMOVE_APPLIANCE);
            this.applianceId = applianceId;
        }
    }

    public static class SetApplianceName
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="applianceName")
        public final String applianceName;

        public SetApplianceName(String applianceId, String applianceName) {
            super(CommandId.SET_APPLIANCE_NAME);
            this.applianceId = applianceId;
            this.applianceName = applianceName;
        }
    }

    public static class SetAppliancePairingCode
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="brandId")
        public final int brandId;
        @SerializedName(value="pairingCode")
        public final int pairingCode;

        public SetAppliancePairingCode(String applianceId, int brandId, int pairingCode) {
            super(CommandId.SET_APPLIANCE_PAIRING_CODE);
            this.applianceId = applianceId;
            this.brandId = brandId;
            this.pairingCode = pairingCode;
        }
    }

    public static class AddAppliance
    extends Command<CommandId> {
        public static final int LEARN_MODE_PAIRING_CODE = 65535;
        public static final int LEARN_MODE_BRAND_ID = 255;
        @SerializedName(value="brandId")
        public final int brandId;
        @SerializedName(value="pairingCode")
        public final int pairingCode;
        @SerializedName(value="applianceName")
        public final String applianceName;
        @SerializedName(value="categoryId")
        public final Category category;
        @SerializedName(value="programmingMode")
        public final ProgramMode mode;

        public AddAppliance(int brandId, int pairingCode, String applianceName, Category category, ProgramMode mode) {
            super(CommandId.ADD_APPLIANCE);
            this.brandId = brandId;
            this.pairingCode = pairingCode;
            this.applianceName = applianceName;
            this.category = category;
            this.mode = mode;
        }

        public static AddAppliance forPresetMode(String applianceName, Category category, int brandId, int pairingCode) {
            return new AddAppliance(brandId, pairingCode, applianceName, category, ProgramMode.preset());
        }

        public static AddAppliance forSearchMode(String applianceName, Category category, int brandId, int pairingCode) {
            return new AddAppliance(brandId, pairingCode, applianceName, category, ProgramMode.search());
        }

        public static AddAppliance forLearnMode(String applianceName, Category category) {
            return new AddAppliance(255, 65535, applianceName, category, ProgramMode.learn());
        }
    }

    public static class ExecuteCommand<T extends Command<? extends Capability.CommandId>>
    extends Command<CommandId> {
        @SerializedName(value="applianceId")
        public final String applianceId;
        @SerializedName(value="capabilityId")
        public final Capability.CapabilityId capabilityId;
        @SerializedName(value="commandId")
        private final int commandId;
        @SerializedName(value="commandParamValuesStruct")
        public final T command;

        public ExecuteCommand(String applianceId, Capability.CapabilityId capabilityId, T command) {
            super(CommandId.EXECUTE_COMMAND);
            this.applianceId = applianceId;
            this.capabilityId = capabilityId;
            this.command = command;
            this.commandId = ((Capability.CommandId)((Command)command).getCommandId()).getInt();
        }
    }

    public static class TestCommand<T extends Command<? extends Capability.CommandId>>
    extends Command<CommandId> {
        @SerializedName(value="categoryId")
        public final Category categoryId;
        @SerializedName(value="brandId")
        public final int brandId;
        @SerializedName(value="pairingCode")
        public final int pairingCode;
        @SerializedName(value="capabilityId")
        public final Capability.CapabilityId capabilityId;
        @SerializedName(value="commandId")
        private final int commandId;
        @SerializedName(value="commandParamValuesStruct")
        public final T command;

        public TestCommand(Category category, int brandId, int pairingCode, Capability.CapabilityId capabilityId, T command) {
            super(CommandId.TEST_COMMAND);
            this.categoryId = category;
            this.brandId = brandId;
            this.pairingCode = pairingCode;
            this.capabilityId = capabilityId;
            this.commandId = ((Capability.CommandId)((Command)command).getCommandId()).getInt();
            this.command = command;
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        TEST_COMMAND,
        ADD_APPLIANCE,
        SET_APPLIANCE_PAIRING_CODE,
        SET_APPLIANCE_NAME,
        REMOVE_APPLIANCE,
        EXECUTE_COMMAND,
        SET_SEARCH_MODE,
        ENTER_LEARN_MODE,
        CANCEL_LEARN_MODE,
        RENAME_BUTTON,
        TEST_LEARNED_COMMAND,
        SAVE_LEARNED_COMMAND,
        EXECUTE_LEARNED_COMMAND,
        REMOVE_BUTTON;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        SUPPORTED_PROGRAM_MODES_ARR,
        MAX_APPLIANCE_COUNT,
        CATEGORY_ID_ARR,
        APPLIANCE_LIST,
        MAX_BUTTON_COUNT;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }

    public static final class ProgramMode {
        public static final int PRESET_MODE = 0;
        public static final int LEARN_MODE = 1;
        public static final int SEARCH_MODE = 2;
        private final int mode;

        private ProgramMode(int mode) {
            this.mode = mode;
        }

        public static ProgramMode preset() {
            return new ProgramMode(0);
        }

        public static ProgramMode learn() {
            return new ProgramMode(1);
        }

        public static ProgramMode search() {
            return new ProgramMode(2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProgramMode that = (ProgramMode)o;
            return this.mode == that.mode;
        }

        public int hashCode() {
            return this.mode;
        }
    }

    public static final class Category {
        public static final int MIN = -1;
        public static final int AC = 0;
        public static final int TV = 1;
        private final int rawValue;

        private Category(int rawValue) {
            this.rawValue = rawValue;
        }

        public static Category ac() {
            return new Category(0);
        }

        public static Category tv() {
            return new Category(1);
        }

        public static Category none() {
            return new Category(-1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Category category = (Category)o;
            return this.rawValue == category.rawValue;
        }

        public int hashCode() {
            return this.rawValue;
        }

        public String toString() {
            return "Category{rawValue=" + this.rawValue + '}';
        }
    }
}

