/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Listener;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Objects;

public class CapabilitySnapshot
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.SNAPSHOT;

    protected CapabilitySnapshot(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case GRAB_IMAGE: {
                command = (Command)gson.fromJson(commandParams, GrabImage.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public void captureSnapshot(String downloadPath, int heightPx, int widthPx, long timeout, SnapshotListener listener) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(downloadPath);
        CocoClient.getInstance().getNativeHandler().captureSnapshot(this, downloadPath, heightPx, widthPx, timeout, listener);
    }

    public static class GrabImage
    extends Command<CommandId> {
        public GrabImage() {
            super(CommandId.GRAB_IMAGE);
        }
    }

    public static interface SnapshotListener
    extends Listener {
        public void onSnapshotCaptured(String var1, int var2);
    }

    public static final class SnapshotStatus {
        public static final int SUCCESS = 1;
        public static final int FAILURE = 2;
        public static final int TIMEOUT = 3;

        private SnapshotStatus() {
            throw new RuntimeException();
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        GRAB_IMAGE;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        IMG_SUPPORT_RESOLUTION_HEIGHT_ARR,
        IMG_SUPPORT_RESOLUTION_WIDTH_ARR,
        IMG_DEFAULT_RESOLUTION_HEIGHT,
        IMG_DEFAULT_RESOLUTION_WIDTH;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

