/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class CapabilityTunnel
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.TUNNEL_CONTROL;
    private final HashMap<Long, StatePort> tunnelHandleMap = new HashMap();

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(TransportType.class, (Object)new TransportTypeParser());
        Command.GSON_BUILDER.registerTypeAdapter(Protocol.class, (Object)new ProtocolParser());
        Command.GSON_BUILDER.registerTypeAdapter(IpVersion.class, (Object)new IpVersionParser());
        Command.GSON_BUILDER.registerTypeAdapter(TunnelType.class, (Object)new TunnelTypeParser());
    }

    protected CapabilityTunnel(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    public void openUdpTunnel(String forwardHostName, int forwardHostPort, TunnelType tunnelType, IpVersion ipVersion, long timeout, TunnelStatusListener listener) {
        this.open(forwardHostName, forwardHostPort, null, 0, TransportType.UDP, tunnelType, Protocol.RTSP, ipVersion, timeout, listener);
    }

    public void openTcpTunnel(String listeningHostName, int listeningHostPort, TunnelType tunnelType, IpVersion ipVersion, long timeout, TunnelStatusListener listener) {
        this.open(null, 0, listeningHostName, listeningHostPort, TransportType.TCP, tunnelType, Protocol.RTSP, ipVersion, timeout, listener);
    }

    public void open(String forwardHostName, int forwardHostPort, String listeningHostName, int listeningHostPort, TransportType transportType, TunnelType tunnelType, Protocol protocol, IpVersion ipVersion, long timeout, TunnelStatusListener listener) {
        CocoClient.getInstance().getNativeHandler().openTunnel(this, forwardHostName, forwardHostPort, listeningHostName, listeningHostPort, ipVersion, protocol, tunnelType, transportType, timeout, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllTunnels(long timeout) {
        Exception lastException = null;
        HashMap<Long, StatePort> hashMap = this.tunnelHandleMap;
        synchronized (hashMap) {
            for (long tunnelHandle : this.tunnelHandleMap.keySet()) {
                try {
                    this.close(tunnelHandle, timeout);
                }
                catch (Exception e) {
                    lastException = e;
                }
            }
        }
        if (null != lastException) {
            throw new IllegalArgumentException(lastException);
        }
    }

    public void close(long tunnelHandle, long timeout) {
        if (!this.tunnelHandleMap.containsKey(tunnelHandle)) {
            throw new IllegalArgumentException("unrecognized tunnel handle");
        }
        CocoClient.getInstance().getNativeHandler().closeTunnel(this, tunnelHandle, timeout);
    }

    public int getPort(long tunnelHandle) {
        StatePort statePort = this.tunnelHandleMap.get(tunnelHandle);
        return null == statePort ? 0 : statePort.port;
    }

    public State getState(long tunnelHandle) {
        StatePort statePort = this.tunnelHandleMap.get(tunnelHandle);
        return null == statePort ? null : statePort.state;
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        return null;
    }

    protected Map<Long, StatePort> getTunnelHandleMap() {
        return this.tunnelHandleMap;
    }

    public static interface TunnelStatusListener {
        public void onStatusChanged(long var1, int var3, State var4);
    }

    private static class TunnelTypeParser
    implements JsonSerializer<TunnelType>,
    JsonDeserializer<TunnelType> {
        private TunnelTypeParser() {
        }

        public JsonElement serialize(TunnelType type, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)type.getInt());
        }

        public TunnelType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int enumValue = json.getAsInt();
            return TunnelType.getEnum(enumValue);
        }
    }

    private static class IpVersionParser
    implements JsonSerializer<IpVersion>,
    JsonDeserializer<IpVersion> {
        private IpVersionParser() {
        }

        public JsonElement serialize(IpVersion ipVer, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)ipVer.getInt());
        }

        public IpVersion deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int enumValue = json.getAsInt();
            return IpVersion.getEnum(enumValue);
        }
    }

    private static class ProtocolParser
    implements JsonSerializer<Protocol>,
    JsonDeserializer<Protocol> {
        private ProtocolParser() {
        }

        public JsonElement serialize(Protocol protocol, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)protocol.getInt());
        }

        public Protocol deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int enumValue = json.getAsInt();
            return Protocol.getEnum(enumValue);
        }
    }

    private static class TransportTypeParser
    implements JsonSerializer<TransportType>,
    JsonDeserializer<TransportType> {
        private TransportTypeParser() {
        }

        public JsonElement serialize(TransportType type, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)type.getInt());
        }

        public TransportType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int enumValue = json.getAsInt();
            return TransportType.getEnum(enumValue);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        OPEN,
        CLOSE;


        static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum TunnelType {
        LISTEN,
        CONNECT;


        static TunnelType getEnum(int index) {
            return (TunnelType)Utils.findEnum((int)index, (Enum[])TunnelType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum State {
        OPENING,
        OPENED,
        REOPENED,
        OPEN_FAILED,
        CLOSED,
        CLOSE_FAILED,
        TIMEOUT,
        MAX_CLIENT_REACHED;


        static State getEnum(int index) {
            return (State)Utils.findEnum((int)index, (Enum[])State.values());
        }

        int getInt() {
            return this.ordinal();
        }

        public static boolean isOpen(State state) {
            switch (state) {
                case OPENED: 
                case REOPENED: {
                    return true;
                }
            }
            return false;
        }

        public static boolean isOpeningOrOpened(State state) {
            switch (state) {
                case OPENED: 
                case REOPENED: 
                case OPENING: {
                    return true;
                }
            }
            return false;
        }

        public static boolean isClosed(State state) {
            switch (state) {
                case CLOSED: 
                case OPEN_FAILED: 
                case TIMEOUT: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum IpVersion {
        IPv4,
        IPv6;


        static IpVersion getEnum(int index) {
            return (IpVersion)Utils.findEnum((int)index, (Enum[])IpVersion.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum Protocol {
        RTSP;


        static Protocol getEnum(int index) {
            return (Protocol)Utils.findEnum((int)index, (Enum[])Protocol.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum TransportType {
        TCP,
        UDP;


        static TransportType getEnum(int index) {
            return (TransportType)Utils.findEnum((int)index, (Enum[])TransportType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        SUPPORTED_TRANSPORT_TYPE_COUNT,
        SUPPORTED_TRANSPORT_TYPE_ARR,
        SUPPORTED_PROTOCOL_COUNT,
        SUPPORTED_PROTOCOL_ARR,
        SUPPORTED_PROTOCOL_METADATA_ARR,
        CURRENT_ACTIVE_CLIENTS_COUNT,
        CURRENT_ACTIVE_CLIENTS_ARR,
        MAX_ACTIVE_CLIENTS_COUNT;


        static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }

    static class StatePort {
        int port;
        State state;

        StatePort() {
        }
    }
}

