/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandIdInterface;

public final class CommandResponse<T extends CommandIdInterface> {
    private static final String TAG = "CommandResponse";
    private final Args<T> none = new Args();
    private Args<T> args = this.none;
    private final String responseJson;
    private transient Command<T> command;
    private transient Command.State state;
    private transient Error error;

    private CommandResponse(String responseJson) {
        this.responseJson = responseJson;
    }

    static <W extends CommandIdInterface, U extends CommandResponse<W>, V> V cast(U response) {
        return (V)response;
    }

    static <W extends CommandIdInterface, U extends Args<W>, V> V castArgs(U response) {
        return (V)response;
    }

    static <T extends CommandIdInterface> Args<T> createEmptyResponseArgs() {
        return new Args();
    }

    static <T extends CommandIdInterface> CommandResponse<T> createResponse(Command<T> command, String responseJson) {
        CommandResponse<T> response = new CommandResponse<T>(responseJson);
        response.setCommand(command);
        return response;
    }

    CommandResponse<T> setCommand(Command<T> command) {
        this.command = command;
        return this;
    }

    CommandResponse<T> setState(Command.State state) {
        this.state = state;
        return this;
    }

    CommandResponse<T> setError(Error error) {
        this.error = error;
        return this;
    }

    public Command.State getState() {
        return this.state;
    }

    public Error getError() {
        return this.error;
    }

    public Command<T> getCommand() {
        return this.command;
    }

    public Args<T> getArgs() {
        if (this.none != this.args) {
            return this.args;
        }
        Command.Tag tag = null == this.command ? null : this.command.getTag();
        this.args = null == tag ? CommandResponse.createEmptyResponseArgs() : tag.generateArgs(this.command.getCommandId(), this.responseJson);
        return this.args;
    }

    public String toString() {
        return "CommandResponse{command=" + this.command + ", state=" + (Object)((Object)this.state) + ", error=" + this.error + '}';
    }

    public static class Args<T> {
    }

    public static final class Error {
        public final int errorCode;
        public final String message;
        public final String fieldName;

        Error(int errorCode, String message, String fieldName) {
            this.errorCode = errorCode;
            this.message = message;
            this.fieldName = fieldName;
        }
    }

    public static final class ErrorCode {
        public static final int UNKNOWN = 0;
        public static final int BAD_REQUEST = 40000;
        public static final int MISSING_PARAMS = 40001;
        public static final int INVALID_PARAMS = 40002;
        public static final int INVALID_RANGE = 40003;
        public static final int DUP_DATA = 40004;
        public static final int USR_NOT_EXISTS = 40006;
        public static final int GW_NOT_IN_NW = 40007;
        public static final int NAME_RECURRING = 40009;
        public static final int USR_EXISTS = 40010;
        public static final int DUP_PRODUCT = 40011;
        public static final int AUTH_REQUIRED = 40101;
        public static final int SESSION_EXPIRED = 40102;
        public static final int INVALID_CREDENTIALS = 40103;
        public static final int ACCESS_RESTRICTED = 40301;
        public static final int GATEWAY_BUSY = 40302;
        public static final int JOIN_PROGRESS = 40303;
        public static final int GW_NOT_PROVISION = 40304;
        public static final int GW_ALREADY_OWNED = 40305;
        public static final int ALREADY_PROGRESS = 40306;
        public static final int DISABLE_APPLICATION = 40307;
        public static final int NETWORK_BLOCKED = 40314;
        public static final int NOT_FOUND = 40401;
        public static final int FILE_NOT_FOUND = 40402;
        public static final int RES_NOT_FOUND = 40403;
        public static final int INPUT_RES_NOT_FOUND = 40404;
        public static final int NW_UNALLOCATED = 40406;
        public static final int INTERNAL_SERVER = 50001;
        public static final int PAYMENT_FAILED = 50002;
        public static final int TX_FAILED = 50050;
        public static final int DATABASE_ERROR = 50301;
        public static final int SERVER_ERROR = 50302;
        public static final int HTTP_TIMEOUT = 50450;
        public static final int TIMEOUT = 50451;

        private ErrorCode() {
            throw new IllegalStateException();
        }
    }
}

