/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.io.Serializable;

public class Identifier {
    private static final Gson GSON = new Gson();
    @SerializedName(value="networkId")
    public final String networkId;
    @SerializedName(value="nodeId", alternate={"gatewayNodeId"})
    public final long deviceNodeId;
    @SerializedName(value="resourceEui")
    public final String resourceEui;
    @SerializedName(value="capabilityId")
    public final int capabilityId;
    @SerializedName(value="attributeId")
    public final int attributeId;
    @SerializedName(value="zoneId")
    public final int zoneId;
    @SerializedName(value="sceneId")
    public final int sceneId;
    @SerializedName(value="ruleId")
    public final int ruleId;

    public Identifier(Identifier id) {
        this.networkId = null == id ? null : id.networkId;
        this.resourceEui = null == id ? null : id.resourceEui;
        this.deviceNodeId = null == id ? -1L : id.deviceNodeId;
        this.capabilityId = null == id ? -1 : id.capabilityId;
        this.attributeId = null == id ? -1 : id.attributeId;
        this.zoneId = null == id ? -1 : id.zoneId;
        this.sceneId = null == id ? -1 : id.sceneId;
        this.ruleId = null == id ? -1 : id.ruleId;
    }

    private Identifier(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId) {
        this(networkId, deviceNodeId, resourceEui, capabilityId, attributeId, -1, -1, -1);
    }

    public Identifier(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId, int zoneId, int sceneId, int ruleId) {
        this.networkId = networkId;
        this.deviceNodeId = deviceNodeId;
        this.resourceEui = resourceEui;
        this.capabilityId = capabilityId;
        this.attributeId = attributeId;
        this.zoneId = zoneId;
        this.sceneId = sceneId;
        this.ruleId = ruleId;
    }

    public static Identifier getIdentifier(Network network) {
        return new Identifier(network.getId(), -1L, null, -1, -1);
    }

    public static Identifier getIdentifier(Device device) {
        return new Identifier(device.getParent().getId(), device.getId(), null, -1, -1);
    }

    public static Identifier getIdentifier(Resource resource) {
        return new Identifier(((Device)resource.getParent()).getParent().getId(), ((Device)resource.getParent()).getId(), resource.getId(), -1, -1);
    }

    public static Identifier getIdentifier(Capability capability) {
        return new Identifier(((Device)capability.getParent().getParent()).getParent().getId(), ((Device)capability.getParent().getParent()).getId(), capability.getParent().getId(), capability.getId().getInt(), -1);
    }

    public static Identifier getIdentifier(Attribute attribute) {
        return new Identifier(((Device)attribute.getParent().getParent().getParent()).getParent().getId(), ((Device)attribute.getParent().getParent().getParent()).getId(), attribute.getParent().getParent().getId(), attribute.getParent().getId().getInt(), attribute.getMapKey());
    }

    public static Identifier getIdentifier(Zone zone) {
        return new Identifier(zone.getParent().getId(), -1L, null, -1, -1, zone.getId(), -1, -1);
    }

    public static Identifier getIdentifier(Scene scene) {
        return new Identifier(scene.getParent().getId(), -1L, null, -1, -1, -1, scene.getId(), -1);
    }

    public static Identifier getIdentifier(Rule rule) {
        return new Identifier(rule.getParent().getId(), -1L, null, -1, -1, -1, -1, rule.getId());
    }

    public <T extends Network> T getNetwork() {
        CocoClient cocoClient = CocoClient.getInstance();
        return null == cocoClient || null == this.networkId ? null : (T)cocoClient.getNetwork(this.networkId);
    }

    public <T extends Device> T getDevice() {
        T network = this.getNetwork();
        return null == network ? null : (T)((Network)network).getDevice(this.deviceNodeId);
    }

    public <T extends Resource> T getResource() {
        T device = this.getDevice();
        return null == device || null == this.resourceEui ? null : (T)((Device)device).getResource(this.resourceEui);
    }

    public <T extends Capability> T getCapability() {
        T resource = this.getResource();
        return null == resource ? null : (T)((Resource)resource).getCapability(Capability.CapabilityId.getEnum(this.capabilityId));
    }

    public <T extends Attribute> T getAttribute() {
        T capability = this.getCapability();
        return null == capability ? null : (T)((Capability)capability).getAttribute(this.attributeId);
    }

    public <T extends Zone> T getZone() {
        T resource;
        T zone;
        T network = this.getNetwork();
        T t = zone = null == network ? null : (T)((Network)network).getZone(this.zoneId);
        if (null == zone && null != (resource = this.getResource())) {
            zone = ((Resource)resource).getParentZone();
        }
        return zone;
    }

    public <T extends Scene> T getScene() {
        T network = this.getNetwork();
        return null == network ? null : (T)((Network)network).getScene(this.sceneId);
    }

    public <T extends Rule> T getRule() {
        T network = this.getNetwork();
        return null == network ? null : (T)((Network)network).getRule(this.ruleId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)obj;
        boolean val = Identifier.equalsExtended(this.networkId, other.networkId);
        val &= Identifier.equalsExtended(this.resourceEui, other.resourceEui);
        val &= this.deviceNodeId == other.deviceNodeId;
        val &= this.capabilityId == other.capabilityId;
        val &= this.attributeId == other.attributeId;
        val &= this.zoneId == other.zoneId;
        return val &= this.sceneId == other.sceneId;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.networkId != null ? this.networkId.hashCode() : 0);
        result = 31 * result + (int)(this.deviceNodeId ^ this.deviceNodeId >>> 32);
        result = 31 * result + (this.resourceEui != null ? this.resourceEui.hashCode() : 0);
        result = 31 * result + this.capabilityId;
        result = 31 * result + this.attributeId;
        result = 31 * result + this.zoneId;
        result = 31 * result + this.sceneId;
        return result;
    }

    public JsonElement toJsonTree() {
        return this.toJsonTree(GSON);
    }

    public JsonElement toJsonTree(Gson gson) {
        return gson.toJsonTree((Object)this);
    }

    public String toJson() {
        return this.toJson(GSON);
    }

    public String toJson(Gson gson) {
        return gson.toJson((Object)this);
    }

    public Serializable toSerializable() {
        return new SerializedId(this.networkId, this.deviceNodeId, this.resourceEui, this.capabilityId, this.attributeId, this.zoneId, this.sceneId, this.ruleId);
    }

    public static Identifier fromSerializable(Serializable serializable) {
        SerializedId seId = null;
        if (serializable instanceof SerializedId) {
            seId = (SerializedId)serializable;
        }
        if (null == seId) {
            throw new IllegalArgumentException();
        }
        return new Identifier(seId.networkId, seId.deviceNodeId, seId.resourceEui, seId.capabilityId, seId.attributeId, seId.zoneId, seId.sceneId, seId.ruleId);
    }

    public static Identifier fromJson(String jsonIdentifier) {
        return Identifier.fromJson(GSON, jsonIdentifier);
    }

    public static Identifier fromJson(Gson gson, String jsonIdentifier) {
        return (Identifier)gson.fromJson(jsonIdentifier, Identifier.class);
    }

    public static Identifier fromJsonTree(JsonElement jsonElement) {
        return Identifier.fromJsonTree(GSON, jsonElement);
    }

    public static Identifier fromJsonTree(Gson gson, JsonElement jsonElement) {
        return (Identifier)gson.fromJson(jsonElement, Identifier.class);
    }

    public String toString() {
        return "Identifier{networkId='" + this.networkId + '\'' + ", deviceNodeId=" + this.deviceNodeId + ", resourceEui='" + this.resourceEui + '\'' + ", capabilityId=" + this.capabilityId + ", attributeId=" + this.attributeId + ", zoneId=" + this.zoneId + ", sceneId=" + this.sceneId + ", ruleId=" + this.ruleId + '}';
    }

    private static boolean equalsExtended(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static class TriggerIdentifier
    extends Identifier {
        public TriggerIdentifier(Identifier id) {
            super(id);
        }

        public TriggerIdentifier(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId) {
            this(networkId, deviceNodeId, resourceEui, capabilityId, attributeId, 0, 0, 0);
        }

        public TriggerIdentifier(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId, int zoneId, int sceneId, int ruleId) {
            super(networkId, deviceNodeId, resourceEui, capabilityId, attributeId, zoneId, sceneId, ruleId);
        }
    }

    public static class SourceIdentifier
    extends Identifier {
        public SourceIdentifier(Identifier id) {
            super(id);
        }

        public SourceIdentifier(String networkId, long deviceNodeId, String resourceEui) {
            this(networkId, deviceNodeId, resourceEui, -1, -1);
        }

        public SourceIdentifier(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId) {
            super(networkId, deviceNodeId, resourceEui, capabilityId, attributeId, -1, -1, -1);
        }

        @Override
        public <T extends Zone> T getZone() {
            throw new IllegalArgumentException();
        }

        @Override
        public <T extends Scene> T getScene() {
            throw new IllegalArgumentException();
        }

        @Override
        public <T extends Rule> T getRule() {
            throw new IllegalArgumentException();
        }
    }

    public static class SerializedId
    implements Serializable {
        private static final long serialVersionUID = 5863470550794984612L;
        private final String networkId;
        private final long deviceNodeId;
        private final String resourceEui;
        private final int capabilityId;
        private final int attributeId;
        private final int zoneId;
        private final int sceneId;
        private final int ruleId;

        private SerializedId(String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId, int zoneId, int sceneId, int ruleId) {
            this.networkId = networkId;
            this.deviceNodeId = deviceNodeId;
            this.resourceEui = resourceEui;
            this.capabilityId = capabilityId;
            this.attributeId = attributeId;
            this.zoneId = zoneId;
            this.sceneId = sceneId;
            this.ruleId = ruleId;
        }
    }
}

