/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import java.util.Arrays;

public class Log {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static final boolean DEBUG_LOGS_ENABLED = true;
    protected static final String[] LOG_LEVEL_TO_STR = new String[8];
    static Logger logger;

    public static int v(String tag, String msg) {
        return logger.println(2, tag, msg, null);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return logger.println(2, tag, msg, tr);
    }

    public static int d(String tag, String msg) {
        return logger.println(3, tag, msg, null);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return logger.println(3, tag, msg, tr);
    }

    public static int i(String tag, String msg) {
        return logger.println(4, tag, msg, null);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return logger.println(4, tag, msg, tr);
    }

    public static int w(String tag, String msg) {
        return logger.println(5, tag, msg, null);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return logger.println(5, tag, msg, tr);
    }

    public static int e(String tag, String msg) {
        return logger.println(6, tag, msg, null);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return logger.println(6, tag, msg, tr);
    }

    static {
        Arrays.fill(LOG_LEVEL_TO_STR, "?");
        Log.LOG_LEVEL_TO_STR[2] = "v";
        Log.LOG_LEVEL_TO_STR[3] = "d";
        Log.LOG_LEVEL_TO_STR[4] = "i";
        Log.LOG_LEVEL_TO_STR[5] = "w";
        Log.LOG_LEVEL_TO_STR[6] = "e";
        Log.LOG_LEVEL_TO_STR[7] = "a";
        logger = new Logger(){};
    }

    public static interface Logger {
        default public boolean isLogEnabled(int priority) {
            return true;
        }

        default public int println(int priority, String tag, String msg, Throwable tr) {
            if (!this.isLogEnabled(priority)) {
                return -1;
            }
            long now = System.currentTimeMillis();
            System.out.printf("%d %s/%s: %s", now, LOG_LEVEL_TO_STR[priority], tag, msg);
            if (null != tr) {
                System.out.printf("\n%s", this.getStackAsString(tr));
            }
            System.out.println();
            return 0;
        }

        default public String getStackAsString(Throwable tr) {
            if (null == tr) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            StackTraceElement[] stack = tr.getStackTrace();
            builder.append(tr.getMessage());
            builder.append('\n');
            for (StackTraceElement ste : stack) {
                builder.append(ste);
                builder.append('\n');
            }
            return builder.toString();
        }
    }
}

