/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class ResourceCondition
implements Rule.Condition {
    private final int id;
    Capability capability;
    int attributeId;
    OperatorType operatorType;
    long conditionDuration;
    Attribute.DataType dataType;
    Object thresholdAttributeValue;
    public static final int DEFAULT_RESOURCE_CONDITION_ID = 0;

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(ResourceCondition.class, (Object)new ResourceConditionParser());
    }

    protected ResourceCondition(int id, Capability capability, int attributeId, int operatorType, long conditionDuration, Attribute.DataType dataType, Object thresholdAttributeValue) {
        this.id = id;
        this.capability = capability;
        this.attributeId = attributeId;
        this.operatorType = OperatorType.getEnum(operatorType);
        this.conditionDuration = conditionDuration;
        this.dataType = dataType;
        this.thresholdAttributeValue = thresholdAttributeValue;
    }

    public ResourceCondition(Resource resource, Capability.AttributeId attributeId, OperatorType operatorType, long conditionDuration, Attribute.DataType dataType, Object thresholdAttributeValue) {
        this((Capability)resource.getCapability(attributeId.getCapabilityId()), attributeId, operatorType, conditionDuration, dataType, thresholdAttributeValue);
    }

    public ResourceCondition(Capability capability, Capability.AttributeId attributeId, OperatorType operatorType, long conditionDuration, Attribute.DataType dataType, Object thresholdAttributeValue) {
        this(0, capability, attributeId.getInt(), operatorType.getInt(), conditionDuration, dataType, thresholdAttributeValue);
    }

    public int getId() {
        return this.id;
    }

    public Capability.AttributeId getAttributeId() {
        return this.capability.getId().getAttributeId(this.attributeId);
    }

    public Capability getParentCapability() {
        return this.capability;
    }

    public Attribute getAttribute() {
        Capability parent = this.getParentCapability();
        return null == parent ? null : (Attribute)this.capability.getAttribute(this.getAttributeId());
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public long getConditionDuration() {
        return this.conditionDuration;
    }

    public Attribute.DataType getAttributeDataType() {
        return this.dataType;
    }

    public Object getThresholdAttributeValue() {
        return this.thresholdAttributeValue;
    }

    @Override
    public ResourceCondition duplicate() {
        return new ResourceCondition(0, this.capability, this.attributeId, this.operatorType.getInt(), this.conditionDuration, this.dataType, this.thresholdAttributeValue);
    }

    public String toString() {
        return "ResourceCondition{id=" + this.id + ", capability=" + this.capability + ", attributeId=" + this.attributeId + ", operatorType=" + (Object)((Object)this.operatorType) + ", conditionDuration=" + this.conditionDuration + ", dataType=" + (Object)((Object)this.dataType) + ", thresholdAttributeValue=" + this.thresholdAttributeValue + '}';
    }

    public static class EditableResourceCondition
    extends ResourceCondition {
        public EditableResourceCondition(Attribute attribute, OperatorType operatorType, long conditionDuration, Object thresholdAttributeValue) {
            super(attribute.getParent(), attribute.getId(), operatorType, conditionDuration, attribute.getDataType(), thresholdAttributeValue);
        }

        public void setCapability(Capability capability) {
            this.capability = capability;
        }

        public void setAttributeId(Capability.AttributeId attributeId) {
            this.attributeId = attributeId.getInt();
        }

        public void setOperatorType(OperatorType operatorType) {
            this.operatorType = operatorType;
        }

        public void setConditionDuration(long duration) {
            this.conditionDuration = duration;
        }

        public void setDataType(Attribute.DataType dataType) {
            this.dataType = dataType;
        }

        public void setValue(Object value) {
            this.thresholdAttributeValue = value;
        }
    }

    public static enum OperatorType {
        EQUAL_TO,
        NOT_EQUAL_TO,
        GREATER_THAN,
        GREATER_THAN_EQUAL_TO,
        LESS_THAN,
        LESS_THAN_EQUAL_TO;


        static OperatorType getEnum(int index) {
            return (OperatorType)Utils.findEnum((int)index, (Enum[])OperatorType.values());
        }

        int getInt() {
            return this.ordinal();
        }
    }

    private static class ResourceConditionParser
    implements JsonSerializer<ResourceCondition>,
    JsonDeserializer<ResourceCondition> {
        private ResourceConditionParser() {
        }

        public ResourceCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Object thresholdAttributeValue;
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement attributeValueJson = jsonObject.get("value");
            int id = jsonObject.get("ruleResCondId").getAsInt();
            String networkId = jsonObject.get("networkId").getAsString();
            long deviceNodeId = jsonObject.get("gatewayNodeId").getAsLong();
            String resourceEui = jsonObject.get("resourceEui").getAsString();
            int capabilityId = jsonObject.get("capabilityId").getAsInt();
            Capability capability = Utils.addMissingCapability(networkId, deviceNodeId, resourceEui, capabilityId, null);
            Gson gson = Command.GSON_BUILDER.create();
            int attributeId = jsonObject.get("attributeId").getAsInt();
            int operatorType = jsonObject.get("operatorId").getAsInt();
            long conditionDuration = jsonObject.get("condDurationMs").getAsLong();
            Attribute.DataType attributeDataType = (Attribute.DataType)((Object)gson.fromJson(jsonObject.get("valueDataTypeId"), Attribute.DataType.class));
            switch (attributeDataType) {
                case BOOLEAN: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, Boolean.TYPE);
                    break;
                }
                case BOOLEAN_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, boolean[].class);
                    break;
                }
                case STRING: 
                case JSON: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, String.class);
                    break;
                }
                case STRING_ARR: 
                case JSON_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, String[].class);
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, Double.TYPE);
                    break;
                }
                case FLOAT_ARR: 
                case DOUBLE_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, double[].class);
                    break;
                }
                case UINT8: 
                case UINT16: 
                case UINT32: 
                case UINT64: 
                case INT8: 
                case INT16: 
                case INT32: 
                case INT64: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, Integer.TYPE);
                    break;
                }
                case UINT8_ARR: 
                case UINT16_ARR: 
                case UINT32_ARR: 
                case UINT64_ARR: 
                case INT8_ARR: 
                case INT16_ARR: 
                case INT32_ARR: 
                case INT64_ARR: {
                    thresholdAttributeValue = gson.fromJson(attributeValueJson, int[].class);
                    break;
                }
                default: {
                    thresholdAttributeValue = null;
                }
            }
            return new ResourceCondition(id, capability, attributeId, operatorType, conditionDuration, attributeDataType, thresholdAttributeValue);
        }

        public JsonElement serialize(ResourceCondition condition, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            Gson gson = Command.GSON_BUILDER.create();
            jsonObject.addProperty("gatewayNodeId", (Number)((Device)condition.capability.getParent().getParent()).getId());
            jsonObject.addProperty("resourceEui", condition.capability.getParent().getId());
            jsonObject.addProperty("capabilityId", (Number)condition.capability.getId().getInt());
            jsonObject.addProperty("ruleResCondId", (Number)condition.id);
            jsonObject.addProperty("attributeId", (Number)condition.attributeId);
            jsonObject.addProperty("operatorId", (Number)condition.operatorType.getInt());
            jsonObject.addProperty("condDurationMs", (Number)condition.conditionDuration);
            jsonObject.add("valueDataTypeId", gson.toJsonTree((Object)condition.dataType));
            jsonObject.add("value", gson.toJsonTree(condition.thresholdAttributeValue));
            return jsonObject;
        }
    }
}

