/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;

public class CapabilityHumiditySensing
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.REL_HUMIDITY_MEASUREMENT;

    protected CapabilityHumiditySensing(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case FETCH_RELATIVE_HUMIDITY_PCT: {
                command = (Command)gson.fromJson(commandParams, FetchRelativeHumidity.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class FetchRelativeHumidity
    extends Command<CommandId> {
        public FetchRelativeHumidity() {
            super(CommandId.FETCH_RELATIVE_HUMIDITY_PCT);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        FETCH_RELATIVE_HUMIDITY_PCT;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        CURRENT_REL_HUMIDITY_PCT;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

