/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;

public class CapabilityHvacControl
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.HVAC_CONTROL;

    protected CapabilityHvacControl(int id, Resource parent) {
        super(id, parent);
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(FanSpeed.class, (Object)new FanSpeedParser());
        Command.GSON_BUILDER.registerTypeAdapter(Mode.class, (Object)new ModeParser());
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case SET_STATE: {
                command = (Command)gson.fromJson(commandParams, SetHvacState.class);
                break;
            }
            case SYNC_STATE: {
                command = (Command)gson.fromJson(commandParams, SyncState.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    private static final class FanSpeedParser
    implements JsonSerializer<FanSpeed>,
    JsonDeserializer<FanSpeed> {
        private FanSpeedParser() {
        }

        public JsonElement serialize(FanSpeed fanSpeed, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)fanSpeed.speed);
        }

        public FanSpeed deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("invalid type: " + json);
            }
            return new FanSpeed(json.getAsInt());
        }
    }

    private static final class ModeParser
    implements JsonSerializer<Mode>,
    JsonDeserializer<Mode> {
        private ModeParser() {
        }

        public JsonElement serialize(Mode mode, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)mode.mode);
        }

        public Mode deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isNumber()) {
                throw new JsonParseException("invalid type: " + json);
            }
            return new Mode(json.getAsInt());
        }
    }

    public static class SyncState
    extends Command<CommandId> {
        public SyncState() {
            super(CommandId.SYNC_STATE);
        }
    }

    public static class SetHvacState
    extends Command<CommandId> {
        @SerializedName(value="powerOnFlag")
        public boolean powerOnFlag;
        @SerializedName(value="swingOnFlag")
        public boolean swingOnFlag;
        @SerializedName(value="temperatureCelsius")
        public int temperatureCelsius;
        @SerializedName(value="mode")
        public Mode mode;
        @SerializedName(value="fanSpeed")
        public FanSpeed fanSpeed;

        public SetHvacState() {
            super(CommandId.SET_STATE);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        SET_STATE,
        SYNC_STATE;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        SUPPORTED_MODES_ARR,
        POWER_ON_FLAG,
        TEMPERATURE_CELSIUS,
        MODE,
        FAN_SPEED,
        SWING_ON_FLAG;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }

    public static final class Mode {
        public static final int COOL = 0;
        public static final int HEAT = 1;
        public static final int AUTO = 2;
        public static final int EMERGENCY_HEAT = 3;
        public static final int PRE_COOLING = 4;
        public static final int FAN_ONLY = 5;
        public static final int DRY = 6;
        public static final int SLEEP = 7;
        private final int mode;

        private Mode(int mode) {
            this.mode = mode;
        }

        public int rawValue() {
            return this.mode;
        }

        public static Mode cool() {
            return new Mode(0);
        }

        public static Mode heat() {
            return new Mode(1);
        }

        public static Mode auto() {
            return new Mode(2);
        }

        public static Mode emergencyHeat() {
            return new Mode(3);
        }

        public static Mode preCooling() {
            return new Mode(4);
        }

        public static Mode fan() {
            return new Mode(5);
        }

        public static Mode dry() {
            return new Mode(6);
        }

        public static Mode sleep() {
            return new Mode(7);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Mode)) {
                return false;
            }
            Mode other = (Mode)o;
            return this.mode == other.mode;
        }

        public int hashCode() {
            return this.mode;
        }
    }

    public static final class FanSpeed {
        public static final int OFF = 0;
        public static final int LOW = 1;
        public static final int MEDIUM = 2;
        public static final int HIGH = 3;
        public static final int AUTO = 4;
        private final int speed;

        private FanSpeed(int speed) {
            this.speed = speed;
        }

        public int rawValue() {
            return this.speed;
        }

        public static FanSpeed off() {
            return new FanSpeed(0);
        }

        public static FanSpeed low() {
            return new FanSpeed(1);
        }

        public static FanSpeed med() {
            return new FanSpeed(2);
        }

        public static FanSpeed high() {
            return new FanSpeed(3);
        }

        public static FanSpeed auto() {
            return new FanSpeed(4);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FanSpeed)) {
                return false;
            }
            FanSpeed fanSpeed = (FanSpeed)o;
            return this.speed == fanSpeed.speed;
        }

        public int hashCode() {
            return this.speed;
        }
    }
}

