/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class CapabilityKeyPressSensing
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.KEY_PRESS_SENSING;

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(KeyPressScene.class, (Object)new KeyPressSceneSerializer());
    }

    protected CapabilityKeyPressSensing(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        return new Command<CommandId>(commandId);
    }

    private static class KeyPressSceneSerializer
    implements JsonSerializer<KeyPressScene>,
    JsonDeserializer<KeyPressScene> {
        private KeyPressSceneSerializer() {
        }

        public KeyPressScene deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new KeyPressScene(json.getAsInt());
        }

        public JsonElement serialize(KeyPressScene keyPressScene, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)keyPressScene.rawValue());
        }
    }

    public static final class KeyPressScene {
        public static final int SINGLE = 0;
        public static final int DOUBLE = 1;
        public static final int TRIPLE = 2;
        public static final int QUAD = 3;
        public static final int QUINT = 4;
        public static final int HOLD = 5;
        public static final int RELEASE = 6;
        private final int keyPressScene;

        private KeyPressScene(int keyPressScene) {
            this.keyPressScene = keyPressScene;
        }

        public int rawValue() {
            return this.keyPressScene;
        }

        public static KeyPressScene sceneSingle() {
            return new KeyPressScene(0);
        }

        public static KeyPressScene sceneDouble() {
            return new KeyPressScene(1);
        }

        public static KeyPressScene sceneTriple() {
            return new KeyPressScene(2);
        }

        public static KeyPressScene sceneQuad() {
            return new KeyPressScene(3);
        }

        public static KeyPressScene sceneQuint() {
            return new KeyPressScene(4);
        }

        public static KeyPressScene sceneHold() {
            return new KeyPressScene(5);
        }

        public static KeyPressScene sceneRelease() {
            return new KeyPressScene(6);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyPressScene that = (KeyPressScene)o;
            return this.keyPressScene == that.keyPressScene;
        }

        public int hashCode() {
            return this.keyPressScene;
        }

        public String toString() {
            return "KeyPressScene{keyPressScene=" + this.keyPressScene + '}';
        }
    }

    public static enum CommandId implements Capability.CommandId
    {


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        SCENE_ID,
        SCENE_KEY,
        DISARM_FLAG,
        ARM_DAY_FLAG,
        ARM_NIGHT_FLAG,
        ARM_ALL_FLAG,
        PANIC_FLAG,
        EMERGENCY_FLAG,
        FALL_TRIGGER_FLAG,
        ACTIVATED_COMBO_ID,
        COMBO_NAME_ARR;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

