/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityLevel
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.LEVEL_CTRL;

    protected CapabilityLevel(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case SET_LEVEL: {
                command = (Command)gson.fromJson(commandParams, SetLevel.class);
                break;
            }
            case SET_LEVEL_WITH_ON_OFF: {
                command = (Command)gson.fromJson(commandParams, SetLevelOnOff.class);
                break;
            }
            case FETCH_LEVEL: {
                command = (Command)gson.fromJson(commandParams, FetchLevel.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class FetchLevel
    extends Command<CommandId> {
        public FetchLevel() {
            super(CommandId.FETCH_LEVEL);
        }
    }

    public static class SetLevelOnOff
    extends LevelCommand {
        @SerializedName(value="restoreLevelFlag")
        public boolean restoreLevel;

        SetLevelOnOff() {
            super(CommandId.SET_LEVEL_WITH_ON_OFF);
        }

        public SetLevelOnOff(boolean useDefaultTransitionTime) {
            super(CommandId.SET_LEVEL_WITH_ON_OFF);
            this.useDefaultTransitionTime = useDefaultTransitionTime;
        }
    }

    public static class SetLevel
    extends LevelCommand {
        SetLevel() {
            super(CommandId.SET_LEVEL);
        }

        public SetLevel(boolean useDefaultTransitionTime) {
            super(CommandId.SET_LEVEL);
            this.useDefaultTransitionTime = useDefaultTransitionTime;
        }
    }

    public static class LevelCommand
    extends Command<CommandId> {
        @SerializedName(value="levelPct")
        public int levelPct;
        @SerializedName(value="useDefaultTransTimeFlag")
        public boolean useDefaultTransitionTime;
        @SerializedName(value="transitionTimeMs")
        public int transitionTime;

        LevelCommand(CommandId commandId, long commandTimeout) {
            super(commandId, commandTimeout);
        }

        LevelCommand(CommandId commandId) {
            super(commandId);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        SET_LEVEL,
        SET_LEVEL_WITH_ON_OFF,
        FETCH_LEVEL;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        LEVEL_PCT;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

