/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;

public class CapabilityOnOff
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.ON_OFF_CONTROL;

    protected CapabilityOnOff(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case ON: {
                command = (Command)gson.fromJson(commandParams, On.class);
                break;
            }
            case OFF: {
                command = (Command)gson.fromJson(commandParams, Off.class);
                break;
            }
            case TOGGLE: {
                command = (Command)gson.fromJson(commandParams, Toggle.class);
                break;
            }
            case FETCH_ON_OFF_STATUS: {
                command = (Command)gson.fromJson(commandParams, FetchOnOffStatus.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class FetchOnOffStatus
    extends Command<CommandId> {
        public FetchOnOffStatus() {
            super(CommandId.FETCH_ON_OFF_STATUS);
        }
    }

    public static class Toggle
    extends Command<CommandId> {
        public Toggle() {
            super(CommandId.TOGGLE);
        }
    }

    public static class Off
    extends Command<CommandId> {
        public Off() {
            super(CommandId.OFF);
        }
    }

    public static class On
    extends Command<CommandId> {
        public On() {
            super(CommandId.ON);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        ON,
        OFF,
        TOGGLE,
        FETCH_ON_OFF_STATUS;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        ON_FLAG;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

