/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityStationaryPosition
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.STATIONARY_POS;

    protected CapabilityStationaryPosition(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case SET_DEVICE_LOC: {
                command = (Command)Command.GSON_BUILDER.create().fromJson(commandParams, SetDeviceLocation.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class SetDeviceLocation
    extends Command<CommandId> {
        @SerializedName(value="locationIdStr")
        public final String locationId;
        @SerializedName(value="lotIdStr")
        public final String lotId;
        @SerializedName(value="xCoordinate")
        public final double xcoordinate;
        @SerializedName(value="yCoordinate")
        public final double ycoordinate;
        @SerializedName(value="environmentalFactor")
        public final double environmentalFactor;

        public SetDeviceLocation(String locationId, String lotId, double x, double y, double environmentalFactor) {
            super(CommandId.SET_DEVICE_LOC);
            this.locationId = locationId;
            this.lotId = lotId;
            this.xcoordinate = x;
            this.ycoordinate = y;
            this.environmentalFactor = environmentalFactor;
        }
    }

    public static class BeaconLocation
    extends Position {
        @SerializedName(value="beaconIdStr")
        public String beaconIdStr;
        @SerializedName(value="deviceResourceName")
        public String deviceResourceNameStr;
        @SerializedName(value="avgRadiusOfBeacon")
        public double avgRadiusOfBeacon;
        @SerializedName(value="errorPrecision")
        public double errorPrecision;
        @SerializedName(value="avgTimeDurOfBeacon")
        public int avgTimeDurOfBeacon;
    }

    public static class DeviceLocation
    extends Position {
        @SerializedName(value="environmentalFactor")
        public double environmentalFactor;
    }

    public static class Position {
        @SerializedName(value="locationIdStr")
        public String locationId;
        @SerializedName(value="lotIdStr")
        public String lotId;
        @SerializedName(value="xCoordinate")
        public double xcoordinate;
        @SerializedName(value="yCoordinate")
        public double ycoordinate;
    }

    public static enum CommandId implements Capability.CommandId
    {
        SET_DEVICE_LOC;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        BEACON_LOC,
        GATEWAY_LOC;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

