/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityStorageConfig
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.STORAGE_CONFIG;

    protected CapabilityStorageConfig(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case CONFIG: {
                command = (Command)gson.fromJson(commandParams, Configure.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class Configure
    extends Command<CommandId> {
        @SerializedName(value="storageNodeId")
        public long deviceNodeId;
        @SerializedName(value="resourceEui")
        public String resourceEui;

        public Configure() {
            super(CommandId.CONFIG);
        }

        public Configure(Resource resource) {
            this();
            this.deviceNodeId = ((Device)resource.getParent()).getId();
            this.resourceEui = resource.getId();
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        CONFIG;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        STORAGE_NODE;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

