/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class CapabilityStorageControl
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.STORAGE_CONTROL;

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(StreamProtocol.class, (Object)new StreamProtocolParser());
        Command.GSON_BUILDER.registerTypeAdapter(PlaybackError.class, (Object)new PlaybackErrorParser());
    }

    protected CapabilityStorageControl(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        Gson gson = Command.GSON_BUILDER.create();
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        switch (commandId) {
            case UPLOAD: {
                command = (Command)gson.fromJson(commandParams, Upload.class);
                break;
            }
            case DOWNLOAD: {
                command = (Command)gson.fromJson(commandParams, Download.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    private static final class PlaybackErrorParser
    implements JsonSerializer<PlaybackError>,
    JsonDeserializer<PlaybackError> {
        private PlaybackErrorParser() {
        }

        public PlaybackError deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return PlaybackError.getEnum(json.getAsInt());
        }

        public JsonElement serialize(PlaybackError src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    private static final class StreamProtocolParser
    implements JsonSerializer<StreamProtocol>,
    JsonDeserializer<StreamProtocol> {
        private StreamProtocolParser() {
        }

        public StreamProtocol deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return StreamProtocol.getEnum(json.getAsInt());
        }

        public JsonElement serialize(StreamProtocol src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive((Number)src.getInt());
        }
    }

    public static class Upload
    extends Command<CommandId> {
        public Upload() {
            super(CommandId.UPLOAD);
        }
    }

    public static class Download
    extends Command<CommandId> {
        public Download() {
            super(CommandId.DOWNLOAD);
        }
    }

    public static enum PlaybackError {
        NONE,
        TIMEOUT,
        NOT_FOUND,
        PROTOCOL_NOT_SUPPORTED,
        INTERNAL;


        public static PlaybackError getEnum(int index) {
            return (PlaybackError)Utils.findEnum((int)index, (Enum[])PlaybackError.values());
        }

        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum StreamProtocol {
        DASH,
        HLS,
        HDS,
        SMOOTH;


        public static StreamProtocol getEnum(int index) {
            return (StreamProtocol)Utils.findEnum((int)index, (Enum[])StreamProtocol.values());
        }

        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        UPLOAD,
        DOWNLOAD;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        CONTENT_COUNT,
        CAPACITY_MB,
        AVAILABLE_MB,
        SUPPORTED_TYPES_ARR,
        RECORDING_TIME_CONFIG,
        RECORDING_SIZE_CONFIG,
        LAST_UPDATED_CONTENT_METADATA,
        COOL_OFF_PERIOD,
        RECORDING_STARTED,
        SUPPORTED_STREAM_PROTOCOLS;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

