/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;

public class CapabilityWindowCovering
extends Capability {
    public static final Capability.CapabilityId ID = Capability.CapabilityId.WINDOW_COVERING;

    protected CapabilityWindowCovering(int id, Resource parent) {
        super(id, parent);
    }

    @Override
    public boolean supports(Capability.CommandId commandId) {
        return (null == commandId || commandId instanceof CommandId) && super.supports(commandId);
    }

    @Override
    protected Command<? extends Capability.CommandId> extendedCreateCommand(int primitiveCommandId, JsonElement commandParams) {
        Command command;
        CommandId commandId = CommandId.getEnum(primitiveCommandId);
        Gson gson = Command.GSON_BUILDER.create();
        switch (commandId) {
            case UP: {
                command = (Command)gson.fromJson(commandParams, Up.class);
                break;
            }
            case DOWN: {
                command = (Command)gson.fromJson(commandParams, Down.class);
                break;
            }
            case STOP: {
                command = (Command)gson.fromJson(commandParams, Stop.class);
                break;
            }
            case SET_OPEN_PCT: {
                command = (Command)gson.fromJson(commandParams, Open.class);
                break;
            }
            default: {
                command = new Command(commandId);
            }
        }
        return command;
    }

    public static class Open
    extends Command<CommandId> {
        @SerializedName(value="openPct")
        public int openPct;

        public Open() {
            super(CommandId.SET_OPEN_PCT);
        }
    }

    public static class Stop
    extends Command<CommandId> {
        public Stop() {
            super(CommandId.STOP);
        }
    }

    public static class Down
    extends Command<CommandId> {
        public Down() {
            super(CommandId.DOWN);
        }
    }

    public static class Up
    extends Command<CommandId> {
        public Up() {
            super(CommandId.UP);
        }
    }

    public static enum CommandId implements Capability.CommandId
    {
        UP,
        DOWN,
        STOP,
        SET_OPEN_PCT;


        public static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AttributeId implements Capability.AttributeId
    {
        OPEN_PCT;


        public static AttributeId getEnum(int index) {
            return (AttributeId)Utils.findEnum((int)index, (Enum[])AttributeId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }

        @Override
        public Capability.CapabilityId getCapabilityId() {
            return ID;
        }
    }
}

