/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.ResourceCondition;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;
import buzz.getcoco.iot.Zone;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

class DeepSerializer {
    private static final String TAG = "DeepSerializer";
    private static final Gson GSON;
    private static final GsonBuilder BUILDER;

    DeepSerializer() {
    }

    static String serialize(Network network) {
        return GSON.toJson((Object)network);
    }

    static {
        BUILDER = new GsonBuilder().enableComplexMapKeySerialization();
        GsonBuilder localBuilder = new GsonBuilder();
        localBuilder.registerTypeAdapter(Resource.class, (resource, typeOfSrc, context) -> {
            JsonObject jsonObject = new JsonObject();
            Log.d(TAG, "local serializing resource:" + ((Device)resource.getParent()).getId() + ":" + resource.getId());
            jsonObject.addProperty("networkId", ((Device)resource.getParent()).getParent().getId());
            jsonObject.addProperty("gatewayNodeId", (Number)((Device)resource.getParent()).getId());
            jsonObject.addProperty("resourceEui", resource.getId());
            return jsonObject;
        });
        localBuilder.registerTypeAdapter(Scene.class, (src, typeOfSrc, context) -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("networkId", src.getParent().getId());
            jsonObject.addProperty("sceneId", (Number)src.getId());
            return jsonObject;
        });
        localBuilder.registerTypeAdapter(ResourceAction.class, (resourceAction, typeOfSrc, context) -> {
            JsonObject jsonObject = new JsonObject();
            Capability c = resourceAction.getCapability();
            Resource r = null == c ? null : c.getParent();
            Device d = null == r ? null : (Device)r.getParent();
            Network n = null == d ? null : d.getParent();
            jsonObject.addProperty("networkId", null == n ? null : n.getId());
            jsonObject.addProperty("resourceEui", null == r ? null : r.getId());
            jsonObject.addProperty("gatewayNodeId", null == d ? null : Long.valueOf(d.getId()));
            jsonObject.addProperty("capabilityId", null == c ? null : Integer.valueOf(c.getId().getInt()));
            jsonObject.addProperty("cmdId", (Number)resourceAction.getCommand().getCommandId().getInt());
            jsonObject.add("cmdParams", (JsonElement)resourceAction.getCommand().toJsonObject());
            jsonObject.addProperty("resrcActionId", (Number)resourceAction.getId());
            return jsonObject;
        });
        localBuilder.registerTypeAdapter(ScheduleCondition.class, (src, typeOfSrc, context) -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("ruleSchedCondId", (Number)src.getId());
            jsonObject.addProperty("ruleSchedTypeId", (Number)src.getScheduleType().getInt());
            jsonObject.addProperty("ruleStartTime", (Number)src.getStartTime().getEpochSecond());
            jsonObject.addProperty("ruleExpiryTime", (Number)src.getInstantExpiryTime().getEpochSecond());
            return jsonObject;
        });
        localBuilder.registerTypeAdapter(ResourceCondition.class, (src, typeOfSrc, context) -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("ruleResCondId", (Number)src.getId());
            jsonObject.addProperty("networkId", ((Device)src.getParentCapability().getParent().getParent()).getParent().getId());
            jsonObject.addProperty("resourceEui", src.getParentCapability().getParent().getId());
            jsonObject.addProperty("gatewayNodeId", (Number)((Device)src.getParentCapability().getParent().getParent()).getId());
            jsonObject.addProperty("capabilityId", (Number)src.getParentCapability().getId().getInt());
            jsonObject.addProperty("attributeId", (Number)src.getAttributeId().getInt());
            jsonObject.addProperty("condDurationMs", (Number)src.getConditionDuration());
            jsonObject.add("operatorId", context.serialize((Object)src.getOperatorType()));
            jsonObject.add("valueDataTypeId", context.serialize((Object)src.getAttributeDataType()));
            jsonObject.add("value", context.serialize(src.getThresholdAttributeValue()));
            return jsonObject;
        });
        final Gson localGson = localBuilder.create();
        BUILDER.registerTypeAdapter(Zone.class, (zone, typeOfSrc, context) -> {
            JsonObject jsonObject = new JsonObject();
            Type resourceListType = new TypeToken<Set<Resource>>(){}.getType();
            jsonObject.addProperty("zoneId", (Number)zone.getId());
            jsonObject.addProperty("zoneName", zone.getName());
            jsonObject.add("resourceArr", localGson.toJsonTree(zone.getResources(), resourceListType));
            return jsonObject;
        });
        BUILDER.registerTypeAdapter(Scene.class, (Object)new JsonSerializer<Scene>(){

            public JsonElement serialize(Scene scene, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("sceneId", (Number)scene.getId());
                jsonObject.addProperty("sceneName", scene.getName());
                jsonObject.addProperty("sceneMetadata", scene.getMetadata());
                jsonObject.add("resrcActionArr", localGson.toJsonTree(scene.getResourceActionMap()));
                return jsonObject;
            }
        });
        BUILDER.registerTypeAdapter(Rule.class, (Object)new JsonSerializer<Rule>(){

            public JsonElement serialize(Rule src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("ruleId", (Number)src.getId());
                jsonObject.addProperty("ruleName", src.getName());
                jsonObject.add("resrcCondnArr", localGson.toJsonTree(src.getResourceConditions()));
                jsonObject.add("schedCondnArr", localGson.toJsonTree(src.getScheduleConditions()));
                jsonObject.add("resrcActionArr", localGson.toJsonTree(src.getResourceActions()));
                jsonObject.add("sceneActionArr", localGson.toJsonTree(src.getSceneActions(), new TypeToken<List<Scene>>(){}.getType()));
                return jsonObject;
            }
        });
        GSON = BUILDER.serializeSpecialFloatingPointValues().create();
    }
}

