/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.CallbackMultiplexer;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityMediaStreaming;
import buzz.getcoco.iot.CapabilitySnapshot;
import buzz.getcoco.iot.CapabilityTunnel;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandResponse;
import buzz.getcoco.iot.Context;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.InfoResponse;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.MessageType;
import buzz.getcoco.iot.NativeCallbacksInterface;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.NodeType;
import buzz.getcoco.iot.PlatformCallbacksHandler;
import buzz.getcoco.iot.PlatformInterface;
import buzz.getcoco.iot.PowerSource;
import buzz.getcoco.iot.RadioProtocol;
import buzz.getcoco.iot.ReceiverType;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.ResourceCondition;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;
import buzz.getcoco.iot.StateException;
import buzz.getcoco.iot.Utils;
import buzz.getcoco.iot.Zone;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;

class DefaultCallbacksHandler
extends NativeCallbacksInterface {
    private static final String TAG = "CallbacksHandler";
    private static final PlatformInterface platformInterface = PlatformCallbacksHandler.getInstance();
    private static final CallbackMultiplexer multiplexer = CallbackMultiplexer.getInstance();

    DefaultCallbacksHandler() {
    }

    @Override
    protected void connectStatusCallback(String networkId, int networkState, Object nativeNetworkContext) {
        Network network = Utils.addMissingNetwork(networkId);
        Network.State state = Network.State.getEnum(networkState);
        network.internalSetState(state);
        multiplexer.connectStatusCallback(network);
        if (Network.containsClearFlag(state)) {
            CocoClient.getInstance().internalRemoveNetwork(networkId);
            network.internalRemoveNetwork();
        }
    }

    @Override
    protected void leaveNetworkStatusCallback(int status, Object nativeContext) {
        Command.State commandStatus = Command.State.getEnum(status);
        Network.LeaveStatusListener listener = null;
        Network network = null;
        if (null != nativeContext) {
            Context context = (Context)nativeContext;
            listener = (Network.LeaveStatusListener)this.cast(context.developerContext);
            network = (Network)context.sdkContext;
        }
        if (null != listener) {
            listener.onResponse(commandStatus, Command.State.SUCCESS == commandStatus ? null : new StateException(commandStatus));
        }
        multiplexer.leaveNetworkStatusCallback(network, commandStatus);
    }

    @Override
    protected void deviceInfoCallback(boolean trigger, boolean append, String networkId, long deviceNodeId, String name, String devicePsn, String productName, String make, String model, String firmwareVersion, int powerSource, int receiverType, boolean extendable, int[] protocolsSupported, String[] resourceEuis, Object nativeNetworkContext) {
        Device device;
        Network network;
        Object context = null;
        if (nativeNetworkContext != null) {
            context = ((Context)nativeNetworkContext).developerContext;
        }
        if (!(network = Utils.addMissingNetwork(networkId)).containsDevice(deviceNodeId)) {
            device = Factory.createDevice(deviceNodeId, network);
            network.internalAddDevice(device);
        } else {
            device = network.getDevice(deviceNodeId);
        }
        device.internalSetName(name);
        if (!append) {
            device.internalSetExtendable(extendable);
            device.internalSetDevicePsn(devicePsn);
            device.internalSetProductName(productName);
            device.internalSetMake(make);
            device.internalSetModel(model);
            device.internalSetFirmwareVersion(firmwareVersion);
            device.internalSetPowerSource(PowerSource.getEnum(powerSource));
            device.internalSetReceiverType(ReceiverType.getEnum(receiverType));
            device.internalSetProtocolSupported(protocolsSupported);
            for (String resourceEui : resourceEuis) {
                if (device.containsResource(resourceEui)) continue;
                Utils.addMissingResource(networkId, deviceNodeId, resourceEui, context);
            }
            if (resourceEuis.length != device.getResourceMap().size()) {
                HashSet<String> resourceEuiSet = new HashSet<String>(Arrays.asList(resourceEuis));
                for (Resource resource : device) {
                    if (resourceEuiSet.contains(resource.getId())) continue;
                    device.internalRemoveResource(resource.getId());
                    resource.internalRemoveResource();
                }
            }
            device.internalSetReady(true);
        }
        if (trigger) {
            multiplexer.deviceInfoCallback(device);
        }
    }

    @Override
    protected void resourceSummaryCallback(boolean trigger, String networkId, long deviceNodeId, String resourceEui, String name, String metadata, String manufacturer, String model, String firmware, int powerSource, int receiverType, Object nativeNetworkContext) {
        Object resource;
        Device parentDevice = Utils.addMissingDevice(networkId, deviceNodeId);
        Object defaultZone = parentDevice.getParent().getZone(0);
        if (!parentDevice.containsResource(resourceEui)) {
            resource = Factory.createResource(resourceEui, parentDevice, defaultZone);
            parentDevice.internalAddResource((Resource)resource);
            ((Zone)defaultZone).internalAddResource((Resource)resource);
        } else {
            resource = parentDevice.getResource(resourceEui);
        }
        if (!Objects.equals(((Resource)resource).getName(), name)) {
            ((Resource)resource).internalSetName(name);
        }
        if (!Objects.equals(((Resource)resource).getMetadata(), metadata)) {
            ((Resource)resource).internalSetMetadata(metadata);
        }
        if (!Objects.equals(((Resource)resource).getManufacturer(), manufacturer)) {
            ((Resource)resource).internalSetManufacturer(manufacturer);
        }
        if (!Objects.equals(((Resource)resource).getModel(), model)) {
            ((Resource)resource).internalSetModel(model);
        }
        if (!Objects.equals(((Resource)resource).getFirmware(), firmware)) {
            ((Resource)resource).internalSetFirmware(firmware);
        }
        if (!Objects.equals((Object)((Resource)resource).getPowerSource(), (Object)PowerSource.getEnum(powerSource))) {
            ((Resource)resource).internalSetPowerSource(PowerSource.getEnum(powerSource));
        }
        if (!Objects.equals((Object)((Resource)resource).getReceiverType(), (Object)ReceiverType.getEnum(receiverType))) {
            ((Resource)resource).internalSetReceiverType(ReceiverType.getEnum(receiverType));
        }
        ((Resource)resource).internalSetParentDevice(parentDevice);
        if (!((Zone)((Resource)resource).getParentZone()).containsResource((Resource)resource)) {
            ((Zone)defaultZone).internalAddResource((Resource)resource);
            ((Resource)resource).internalSetParentZone((Zone)defaultZone);
        }
        if (!((Resource)resource).isReady()) {
            ((Resource)resource).internalMarkAsReady();
        }
        if (trigger) {
            multiplexer.resourceCallback((Resource)resource);
        }
    }

    @Override
    protected void resourceCapabilityCallback(boolean trigger, String networkId, long deviceNodeId, String resourceEui, int capabilityId, String name, int[] standardCommandArr, Object nativeNetworkContext) {
        Capability capability;
        Capability.CapabilityId capId;
        Resource parentResource;
        Object context = null;
        if (nativeNetworkContext != null) {
            context = ((Context)nativeNetworkContext).developerContext;
        }
        if (!(parentResource = Utils.addMissingResource(networkId, deviceNodeId, resourceEui, context)).containsCapability(capId = Capability.CapabilityId.getEnum(capabilityId))) {
            capability = Factory.createCapability(capabilityId, parentResource);
            parentResource.internalAddCapability(capability);
        } else {
            capability = parentResource.getCapability(capId);
        }
        if (!Objects.equals(capability.getName(), name)) {
            capability.internalSetName(name);
        }
        capability.clearAndSetStandardCommandSet(standardCommandArr);
        capability.internalMarkAsReady();
        if (trigger) {
            multiplexer.resourceCapabilityCallback(capability);
        }
    }

    @Override
    protected void resourceAttributeCallback(boolean trigger, String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId, String name, String description, long minReportingInterval, long maxReportingInterval, int dataType, int arrayLength, Object minValue, Object maxValue, Object defaultValue, Object currentValue, boolean realtimeUpdate, Object nativeNetworkContext) {
        Attribute attribute;
        Capability parentCapability;
        long timeTaken = System.currentTimeMillis();
        Log.d(TAG, "resourceAttributeCallback: started at: " + timeTaken);
        Object context = null;
        if (nativeNetworkContext != null) {
            context = ((Context)nativeNetworkContext).developerContext;
        }
        if (!(parentCapability = Utils.addMissingCapability(networkId, deviceNodeId, resourceEui, capabilityId, context)).containsAttribute(attributeId)) {
            attribute = Factory.createAttribute(attributeId, parentCapability);
            parentCapability.internalAddAttribute(attribute);
        } else {
            attribute = parentCapability.getAttribute(attributeId);
        }
        attribute.internalSetRealtimeUpdate(realtimeUpdate);
        if (!Objects.equals(attribute.getName(), name)) {
            attribute.internalSetName(name);
        }
        if (!Objects.equals(attribute.getDescription(), description)) {
            attribute.internalSetDescription(description);
        }
        if (!Objects.equals((Object)attribute.getDataType(), (Object)Attribute.DataType.getEnum(dataType))) {
            attribute.internalSetDataType(dataType);
        }
        if (!Objects.equals(attribute.getArrayLength(), arrayLength)) {
            attribute.internalSetArrayLength(arrayLength);
        }
        if (!Objects.deepEquals(attribute.getMinValue(), minValue)) {
            attribute.internalSetMinValue(minValue);
        }
        if (!Objects.deepEquals(attribute.getMaxValue(), maxValue)) {
            attribute.internalSetMaxValue(maxValue);
        }
        if (!Objects.deepEquals(attribute.getCurrentValue(), currentValue)) {
            attribute.internalSetCurrentValue(currentValue);
        }
        if (!Objects.deepEquals(attribute.getDefaultValue(), defaultValue)) {
            attribute.internalSetDefaultValue(defaultValue);
        }
        if (attribute.getMinReportingInterval() != minReportingInterval) {
            attribute.internalSetMinReportingInterval(minReportingInterval);
        }
        if (attribute.getMaxReportingInterval() != maxReportingInterval) {
            attribute.internalSetMaxReportingInterval(maxReportingInterval);
        }
        attribute.internalMarkAsReady();
        timeTaken = System.currentTimeMillis() - timeTaken;
        Log.d(TAG, "resourceAttributeCallback: completed in: " + timeTaken + "ms");
        if (trigger) {
            multiplexer.resourceAttributeCallback(attribute);
        }
    }

    @Override
    protected void commandStatusCallback(int status, String responseJson, Object nativeNetworkContext, Object nativeCommandContext) {
        Command.State commandStatus = Command.State.getEnum(status);
        if (null == nativeCommandContext) {
            Log.e(TAG, "cannot find context. This might mean a wrong implementation of c-sdk OR java-sdk");
            Log.e(TAG, "IGNORING Command status callback");
            return;
        }
        Capability.CommandStatusListener listener = (Capability.CommandStatusListener)this.cast(((Context)nativeCommandContext).developerContext);
        Command command = (Command)this.cast(((Context)nativeCommandContext).sdkContext);
        Log.d(TAG, "commandStatusCallback: status: " + status);
        CommandResponse response = CommandResponse.createResponse(command, responseJson).setState(commandStatus);
        if (null != listener) {
            listener.onCommandStatus((CommandResponse)CommandResponse.cast(response), Command.State.SUCCESS == commandStatus ? null : new StateException(commandStatus));
        }
        multiplexer.commandStatusCallback(response);
    }

    @Override
    protected void networkListCallback(String[] networkIds, String[] networkNames, int[] netTypes, int[] userRoles, int[] accessTypes, Object nativeRequestContext) {
        CocoClient.NetworkListListener commandContext = null;
        ArrayList<Network> networksToRemove = null;
        if (null != nativeRequestContext) {
            commandContext = (CocoClient.NetworkListListener)this.cast(((Context)nativeRequestContext).developerContext);
        }
        if (null == networkIds) {
            if (null != commandContext) {
                commandContext.onResponse(null, new IOException("Internal Error"));
            }
            multiplexer.networkListCallback(null);
            return;
        }
        ArrayList<Network> networksList = new ArrayList<Network>();
        for (int i = 0; i < networkIds.length; ++i) {
            Object t = CocoClient.getInstance().getNetwork(networkIds[i]);
            if (null != t) {
                Network.NetworkType netType = Network.NetworkType.getEnum(netTypes[i]);
                Network.UserRole userRole = Network.UserRole.getEnum(userRoles[i]);
                Network.AccessType accessType = Network.AccessType.getEnum(accessTypes[i]);
                networksList.add((Network)t);
                if (!Objects.equals(((Network)t).getName(), networkNames[i])) {
                    ((Network)t).internalSetName(networkNames[i]);
                }
                if (!Objects.equals((Object)((Network)t).getUserRole(), (Object)userRole)) {
                    ((Network)t).internalSetUserRole(userRole);
                }
                if (!Objects.equals((Object)((Network)t).getAccessType(), (Object)accessType)) {
                    ((Network)t).internalSetAccessType(accessType);
                }
                if (Objects.equals((Object)((Network)t).getNetworkType(), (Object)netType)) continue;
                ((Network)t).internalSetNetworkType(netType);
                continue;
            }
            Network network = Factory.createNetwork(networkIds[i]);
            network.internalSetName(networkNames[i]);
            network.internalSetNetworkType(Network.NetworkType.getEnum(netTypes[i]));
            network.internalSetUserRole(Network.UserRole.getEnum(userRoles[i]));
            network.internalSetAccessType(Network.AccessType.getEnum(accessTypes[i]));
            networksList.add(network);
        }
        Arrays.sort(networkIds, String.CASE_INSENSITIVE_ORDER);
        for (Network network : CocoClient.getInstance().getNetworkMap().values()) {
            int index = Arrays.binarySearch(networkIds, network.getId(), String.CASE_INSENSITIVE_ORDER);
            if (0 <= index) continue;
            if (null == networksToRemove) {
                networksToRemove = new ArrayList<Network>();
            }
            networksToRemove.add(network);
        }
        if (null != networksToRemove) {
            for (Network network : networksToRemove) {
                CocoClient.getInstance().internalRemoveNetwork(network.getId());
                network.internalRemoveNetwork();
            }
        }
        if (null != commandContext) {
            commandContext.onResponse(networksList, null);
        }
        multiplexer.networkListCallback(networksList);
    }

    @Override
    protected void authCallback(String authorizationEndpoint, String tokenEndpoint) {
        platformInterface.authCallback(authorizationEndpoint, tokenEndpoint);
    }

    @Override
    protected void deviceManagementStatusCallback(String networkId, long deviceNodeId, int status, String[] impactedResourcesEuiArr, Object nativeNetworkContext, Object nativeCommandContext) {
        Resource[] resourcesImpacted;
        Object commandContext = null;
        Command command = null;
        Device device = Utils.getDevice(networkId, deviceNodeId);
        Resource[] resourceArray = resourcesImpacted = null == impactedResourcesEuiArr ? null : new Resource[impactedResourcesEuiArr.length];
        if (null == device) {
            throw new RuntimeException("device missing during device management callback");
        }
        if (nativeCommandContext != null) {
            command = (Command)this.cast(((Context)nativeCommandContext).sdkContext);
            commandContext = ((Context)nativeCommandContext).developerContext;
        }
        if (null != impactedResourcesEuiArr) {
            for (int i = 0; i < impactedResourcesEuiArr.length; ++i) {
                resourcesImpacted[i] = Utils.getResource(networkId, deviceNodeId, impactedResourcesEuiArr[i]);
            }
        }
        Command.State commandStatus = Command.State.getEnum(status);
        CommandResponse<Device.CommandId> response = CommandResponse.createResponse(command, null).setState(commandStatus);
        if (commandContext instanceof Device.DeviceManagementStatusListener) {
            ((Device.DeviceManagementStatusListener)commandContext).onStatusChanged(response, resourcesImpacted, Command.State.SUCCESS == commandStatus ? null : new StateException(commandStatus));
        }
        multiplexer.deviceManagementStatusCallback(device, response, resourcesImpacted);
    }

    @Override
    protected void infoResponseStatusCallback(int status, Object nativeContext) {
        Context context = (Context)nativeContext;
        if (null == context) {
            Log.e(TAG, "sdk error: null sdk context in infoResponseStatusCallback");
            return;
        }
        InfoResponse infoResponse = (InfoResponse)context.sdkContext;
        Device.InfoResponseStatusListener listener = (Device.InfoResponseStatusListener)context.developerContext;
        if (null == infoResponse) {
            Log.e(TAG, "sdk error: null info response in infoResponseStatusCallback");
            return;
        }
        infoResponse.state = Command.State.getEnum(status);
        if (null != listener) {
            listener.onInfoResponseStatus(infoResponse, Command.State.SUCCESS == infoResponse.state ? null : new StateException(infoResponse.state));
        }
        multiplexer.infoResponseStatusCallback(infoResponse.state, infoResponse);
    }

    @Override
    protected void infoRequestCallback(String networkId, long requestNodeId, long responseNodeId, long requestId, long cmdSeqNum, String infoRequestJson, Object nativeNetworkContext, Object nativeCommandContext) {
        Object commandContext = null;
        if (null != nativeCommandContext) {
            commandContext = ((Context)nativeCommandContext).developerContext;
        }
        InfoRequest infoRequest = (InfoRequest)Command.GSON_BUILDER.create().fromJson(infoRequestJson, InfoRequest.class);
        infoRequest.requestId = requestId;
        infoRequest.cmdSeqNum = cmdSeqNum;
        Log.d(TAG, "requestNodeId: " + requestNodeId + ", responseNodeId: " + responseNodeId);
        infoRequest.deviceNodeId = requestNodeId;
        infoRequest.networkId = networkId;
        if (commandContext instanceof Device.InfoRequestListener) {
            Device.InfoRequestListener listener = (Device.InfoRequestListener)commandContext;
            listener.onInfoRequest(infoRequest);
        }
        multiplexer.infoRequestCallback(infoRequest);
    }

    @Override
    protected void infoResponseCallback(String networkId, long requestNodeId, long requestId, long cmdSeqNum, String infoResponseJson, Object nativeNetworkContext, Object nativeCommandContext) {
        InfoRequest request = (InfoRequest)((Context)nativeCommandContext).sdkContext;
        Device.InfoRequestStatusListener listener = (Device.InfoRequestStatusListener)((Context)nativeCommandContext).developerContext;
        InfoResponse infoResponse = (InfoResponse)Command.GSON_BUILDER.create().fromJson(infoResponseJson, InfoResponse.class);
        infoResponse.networkId = networkId;
        infoResponse.setRequestNodeId(requestNodeId);
        infoResponse.setInfoRequestId(requestId);
        infoResponse.setCmdSeqNum(cmdSeqNum);
        if (null != listener) {
            listener.onInfoResponse(infoResponse);
        }
        multiplexer.infoResponseCallback(request, infoResponse);
    }

    @Override
    protected void infoRequestStatusCallback(int status, Object nativeContext) {
        Context context = (Context)nativeContext;
        InfoRequest request = (InfoRequest)context.sdkContext;
        Device.InfoRequestStatusListener listener = (Device.InfoRequestStatusListener)context.developerContext;
        request.state = Command.State.getEnum(status);
        if (null != listener) {
            listener.onInfoRequestStatus(request, Command.State.SUCCESS == request.state ? null : new StateException(request.state));
        }
        multiplexer.infoRequestStatusCallback(request.state, request);
    }

    @Override
    protected void messageCallback(String title, String message, int messageType, Object nativeNetworkContext, Object nativeCommandContext) {
        Object listener = null;
        if (null != nativeCommandContext) {
            listener = ((Context)nativeCommandContext).developerContext;
        }
        if (listener instanceof Device.MessageListener) {
            ((Device.MessageListener)listener).onMessage(title, message, MessageType.getEnum(messageType));
        }
        multiplexer.messageCallback(title, message, MessageType.getEnum(messageType));
    }

    @Override
    protected void advertiseResourceCallback(String networkId, long deviceNodeId, String resourceEui, String resourceName, int protocol, Object nativeNetworkContext) {
        Device parentDevice = Utils.addMissingDevice(networkId, deviceNodeId);
        Resource resourceAd = Factory.createAdvertResource(resourceEui, parentDevice);
        resourceAd.internalSetName(resourceName);
        resourceAd.internalSetProtocol(RadioProtocol.getEnum(protocol));
        multiplexer.advertiseResourceCallback(resourceAd);
    }

    @Override
    protected void resourceIncludedCallback(String networkId, long[] deviceNodeIds, String[] resourceEuis, Object nativeNetworkContext) {
        Object networkContext = null;
        if (null != nativeNetworkContext) {
            networkContext = ((Context)nativeNetworkContext).developerContext;
        }
        ArrayList<Resource> resources = new ArrayList<Resource>(deviceNodeIds.length);
        for (int i = 0; i < deviceNodeIds.length; ++i) {
            Resource resource = Utils.addMissingResource(networkId, deviceNodeIds[i], resourceEuis[i], networkContext);
            resources.add(resource);
        }
        multiplexer.resourceIncludedCallback(resources);
    }

    @Override
    protected void resourceExcludedCallback(String networkId, long deviceNodeId, String resourceEui, Object nativeNetworkContext) {
        Device parentDevice = Utils.getDevice(networkId, deviceNodeId);
        Resource resource = Utils.getResource(networkId, deviceNodeId, resourceEui);
        if (null == resource) {
            return;
        }
        multiplexer.resourceExcludedCallback(resource);
        parentDevice.internalRemoveResource(resourceEui);
        resource.internalRemoveResource();
        if (null != resource.getParentZone()) {
            ((Zone)resource.getParentZone()).internalRemoveResource(resource);
        }
    }

    @Override
    protected void tunnelStatusCallback(long tunnelHandle, int status, int port, Object nativeTunnelContext) {
        CapabilityTunnel tunnel = (CapabilityTunnel)((Context)nativeTunnelContext).sdkContext;
        CapabilityTunnel.TunnelStatusListener listener = (CapabilityTunnel.TunnelStatusListener)((Context)nativeTunnelContext).developerContext;
        CapabilityTunnel.StatePort statePort = tunnel.getTunnelHandleMap().get(tunnelHandle);
        if (null == listener) {
            Log.d(TAG, "tunnelStatusCallback: listener = null");
        }
        if (null == statePort) {
            statePort = new CapabilityTunnel.StatePort();
            tunnel.getTunnelHandleMap().put(tunnelHandle, statePort);
        }
        statePort.port = port;
        statePort.state = CapabilityTunnel.State.getEnum(status);
        if (CapabilityTunnel.State.CLOSED == statePort.state || CapabilityTunnel.State.TIMEOUT == statePort.state || CapabilityTunnel.State.OPEN_FAILED == statePort.state) {
            tunnel.getTunnelHandleMap().remove(tunnelHandle);
        }
        if (null != listener) {
            try {
                listener.onStatusChanged(tunnelHandle, statePort.port, statePort.state);
            }
            catch (Exception e) {
                this.errorCallback(e);
            }
            catch (Throwable tr) {
                this.errorCallback(new Exception(tr));
            }
        }
        multiplexer.tunnelStatusCallback(tunnel, tunnelHandle, statePort.state, statePort.port);
    }

    @Override
    protected void zoneInfoCallback(boolean trigger, String networkId, int zoneId, String zoneName, long[] deviceNodeIds, String[] resourceEuis, String[] resourceNames, Object context) {
        Object zone;
        Network network;
        long timeTaken = System.currentTimeMillis();
        Log.d(TAG, "zoneInfoCallback: started at: " + timeTaken);
        Object developerContext = null;
        ArrayList<Resource> resourcesToRemove = null;
        HashSet effectedZones = new HashSet();
        HashSet<Resource> expectedResources = new HashSet<Resource>();
        if (null != context) {
            developerContext = ((Context)context).developerContext;
        }
        if (!(network = Utils.addMissingNetwork(networkId)).containsZone(zoneId)) {
            zone = Factory.createZone(zoneId, network);
            network.internalAddZone((Zone)zone);
        } else {
            zone = network.getZone(zoneId);
        }
        ((Zone)zone).internalSetName(zoneName);
        for (int i = 0; i < deviceNodeIds.length; ++i) {
            Object resourceParentZone;
            Resource resource = Utils.addMissingResource(networkId, deviceNodeIds[i], resourceEuis[i], (Zone)zone, developerContext);
            expectedResources.add(resource);
            if (null != resourceNames[i]) {
                resource.internalSetName(resourceNames[i]);
            }
            if (!zone.equals(resourceParentZone = resource.getParentZone())) {
                ((Zone)resourceParentZone).internalRemoveResource(resource);
                effectedZones.add(resourceParentZone);
                resource.internalSetParentZone((Zone)zone);
            }
            if (((Zone)zone).containsResource(resource)) continue;
            ((Zone)zone).internalAddResource(resource);
        }
        Iterator<Resource> iterator = ((Zone)zone).iterator();
        while (iterator.hasNext()) {
            Resource resource = iterator.next();
            if (expectedResources.contains(resource)) continue;
            if (null == resourcesToRemove) {
                resourcesToRemove = new ArrayList<Resource>();
            }
            resourcesToRemove.add(resource);
        }
        if (null != resourcesToRemove) {
            for (Resource resource : resourcesToRemove) {
                Log.d(TAG, "removing id: " + resource.getId());
                ((Zone)zone).internalRemoveResource(resource);
            }
        }
        if (trigger) {
            for (Zone effectedZone : effectedZones) {
                multiplexer.zoneInfoCallback(effectedZone);
            }
        }
        ((Zone)zone).internalMarkAsReady();
        timeTaken = System.currentTimeMillis() - timeTaken;
        Log.d(TAG, "zoneInfoCallback: completed in: " + timeTaken + "ms");
        if (trigger) {
            multiplexer.zoneInfoCallback((Zone)zone);
        }
    }

    @Override
    protected void zoneDeletedCallback(String networkId, int zoneId, Object context) {
        Network network = Utils.getNetwork(networkId);
        if (null == network) {
            return;
        }
        if (network.containsZone(zoneId)) {
            network.internalRemoveZone(zoneId);
        }
        multiplexer.zoneDeletedCallback(network, zoneId);
    }

    @Override
    protected void sceneInfoCallback(boolean trigger, String networkId, int sceneId, String sceneName, String metadata, String[] resourceCommands, Object context) {
        Object scene;
        long timeTaken = System.currentTimeMillis();
        Log.d(TAG, "sceneInfoCallback: started at: " + timeTaken);
        HashMap<Integer, ResourceAction> resourceActionMap = new HashMap<Integer, ResourceAction>();
        Gson gson = Command.GSON_BUILDER.create();
        Network parent = Utils.addMissingNetwork(networkId);
        if (parent.containsScene(sceneId)) {
            scene = parent.getScene(sceneId);
        } else {
            scene = Factory.createScene(sceneId, parent);
            parent.internalAddScene((Scene)scene);
        }
        HashMap<Integer, ResourceAction> backupActionMap = new HashMap<Integer, ResourceAction>(((Scene)scene).getResourceActionMap());
        ((Scene)scene).internalSetMetadata(metadata);
        ((Scene)scene).internalSetName(sceneName);
        for (String resourceCommand : resourceCommands) {
            JsonObject jsonCommand = JsonParser.parseString((String)resourceCommand).getAsJsonObject();
            jsonCommand.addProperty("networkId", networkId);
            ResourceAction resourceAction = (ResourceAction)gson.fromJson((JsonElement)jsonCommand, ResourceAction.class);
            if (null == resourceAction) {
                Log.d(TAG, "cannot form resourceAction for: " + sceneId);
                Log.d(TAG, "resourceActionJson: " + jsonCommand);
                continue;
            }
            resourceActionMap.put(resourceAction.getId(), resourceAction);
        }
        for (ResourceAction action : resourceActionMap.values()) {
            if (backupActionMap.containsKey(action.getId())) {
                backupActionMap.remove(action.getId());
                ((Scene)scene).internalUpdateResourceAction(action);
                continue;
            }
            ((Scene)scene).internalAddResourceAction(action);
        }
        for (ResourceAction action : backupActionMap.values()) {
            ((Scene)scene).internalRemoveResourceAction(action.getId());
        }
        ((Scene)scene).internalMarkAsReady();
        timeTaken = System.currentTimeMillis() - timeTaken;
        Log.d(TAG, "sceneInfoCallback: completed in: " + timeTaken + "ms");
        if (trigger) {
            multiplexer.sceneInfoCallback((Scene)scene);
        }
    }

    @Override
    protected void sceneDeletedCallback(String networkId, int sceneId, Object context) {
        Network parent = Utils.getNetwork(networkId);
        if (null == parent) {
            return;
        }
        parent.internalRemoveScene(sceneId);
        multiplexer.sceneDeletedCallback(parent, sceneId);
    }

    @Override
    protected void ruleInfoCallback(boolean trigger, String networkId, int ruleId, String ruleName, String[] resourceConditions, String[] scheduleConditions, String[] resourceActions, String[] sceneActions, Object nativeContext) {
        long timeTaken = System.currentTimeMillis();
        Log.d(TAG, "ruleInfoCallback: started at: " + timeTaken);
        Gson gson = Command.GSON_BUILDER.create();
        ArrayList<ResourceAction> resourceActionList = new ArrayList<ResourceAction>(resourceActions.length);
        ArrayList<Scene> sceneActionList = new ArrayList<Scene>(sceneActions.length);
        ArrayList<ResourceCondition> resourceConditionList = new ArrayList<ResourceCondition>(resourceConditions.length);
        ArrayList<ScheduleCondition> scheduleConditionList = new ArrayList<ScheduleCondition>(scheduleConditions.length);
        Network parent = Utils.addMissingNetwork(networkId);
        Object rule = parent.getRule(ruleId);
        if (null == rule) {
            rule = Factory.createRule(ruleId, parent);
            parent.internalAddRule((Rule)rule);
        }
        for (String resourceActionString : resourceActions) {
            try {
                JsonObject resourceActionJson = JsonParser.parseString((String)resourceActionString).getAsJsonObject();
                resourceActionJson.addProperty("networkId", networkId);
                ResourceAction resourceAction = (ResourceAction)gson.fromJson((JsonElement)resourceActionJson, ResourceAction.class);
                resourceActionList.add(resourceAction);
            }
            catch (Exception e) {
                this.errorCallback(e);
            }
        }
        for (String sceneAction : sceneActions) {
            try {
                JsonObject sceneActionJson = JsonParser.parseString((String)sceneAction).getAsJsonObject();
                sceneActionJson.addProperty("networkId", networkId);
                Scene scene = (Scene)gson.fromJson((JsonElement)sceneActionJson, Scene.class);
                sceneActionList.add(scene);
            }
            catch (Exception e) {
                this.errorCallback(e);
            }
        }
        for (String resourceConditionString : resourceConditions) {
            try {
                JsonObject resourceConditionJson = JsonParser.parseString((String)resourceConditionString).getAsJsonObject();
                resourceConditionJson.addProperty("networkId", networkId);
                ResourceCondition resourceCondition = (ResourceCondition)gson.fromJson((JsonElement)resourceConditionJson, ResourceCondition.class);
                resourceConditionList.add(resourceCondition);
            }
            catch (Exception e) {
                this.errorCallback(e);
            }
        }
        for (String scheduleConditionString : scheduleConditions) {
            try {
                ScheduleCondition scheduleCondition = (ScheduleCondition)gson.fromJson(scheduleConditionString, ScheduleCondition.class);
                scheduleConditionList.add(scheduleCondition);
            }
            catch (Exception e) {
                this.errorCallback(e);
            }
        }
        ((Rule)rule).internalSetName(ruleName);
        ((Rule)rule).internalClearAddResourceConditions(resourceConditionList);
        ((Rule)rule).internalClearAddResourceActions(resourceActionList);
        ((Rule)rule).internalClearAddSceneActions(sceneActionList);
        ((Rule)rule).internalClearAddScheduleConditions(scheduleConditionList);
        ((Rule)rule).internalMarkAsReady();
        timeTaken = System.currentTimeMillis() - timeTaken;
        Log.d(TAG, "ruleInfo: completed in: " + timeTaken + "ms");
        if (trigger) {
            multiplexer.ruleInfoCallback((Rule)rule);
        }
    }

    @Override
    protected void ruleDeletedCallback(String networkId, int ruleId, Object nativeContext) {
        Network network = Utils.getNetwork(networkId);
        if (null == network) {
            return;
        }
        network.internalRemoveRule(ruleId);
        multiplexer.ruleDeletedCallback(network, ruleId);
    }

    @Override
    protected void accessTokenCallback(String accessToken, int status, Object context) {
        CocoClient.AccessTokensListener tokensListener = null;
        Command.State commandStatus = Command.State.getEnum(status);
        if (null != context) {
            tokensListener = (CocoClient.AccessTokensListener)((Context)context).developerContext;
        }
        if (null != tokensListener) {
            tokensListener.onResponse(accessToken, Command.State.SUCCESS == commandStatus ? null : new StateException(commandStatus));
        }
        platformInterface.accessTokensCallback(accessToken, commandStatus);
    }

    @Override
    protected void networkManagementStatusCallback(String networkId, int commandStatus, int errorCode, String errorMessage, String fieldName, Object commandContext, Object networkContext) {
        Command command = null;
        Network.NetworkManagementStatusListener listener = null;
        Command.State commandState = Command.State.getEnum(commandStatus);
        if (null != commandContext) {
            command = (Command)this.cast(((Context)commandContext).sdkContext);
            listener = (Network.NetworkManagementStatusListener)((Context)commandContext).developerContext;
        }
        CommandResponse<Network.CommandId> response = CommandResponse.createResponse(command, null).setState(commandState).setError(new CommandResponse.Error(errorCode, errorMessage, fieldName));
        if (null != listener) {
            listener.onStatusChanged(response, Command.State.SUCCESS == commandState ? null : new StateException(commandState));
        }
        multiplexer.networkManagementCommandCallback(Utils.addMissingNetwork(networkId), response);
    }

    @Override
    protected void nodeConnectionStatusCallback(String networkId, long nodeId, int nativeNodeType, boolean isOnline, Object nativeContext) {
        Device device = Utils.getDevice(networkId, nodeId);
        NodeType nodeType = NodeType.getEnum(nativeNodeType);
        if (null != device) {
            device.internalSetReady(isOnline);
        }
        multiplexer.nodeConnectionStatusCallback(Utils.getNetwork(networkId), nodeId, nodeType, isOnline);
    }

    @Override
    protected void errorCallback(Exception exception) {
        try {
            exception.printStackTrace();
            multiplexer.errorCallback(exception);
        }
        catch (Throwable tr) {
            Log.w(TAG, "wth: error in errorCallback", tr);
        }
    }

    @Override
    protected void networkDataCallback(String networkId, int[] resTempZoneIds, String[] resTempIds, String[] resTempNames, String[] resTempIcons, long[] deviceIds, int[] zoneIds, int[] sceneIds, int[] ruleIds, Object context) {
        long timeTaken = System.currentTimeMillis();
        Log.d(TAG, "networkDataCallback: started at: " + timeTaken);
        zoneIds = DefaultCallbacksHandler.getZonesIdsWithDefaultIncluded(zoneIds);
        Network network = Utils.addMissingNetwork(networkId);
        ArrayList<Network.ResourceTemplate> resourceTemplates = new ArrayList<Network.ResourceTemplate>();
        int resTempArrCnt = resTempIds.length;
        for (int i = 0; i < resTempArrCnt; ++i) {
            resourceTemplates.add(new Network.ResourceTemplate(resTempIds[i], resTempZoneIds[i], resTempNames[i], resTempIcons[i]));
        }
        network.internalSetResourceTemplates(resourceTemplates);
        ArrayList<Long> removeDeviceIds = null;
        ArrayList<Integer> removeZoneIds = null;
        ArrayList<Integer> removeSceneIds = null;
        ArrayList<Integer> removeRuleIds = null;
        ArrayList<Resource> removeResources = null;
        for (long deviceId : deviceIds) {
            if (network.containsDevice(deviceId)) continue;
            Device device = Utils.addMissingDevice(networkId, deviceId);
            if (null == device) {
                Log.w(TAG, "cannot find device for networkId: " + networkId + ", deviceNodeId: " + deviceId);
                continue;
            }
            network.internalAddDevice(device);
        }
        for (long zoneId : (Object)zoneIds) {
            if (network.containsZone((int)zoneId)) continue;
            Zone zone = Utils.getZone(networkId, (int)zoneId);
            if (null == zone) {
                Log.w(TAG, "cannot find zone for network: " + networkId + ", zoneId: " + (int)zoneId);
                continue;
            }
            network.internalAddZone(zone);
        }
        for (long sceneId : (Object)sceneIds) {
            if (network.containsScene((int)sceneId)) continue;
            Scene scene = Utils.getScene(networkId, (int)sceneId);
            if (null == scene) {
                Log.w(TAG, "cannot find scene for network: " + networkId + ", sceneId: " + (int)sceneId);
                continue;
            }
            network.internalAddScene(scene);
        }
        for (long ruleId : (Object)ruleIds) {
            if (network.containsRule((int)ruleId)) continue;
            Rule rule = Utils.getRule(networkId, (int)ruleId);
            if (null == rule) {
                Log.w(TAG, "cannot find rule for network: " + networkId + ", ruleId: " + (int)ruleId);
                continue;
            }
            network.internalAddRule(rule);
        }
        if (network.getDeviceMap().size() != deviceIds.length) {
            HashSet<Long> deviceIdSet = new HashSet<Long>();
            for (long deviceId : deviceIds) {
                deviceIdSet.add(deviceId);
            }
            Object object = network.getDeviceIterable().iterator();
            while (object.hasNext()) {
                Device device = (Device)object.next();
                if (deviceIdSet.contains(device.getId())) continue;
                for (Resource r : device) {
                    Object parentZone = r.getParentZone();
                    r.internalRemoveResource();
                    device.internalRemoveResource(r.getId());
                    if (null == parentZone) {
                        Log.w(TAG, "zone not found for resource: " + r);
                        continue;
                    }
                    ((Zone)parentZone).internalRemoveResource(r);
                }
                if (null == removeDeviceIds) {
                    removeDeviceIds = new ArrayList<Long>();
                }
                removeDeviceIds.add(device.getId());
            }
        }
        if (network.getZoneMap().size() != zoneIds.length) {
            HashSet<Integer> zoneIdSet = new HashSet<Integer>();
            for (int zoneId : zoneIds) {
                zoneIdSet.add(zoneId);
            }
            Object object = network.getZoneIterable().iterator();
            while (object.hasNext()) {
                Zone zone = (Zone)object.next();
                if (zoneIdSet.contains(zone.getId())) continue;
                if (null == removeZoneIds) {
                    removeZoneIds = new ArrayList<Integer>();
                }
                removeZoneIds.add(zone.getId());
            }
        }
        if (network.getSceneMap().size() != sceneIds.length) {
            HashSet<Integer> sceneIdSet = new HashSet<Integer>();
            for (int sceneId : sceneIds) {
                sceneIdSet.add(sceneId);
            }
            Object object = network.getSceneIterable().iterator();
            while (object.hasNext()) {
                Scene scene = (Scene)object.next();
                if (sceneIdSet.contains(scene.getId())) continue;
                if (null == removeSceneIds) {
                    removeSceneIds = new ArrayList<Integer>();
                }
                removeSceneIds.add(scene.getId());
            }
        }
        if (network.getRuleMap().size() != ruleIds.length) {
            HashSet<Integer> ruleIdSet = new HashSet<Integer>();
            for (int ruleId : ruleIds) {
                ruleIdSet.add(ruleId);
            }
            Object object = network.getRuleIterable().iterator();
            while (object.hasNext()) {
                Rule rule = (Rule)object.next();
                if (ruleIdSet.contains(rule.getId())) continue;
                if (null == removeRuleIds) {
                    removeRuleIds = new ArrayList<Integer>();
                }
                removeRuleIds.add(rule.getId());
            }
        }
        if (null != removeDeviceIds) {
            Object object = removeDeviceIds.iterator();
            while (object.hasNext()) {
                Long deviceId = (Long)object.next();
                Object device = network.getDevice(deviceId);
                if (null != device) {
                    ((Device)device).internalRemoveDevice();
                }
                network.internalRemoveDevice(deviceId);
            }
        }
        if (null != removeZoneIds) {
            for (Integer zoneId : removeZoneIds) {
                network.internalRemoveZone(zoneId);
            }
        }
        if (null != removeSceneIds) {
            for (Integer sceneId : removeSceneIds) {
                network.internalRemoveScene(sceneId);
            }
        }
        if (null != removeRuleIds) {
            for (Integer ruleId : removeRuleIds) {
                network.internalRemoveRule(ruleId);
            }
        }
        for (Device d : network) {
            for (Resource r : d) {
                Object z = r.getParentZone();
                if (null == z || ((Zone)z).containsResource(r)) continue;
                if (null == removeResources) {
                    removeResources = new ArrayList<Resource>();
                }
                removeResources.add(r);
            }
        }
        if (null != removeResources) {
            for (Resource r : removeResources) {
                Object d = r.getParent();
                Log.d(TAG, "removing res: " + ((Device)d).getId() + " : " + r.getId());
                ((Device)d).internalRemoveResource(r.getId());
                r.internalRemoveResource();
            }
        }
        timeTaken = System.currentTimeMillis() - timeTaken;
        Log.d(TAG, "networkDataCallback: completed in: " + timeTaken + "ms");
        multiplexer.networkDataCallback(network);
    }

    @Override
    protected void mediaStreamStatusCallback(long streamHandle, int channelPort, int status, Object networkContext, Object streamContext) {
        CapabilityMediaStreaming.MediaStreamListener mediaStreamCallback = null;
        if (null != streamContext) {
            mediaStreamCallback = (CapabilityMediaStreaming.MediaStreamListener)((Context)streamContext).developerContext;
        }
        if (null == mediaStreamCallback) {
            throw new IllegalStateException("null context has been received in mediaStreamStatusCallback, context: " + streamContext);
        }
        Log.d(TAG, "mediaStreamStatusCallback: networkContext: " + networkContext);
        try {
            mediaStreamCallback.onStatusChanged(streamHandle, channelPort, CapabilityMediaStreaming.Status.getEnum(status));
        }
        catch (Throwable tr) {
            multiplexer.errorCallback(tr);
        }
    }

    @Override
    protected void snapshotReceiveCallback(String filePath, int status, Object snapshotContext) {
        CapabilitySnapshot.SnapshotListener listener = null;
        if (null != snapshotContext) {
            listener = (CapabilitySnapshot.SnapshotListener)this.cast(((Context)snapshotContext).developerContext);
        }
        if (null != listener) {
            listener.onSnapshotCaptured(filePath, status);
        } else {
            Log.d(TAG, "snapshotReceiveCallback: listener is null");
        }
    }

    @Override
    protected void mediaStreamReceiveCallback(long streamHandle, int channelPort, long frameIndex, int frameType, long frameDuration, long framePts, ByteBuffer data, Object networkContext, Object streamContext) {
        CapabilityMediaStreaming.MediaStreamListener mediaStreamCallback = null;
        if (null != streamContext) {
            mediaStreamCallback = (CapabilityMediaStreaming.MediaStreamListener)((Context)streamContext).developerContext;
        }
        if (null == mediaStreamCallback) {
            throw new IllegalStateException("null context has been received in mediaStreamStatusCallback, context: " + streamContext);
        }
        Log.d(TAG, "mediaStreamReceiveCallback: networkContext: " + networkContext);
        try {
            mediaStreamCallback.onDataReceived(streamHandle, channelPort, frameIndex, frameType, frameDuration, framePts, data);
        }
        catch (Throwable tr) {
            multiplexer.errorCallback(tr);
        }
    }

    @Override
    protected void receiveDataCallback(long sourceNodeId, String data, Object nativeNetworkContext) {
        Network.SdkContext sdkContext = (Network.SdkContext)((Context)nativeNetworkContext).sdkContext;
        Network network = Utils.getNetwork(sdkContext.getNetworkId());
        multiplexer.receiveDataCallback(network, sourceNodeId, data);
    }

    @Override
    protected void contentInfoCallback(long sourceNodeId, long contentTimestamp, String data, Object nativeNetworkContext) {
        Network.SdkContext sdkContext = (Network.SdkContext)((Context)nativeNetworkContext).sdkContext;
        Network network = Utils.getNetwork(sdkContext.getNetworkId());
        multiplexer.contentInfoCallback(network, sourceNodeId, contentTimestamp, data);
    }

    @Override
    protected void networkMetadataCallback(String metadata, Object nativeNetworkContext) {
        Network.SdkContext sdkContext = (Network.SdkContext)((Context)nativeNetworkContext).sdkContext;
        Network network = Utils.getNetwork(sdkContext.getNetworkId());
        if (null == network) {
            return;
        }
        network.internalSetMetadata(metadata);
        multiplexer.networkMetadataCallback(network);
    }

    private static int[] getZonesIdsWithDefaultIncluded(int[] zoneIds) {
        for (int zoneId : zoneIds) {
            if (0 != zoneId) continue;
            return zoneIds;
        }
        int[] zoneIdsWithDefault = new int[zoneIds.length + 1];
        System.arraycopy(zoneIds, 0, zoneIdsWithDefault, 0, zoneIds.length);
        zoneIdsWithDefault[zoneIds.length] = 0;
        return zoneIdsWithDefault;
    }

    private <T, U> U cast(T t) {
        return (U)t;
    }
}

