/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityAirQualitySensing;
import buzz.getcoco.iot.CapabilityColor;
import buzz.getcoco.iot.CapabilityContactSensing;
import buzz.getcoco.iot.CapabilityDoorLock;
import buzz.getcoco.iot.CapabilityEnergyMetering;
import buzz.getcoco.iot.CapabilityFireSensing;
import buzz.getcoco.iot.CapabilityFluidLevelSensing;
import buzz.getcoco.iot.CapabilityHumiditySensing;
import buzz.getcoco.iot.CapabilityHvacControl;
import buzz.getcoco.iot.CapabilityIlluminance;
import buzz.getcoco.iot.CapabilityImageControl;
import buzz.getcoco.iot.CapabilityKeyPressSensing;
import buzz.getcoco.iot.CapabilityLevel;
import buzz.getcoco.iot.CapabilityMediaStreaming;
import buzz.getcoco.iot.CapabilityMotionSensing;
import buzz.getcoco.iot.CapabilityMotorControl;
import buzz.getcoco.iot.CapabilityNetworkConfiguration;
import buzz.getcoco.iot.CapabilityOccupancySensing;
import buzz.getcoco.iot.CapabilityOnOff;
import buzz.getcoco.iot.CapabilityPowerLevels;
import buzz.getcoco.iot.CapabilityRealTimePosition;
import buzz.getcoco.iot.CapabilityRemoteControl;
import buzz.getcoco.iot.CapabilitySnapshot;
import buzz.getcoco.iot.CapabilityStationaryPosition;
import buzz.getcoco.iot.CapabilityStorageConfig;
import buzz.getcoco.iot.CapabilityStorageControl;
import buzz.getcoco.iot.CapabilityTemperatureSensing;
import buzz.getcoco.iot.CapabilityTunnel;
import buzz.getcoco.iot.CapabilityVibrationSensing;
import buzz.getcoco.iot.CapabilityWarning;
import buzz.getcoco.iot.CapabilityWindowCovering;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Creator;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;
import com.google.gson.JsonElement;

public interface DefaultCreator
extends Creator {
    @Override
    default public Network createNetwork(String id) {
        return new Network(id);
    }

    @Override
    default public Device createDevice(long deviceNodeId, Network parent) {
        return new Device(deviceNodeId, parent);
    }

    @Override
    default public Zone createZone(int zoneId, Network parent) {
        return new Zone(zoneId, parent);
    }

    @Override
    default public Scene createScene(int sceneId, Network parent) {
        return new Scene(sceneId, parent);
    }

    @Override
    default public Rule createRule(int id, Network parent) {
        return new Rule(id, parent);
    }

    @Override
    default public Resource createResource(String eui, Device parentDevice, Zone parentZone) {
        return new Resource(eui, parentDevice, parentZone);
    }

    @Override
    default public Resource createAdvertResource(String eui, Device parentDevice) {
        return this.createResource(eui, parentDevice, null);
    }

    @Override
    default public Attribute createAttribute(int id, Capability parent) {
        return new Attribute(id, parent);
    }

    @Override
    default public Capability createCapability(int capabilityId, Resource parent) {
        Capability capability;
        switch (Capability.CapabilityId.getEnum(capabilityId)) {
            case ON_OFF_CONTROL: {
                capability = new CapabilityOnOff(capabilityId, parent);
                break;
            }
            case LEVEL_CTRL: {
                capability = new CapabilityLevel(capabilityId, parent);
                break;
            }
            case COLOR_CTRL: {
                capability = new CapabilityColor(capabilityId, parent);
                break;
            }
            case LOCK_CONTROL: {
                capability = new CapabilityDoorLock(capabilityId, parent);
                break;
            }
            case ENERGY_METERING: {
                capability = new CapabilityEnergyMetering(capabilityId, parent);
                break;
            }
            case MOTION_SENSING: {
                capability = new CapabilityMotionSensing(capabilityId, parent);
                break;
            }
            case OCCUPANCY_SENSING: {
                capability = new CapabilityOccupancySensing(capabilityId, parent);
                break;
            }
            case CONTACT_SENSING: {
                capability = new CapabilityContactSensing(capabilityId, parent);
                break;
            }
            case FLUID_LEVEL_MEASUREMENT: {
                capability = new CapabilityFluidLevelSensing(capabilityId, parent);
                break;
            }
            case FIRE_SENSING: {
                capability = new CapabilityFireSensing(capabilityId, parent);
                break;
            }
            case TEMPERATURE_MEASUREMENT: {
                capability = new CapabilityTemperatureSensing(capabilityId, parent);
                break;
            }
            case ILLUMINANCE_MEASUREMENT: {
                capability = new CapabilityIlluminance(capabilityId, parent);
                break;
            }
            case POWER_LEVEL_MEASUREMENT: {
                capability = new CapabilityPowerLevels(capabilityId, parent);
                break;
            }
            case TUNNEL_CONTROL: {
                capability = new CapabilityTunnel(capabilityId, parent);
                break;
            }
            case REL_HUMIDITY_MEASUREMENT: {
                capability = new CapabilityHumiditySensing(capabilityId, parent);
                break;
            }
            case KEY_PRESS_SENSING: {
                capability = new CapabilityKeyPressSensing(capabilityId, parent);
                break;
            }
            case WARNING_DEV_CONTROL: {
                capability = new CapabilityWarning(capabilityId, parent);
                break;
            }
            case NETWORK_CONFIGURATION: {
                capability = new CapabilityNetworkConfiguration(capabilityId, parent);
                break;
            }
            case MEDIA_STREAM: {
                capability = new CapabilityMediaStreaming(capabilityId, parent);
                break;
            }
            case MOTOR_CONTROL: {
                capability = new CapabilityMotorControl(capabilityId, parent);
                break;
            }
            case STORAGE_CONTROL: {
                capability = new CapabilityStorageControl(capabilityId, parent);
                break;
            }
            case STORAGE_CONFIG: {
                capability = new CapabilityStorageConfig(capabilityId, parent);
                break;
            }
            case SNAPSHOT: {
                capability = new CapabilitySnapshot(capabilityId, parent);
                break;
            }
            case IMAGE_CONTROL: {
                capability = new CapabilityImageControl(capabilityId, parent);
                break;
            }
            case REAL_TIME_POS: {
                capability = new CapabilityRealTimePosition(capabilityId, parent);
                break;
            }
            case STATIONARY_POS: {
                capability = new CapabilityStationaryPosition(capabilityId, parent);
                break;
            }
            case AIR_QUALITY_SENSING: {
                capability = new CapabilityAirQualitySensing(capabilityId, parent);
                break;
            }
            case VIBRATION_SENSING: {
                capability = new CapabilityVibrationSensing(capabilityId, parent);
                break;
            }
            case WINDOW_COVERING: {
                capability = new CapabilityWindowCovering(capabilityId, parent);
                break;
            }
            case HVAC_CONTROL: {
                capability = new CapabilityHvacControl(capabilityId, parent);
                break;
            }
            case REMOTE_CONTROL: {
                capability = new CapabilityRemoteControl(capabilityId, parent);
                break;
            }
            default: {
                capability = new Capability(capabilityId, parent){

                    @Override
                    protected Command<? extends Capability.CommandId> extendedCreateCommand(int commandId, JsonElement commandParams) {
                        return null;
                    }
                };
            }
        }
        return capability;
    }
}

