/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Creator;
import buzz.getcoco.iot.DefaultCreator;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.Zone;

public class Factory {
    private static final String TAG = "Factory";
    private static final Creator DEFAULT_CREATOR;
    static Creator creator;

    static Network createNetwork(String id) {
        Network network = null;
        try {
            network = creator.createNetwork(id);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create network", tr);
        }
        return null != network ? network : DEFAULT_CREATOR.createNetwork(id);
    }

    static Device createDevice(long deviceNodeId, Network parent) {
        Device device = null;
        try {
            device = creator.createDevice(deviceNodeId, parent);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create device", tr);
        }
        return null != device ? device : DEFAULT_CREATOR.createDevice(deviceNodeId, parent);
    }

    static Zone createZone(int zoneId, Network parent) {
        Zone zone = null;
        try {
            zone = creator.createZone(zoneId, parent);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create zone", tr);
        }
        return null != zone ? zone : DEFAULT_CREATOR.createZone(zoneId, parent);
    }

    static Scene createScene(int id, Network parent) {
        Scene scene = null;
        try {
            scene = creator.createScene(id, parent);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create scene", tr);
        }
        return null != scene ? scene : DEFAULT_CREATOR.createScene(id, parent);
    }

    static Rule createRule(int id, Network parent) {
        Rule rule = null;
        try {
            rule = creator.createRule(id, parent);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create rule", tr);
        }
        return null != rule ? rule : DEFAULT_CREATOR.createRule(id, parent);
    }

    static Resource createResource(String eui, Device parentDevice, Zone parentZone) {
        Resource resource = null;
        try {
            resource = creator.createResource(eui, parentDevice, parentZone);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create resource", tr);
        }
        return null != resource ? resource : DEFAULT_CREATOR.createResource(eui, parentDevice, parentZone);
    }

    static Resource createAdvertResource(String eui, Device parentDevice) {
        Resource resource = null;
        try {
            resource = creator.createAdvertResource(eui, parentDevice);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create resource", tr);
        }
        return null != resource ? resource : DEFAULT_CREATOR.createAdvertResource(eui, parentDevice);
    }

    static Attribute createAttribute(int id, Capability parent) {
        Attribute attribute = null;
        try {
            attribute = creator.createAttribute(id, parent);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create attribute", tr);
        }
        return null != attribute ? attribute : DEFAULT_CREATOR.createAttribute(id, parent);
    }

    static Capability createCapability(int capabilityId, Resource parent) {
        Capability capability = null;
        try {
            capability = creator.createCapability(capabilityId, parent);
        }
        catch (Throwable tr) {
            Log.e(TAG, "cannot create capability", tr);
        }
        return null != capability ? capability : DEFAULT_CREATOR.createCapability(capabilityId, parent);
    }

    static {
        creator = DEFAULT_CREATOR = new DefaultCreator(){};
    }
}

