/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FiniteStateMachine<S extends State, E extends Event, A> {
    private static final String TAG = "FiniteStateMachine";
    private int runCount = 0;
    private S currentState;
    private final TimerCallback<A> timerCallback;
    private final List<EventTable<S, E, A>> eventTables;
    private final List<StateTable<S, E, A>> stateTables;

    public FiniteStateMachine(S initialState, TimerCallback<A> timerCallback, List<EventTable<S, E, A>> eventTables, List<StateTable<S, E, A>> stateTables) {
        this.currentState = initialState;
        this.timerCallback = timerCallback;
        this.eventTables = new ArrayList<EventTable<S, EventTable<S, E, A>, A>>(eventTables);
        this.stateTables = new ArrayList<StateTable<S, StateTable<S, E, A>, A>>(stateTables);
    }

    public synchronized void handleEvent(E event, A args) {
        Event newEvent;
        Log.d(TAG, "handleEvent: started");
        if (null == event) {
            throw new NullPointerException();
        }
        do {
            ++this.runCount;
            Log.d(TAG, "event: " + event + ", currentState: " + this.currentState + ", runCount: " + this.runCount);
            int etIndex = this.getIndex((S)event);
            if (0 > etIndex) {
                throw new IllegalArgumentException("unknown event: " + event + ", onState: " + this.currentState);
            }
            newEvent = null;
            EventTable<S, E, A> eventTable = this.eventTables.get(etIndex);
            Log.v(TAG, "eventTable: " + eventTable);
            if (null == eventTable.nextState) {
                if (null != ((EventTable)eventTable).actionCallback) {
                    ((EventTable)eventTable).actionCallback.triggerAction(args);
                }
                Log.v(TAG, "no next state, exiting");
                return;
            }
            int stIndex = this.getIndex(this.currentState);
            if (0 > stIndex) {
                throw new IllegalArgumentException("unknown current state " + this.currentState);
            }
            StateTable<S, E, A> oldStateTable = this.stateTables.get(stIndex);
            Log.v(TAG, "oldTable: " + oldStateTable);
            if (null != ((EventTable)eventTable).actionCallback) {
                ((EventTable)eventTable).actionCallback.triggerAction(args);
            }
            if (null != ((StateTable)oldStateTable).exitCallback) {
                ((StateTable)oldStateTable).exitCallback.triggerExit(args);
            }
            this.currentState = eventTable.nextState;
            Log.v(TAG, "nextState: " + this.currentState);
            stIndex = this.getIndex(this.currentState);
            if (0 > stIndex) {
                throw new IllegalArgumentException("unknown current state " + this.currentState);
            }
            StateTable<S, E, A> curStateTable = this.stateTables.get(stIndex);
            Log.v(TAG, "curTable: " + curStateTable);
            if (null != this.timerCallback) {
                this.timerCallback.triggerTimer(curStateTable.fetch.getTimeout(), args);
            }
            if (null == ((StateTable)curStateTable).entryCallback) continue;
            newEvent = (Event)((StateTable)curStateTable).entryCallback.triggerEntry(args);
        } while (null != (event = newEvent));
        Log.d(TAG, "handleEvent: completed");
    }

    public void unsafeSetState(S state) {
        this.currentState = state;
    }

    public S getCurrentState() {
        return this.currentState;
    }

    private int getIndex(E event) {
        for (int i = 0; i < this.eventTables.size(); ++i) {
            EventTable<S, E, A> eventTable = this.eventTables.get(i);
            boolean isSameEvent = Objects.equals(eventTable.event, event);
            boolean isSameState = Objects.equals(eventTable.conditionState, this.currentState);
            if (!isSameEvent || !isSameState) continue;
            return i;
        }
        return -1;
    }

    private int getIndex(S state) {
        for (int i = 0; i < this.stateTables.size(); ++i) {
            if (this.stateTables.get((int)i).state != state && !this.stateTables.get((int)i).state.equals(state)) continue;
            return i;
        }
        return -1;
    }

    public static class StateTable<S extends State, E extends Event, A> {
        public final S state;
        public final FetchTimeout fetch;
        private final EntryActionCallback<E, A> entryCallback;
        private final ExitActionCallback<A> exitCallback;

        public StateTable(S state, long timeout, EntryActionCallback<E, A> entryCallback, ExitActionCallback<A> exitCallback) {
            this.state = state;
            this.entryCallback = entryCallback;
            this.exitCallback = exitCallback;
            this.fetch = () -> timeout;
        }

        public StateTable(S state, FetchTimeout fetch, EntryActionCallback<E, A> entryCallback, ExitActionCallback<A> exitCallback) {
            this.state = state;
            this.fetch = fetch;
            this.entryCallback = entryCallback;
            this.exitCallback = exitCallback;
        }

        public String toString() {
            return "StateTable{state=" + this.state + ", timeout=" + this.fetch.getTimeout() + ", fetch=" + this.fetch + ", entryCallback=" + this.entryCallback + ", exitCallback=" + this.exitCallback + '}';
        }
    }

    public static class EventTable<S extends State, E extends Event, A> {
        public final E event;
        public final S conditionState;
        public final S nextState;
        private final ActionCallback<A> actionCallback;

        public EventTable(E event, S conditionState, S nextState, ActionCallback<A> actionCallback) {
            this.event = event;
            this.conditionState = conditionState;
            this.nextState = nextState;
            this.actionCallback = actionCallback;
        }

        public String toString() {
            return "EventTable{event=" + this.event + ", conditionState=" + this.conditionState + ", nextState=" + this.nextState + ", actionCallback=" + this.actionCallback + '}';
        }
    }

    public static interface FetchTimeout {
        public long getTimeout();
    }

    public static interface TimerCallback<A> {
        public void triggerTimer(long var1, A var3);
    }

    public static interface ActionCallback<A> {
        public void triggerAction(A var1);
    }

    public static interface ExitActionCallback<A> {
        public void triggerExit(A var1);
    }

    public static interface EntryActionCallback<E, A> {
        public E triggerEntry(A var1);
    }

    public static interface State {
    }

    public static interface Event {
    }
}

