/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.CapabilityRemoteControl;
import buzz.getcoco.iot.CapabilityStorageControl;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandIdInterface;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.InfoRequest;
import buzz.getcoco.iot.Parameter;
import buzz.getcoco.iot.StorageContentMetadata;
import buzz.getcoco.iot.Utils;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InfoResponse {
    private static final Class<?>[] PARAM_CLASS_LUT = new Class[Parameter.Key.values().length];
    private static final Class<?>[] SEARCH_CLASS_LUT;
    protected transient Command.State state;
    protected transient String networkId;
    private transient long requestNodeId;
    private transient long infoRequestId;
    private transient long cmdSeqNum;
    private final List<Parameter<Value>> parameters;

    public InfoResponse(InfoRequest infoRequest, List<Parameter<Value>> parameters) {
        this(infoRequest.requestId, infoRequest.cmdSeqNum, infoRequest.networkId, infoRequest.deviceNodeId, parameters);
    }

    public InfoResponse(long infoRequestId, long cmdSeqNum, List<Parameter<Value>> parameters) {
        this(infoRequestId, cmdSeqNum, null, parameters);
    }

    public InfoResponse(long infoRequestId, long cmdSeqNum, Device device, List<Parameter<Value>> parameters) {
        this(infoRequestId, cmdSeqNum, null == device ? null : device.getParent().getId(), null == device ? -1L : device.getId(), parameters);
    }

    public InfoResponse(long infoRequestId, long cmdSeqNum, String networkId, long requestNodeId, List<Parameter<Value>> parameters) {
        this.infoRequestId = infoRequestId;
        this.parameters = new ArrayList<Parameter<Value>>(parameters);
        this.networkId = networkId;
        this.requestNodeId = requestNodeId;
        this.cmdSeqNum = cmdSeqNum;
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(InfoResponse.class, (Object)new InfoResponseParser());
        Command.GSON_BUILDER.registerTypeAdapter(Search.class, (Object)new SearchResultsParser());
    }

    public Command.State getState() {
        return this.state;
    }

    public void setDevice(Device device) {
        this.requestNodeId = null == device ? -1L : device.getId();
    }

    public Device getDevice() {
        return Utils.getDevice(CocoClient.getInstance().getNetworkMap(), this.networkId, this.requestNodeId);
    }

    protected void setCmdSeqNum(long cmdSeqNum) {
        this.cmdSeqNum = cmdSeqNum;
    }

    protected void setInfoRequestId(long infoRequestId) {
        this.infoRequestId = infoRequestId;
    }

    public List<Parameter<Value>> getParameters() {
        return this.parameters;
    }

    public Parameter.Key[] getKeys() {
        Parameter.Key[] keys = new Parameter.Key[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            keys[i] = this.parameters.get((int)i).key;
        }
        return keys;
    }

    protected void setRequestNodeId(long requestNodeId) {
        this.requestNodeId = requestNodeId;
    }

    public long getRequestNodeId() {
        return this.requestNodeId;
    }

    public long getInfoRequestId() {
        return this.infoRequestId;
    }

    public long getCmdSeqNum() {
        return this.cmdSeqNum;
    }

    protected JsonElement toJson() {
        return Command.GSON_BUILDER.create().toJsonTree((Object)this);
    }

    static {
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.USER_DEFINED.ordinal()] = UserDefined.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.USERNAME.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.PASSWORD.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.PIN.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.OTP.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.INSTALL_CODE.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.CSA.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.DSK.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.RESOURCE_NAME.ordinal()] = Parameter.StringValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.AVAIL_LISTEN_PORT.ordinal()] = ListenPort.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.CONTENT_SEARCH.ordinal()] = ContentSearch.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.CONTENT_PLAYBACK.ordinal()] = ContentPlayback.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.STREAM_BUFFER_SIZES.ordinal()] = Parameter.BufferSizeValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.PAIRING_TYPE.ordinal()] = Parameter.PairingTypeValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.TIMEZONE.ordinal()] = Parameter.TimeZoneValue.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.REMOTE_PAIRING_CODES.ordinal()] = RemotePairingCode.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.REMOTE_PAIR_CAPABILITIES.ordinal()] = RemotePairingCapabilities.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.REMOTE_SEARCH.ordinal()] = Search.class;
        InfoResponse.PARAM_CLASS_LUT[Parameter.Key.REMOTE_BUTTON_INFO.ordinal()] = RemoteButtonInfo.class;
        SEARCH_CLASS_LUT = new Class[Parameter.SearchType.values().length];
        InfoResponse.SEARCH_CLASS_LUT[Parameter.SearchType.BRAND.ordinal()] = BrandSearchResults.class;
    }

    private static final class SearchResultsParser
    implements JsonSerializer<Search>,
    JsonDeserializer<Search> {
        private SearchResultsParser() {
        }

        public Search deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            long searchCount = jsonObject.get("totalSearchCount").getAsLong();
            Parameter.SearchType searchType = (Parameter.SearchType)((Object)jdc.deserialize(jsonObject.get("searchType"), Parameter.SearchType.class));
            SearchResults[] searchResults = (SearchResults[])jdc.deserialize(jsonObject.get("searchResultsArr"), Array.newInstance(SEARCH_CLASS_LUT[searchType.ordinal()], 0).getClass());
            return new Search(searchCount, searchType, searchResults);
        }

        public JsonElement serialize(Search search, Type type, JsonSerializationContext jsonSerializationContext) {
            return jsonSerializationContext.serialize((Object)search);
        }
    }

    private static final class InfoResponseParser
    implements JsonSerializer<InfoResponse>,
    JsonDeserializer<InfoResponse> {
        private InfoResponseParser() {
        }

        public InfoResponse deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Value[] paramValues;
            Parameter.Key[] paramKeys;
            Gson gson = Command.GSON_BUILDER.create();
            if (!jsonElement.isJsonObject()) {
                return new InfoResponse(-1L, -1L, new ArrayList<Parameter<Value>>(0));
            }
            JsonObject json = jsonElement.getAsJsonObject();
            JsonArray paramsJson = json.getAsJsonArray("infoResponseArr");
            if (null != paramsJson) {
                int index = 0;
                paramKeys = new Parameter.Key[paramsJson.size()];
                paramValues = new Value[paramsJson.size()];
                for (JsonElement paramJsonElement : paramsJson) {
                    JsonObject paramJson = paramJsonElement.getAsJsonObject();
                    Parameter.Key key = (Parameter.Key)((Object)gson.fromJson(paramJson.get("key"), Parameter.Key.class));
                    Class keyType = PARAM_CLASS_LUT[key.ordinal()];
                    paramKeys[index] = key;
                    if (null != keyType) {
                        Value value;
                        paramValues[index] = value = (Value)gson.fromJson(paramJson.get("value"), (Type)keyType);
                    }
                    ++index;
                }
            } else {
                paramKeys = new Parameter.Key[]{};
                paramValues = new Value[]{};
            }
            ArrayList<Parameter<Value>> parameters = new ArrayList<Parameter<Value>>(paramKeys.length);
            for (int i = 0; i < paramKeys.length; ++i) {
                parameters.add(new Parameter<Value>(paramKeys[i], paramValues[i]));
            }
            return new InfoResponse(-1L, -1L, parameters);
        }

        public JsonElement serialize(InfoResponse infoResponse, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            Gson gson = Command.GSON_BUILDER.create();
            json.add("infoResponseArr", gson.toJsonTree((Object)infoResponse.parameters));
            return json;
        }
    }

    public static class ListenPort
    implements Value {
        @SerializedName(value="portArr")
        public int[] ports;
    }

    public static class UserDefined
    implements Value {
        public String response;
    }

    public static class ContentSearch
    implements Value {
        @SerializedName(value="totalSearchCount")
        public long totalSearchCount;
        @SerializedName(value="contentMetaDataArr")
        public StorageContentMetadata[] contentMetadata;
    }

    public static class ContentPlayback
    implements Value {
        @SerializedName(value="playbackUrl")
        public String playbackUrl;
        @SerializedName(value="contentPlaybackReqError")
        public CapabilityStorageControl.PlaybackError playbackError;
        @SerializedName(value="streamProtocolType")
        public CapabilityStorageControl.StreamProtocol streamProtocol;
    }

    public static class RemotePairingCapabilities
    implements Value {
        @SerializedName(value="capabilityId")
        private final Capability.CapabilityId capId;
        @SerializedName(value="commandIdArray")
        private final int[] commandSupportedArr;
        @SerializedName(value="attributeIdArray")
        private final int[] attrIdArr;

        public RemotePairingCapabilities(Capability.CapabilityId capId, int[] commandSupportedArr, int[] attrIdArr) {
            this.capId = capId;
            this.commandSupportedArr = commandSupportedArr;
            this.attrIdArr = attrIdArr;
        }

        public Capability.CapabilityId getCapabilityId() {
            return this.capId;
        }

        public List<CommandIdInterface> getCommandSupportedArr() {
            if (null == this.commandSupportedArr) {
                return Collections.emptyList();
            }
            ArrayList<CommandIdInterface> supportedCommands = new ArrayList<CommandIdInterface>();
            for (int command : this.commandSupportedArr) {
                supportedCommands.add(this.capId.getCommandId(command));
            }
            return supportedCommands;
        }

        public List<Capability.AttributeId> getAttributes() {
            if (null == this.attrIdArr) {
                return Collections.emptyList();
            }
            ArrayList<Capability.AttributeId> supportedAttr = new ArrayList<Capability.AttributeId>();
            for (int attrId : this.attrIdArr) {
                supportedAttr.add(this.capId.getAttributeId(attrId));
            }
            return supportedAttr;
        }
    }

    public static final class RemoteButtonInfo
    implements Value {
        @SerializedName(value="buttonInfo")
        public List<CapabilityRemoteControl.RemoteControlButtonInfo> buttonsInfo;

        public RemoteButtonInfo(List<CapabilityRemoteControl.RemoteControlButtonInfo> buttonsInfo) {
            this.buttonsInfo = buttonsInfo;
        }
    }

    public static class RemotePairingCode
    implements Value {
        @SerializedName(value="pairingCodes")
        public int[] pairingCodes;
    }

    public static class Search
    implements Value {
        @SerializedName(value="totalSearchCount")
        public final long totalSearchCount;
        @SerializedName(value="searchType")
        public final Parameter.SearchType searchType;
        @SerializedName(value="searchResultsArr")
        public final SearchResults[] searchResults;

        public Search(long totalSearchCount, Parameter.SearchType searchType, SearchResults[] searchResults) {
            this.totalSearchCount = totalSearchCount;
            this.searchType = searchType;
            this.searchResults = searchResults;
        }
    }

    public static class BrandSearchResults
    implements SearchResults {
        @SerializedName(value="brandId")
        public final int brandId;
        @SerializedName(value="brandName")
        public final String brandName;

        public BrandSearchResults(int brandId, String brandName) {
            this.brandId = brandId;
            this.brandName = brandName;
        }
    }

    public static interface SearchResults {
    }

    public static interface Value
    extends Parameter.Value {
    }
}

