/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.Log;
import buzz.getcoco.iot.Network;
import java.nio.ByteBuffer;

class NativeCallbacks {
    private static final String TAG = "NativeCallbacks";

    NativeCallbacks() {
    }

    static Object longToObj(long val) {
        return val;
    }

    static Object boolToObj(boolean val) {
        return val;
    }

    static Object doubleToObj(double val) {
        return val;
    }

    static Object createNetworkArray(int size) {
        return new Network[size];
    }

    static Object createNetwork(String id, String name, int netType, int userRole, int accessType) {
        try {
            Network network = Factory.createNetwork(id);
            network.internalSetName(name);
            network.internalSetNetworkType(Network.NetworkType.getEnum(netType));
            network.internalSetUserRole(Network.UserRole.getEnum(userRole));
            network.internalSetAccessType(Network.AccessType.getEnum(accessType));
            return network;
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
            throw new IllegalArgumentException(tr);
        }
    }

    static void connectStatusCallback(String networkId, int networkState, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().connectStatusCallback(networkId, networkState, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void leaveNetworkStatusCallback(int status, Object nativeContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().leaveNetworkStatusCallback(status, nativeContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void deviceInfoCallback(boolean trigger, boolean append, String networkId, long deviceNodeId, String name, String devicePsn, String productName, String make, String model, String firmwareVersion, int powerSource, int receiverType, boolean extendable, int[] protocolsSupported, String[] resourceEuis, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().deviceInfoCallback(trigger, append, networkId, deviceNodeId, name, devicePsn, productName, make, model, firmwareVersion, powerSource, receiverType, extendable, protocolsSupported, resourceEuis, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void resourceSummaryCallback(boolean trigger, String networkId, long deviceNodeId, String resourceEui, String name, String metadata, String manufacturer, String model, String firmware, int powerSource, int receiverType, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().resourceSummaryCallback(trigger, networkId, deviceNodeId, resourceEui, name, metadata, manufacturer, model, firmware, powerSource, receiverType, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void resourceCapabilityCallback(boolean trigger, String networkId, long deviceNodeId, String resourceEui, int capabilityId, String name, int[] standardCommandArr, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().resourceCapabilityCallback(trigger, networkId, deviceNodeId, resourceEui, capabilityId, name, standardCommandArr, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void resourceAttributeCallback(boolean trigger, String networkId, long deviceNodeId, String resourceEui, int capabilityId, int attributeId, String name, String description, long minReportingInterval, long maxReportingInterval, int dataType, int arrayLength, Object minValue, Object maxValue, Object defaultValue, Object currentValue, boolean realtimeUpdate, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().resourceAttributeCallback(trigger, networkId, deviceNodeId, resourceEui, capabilityId, attributeId, name, description, minReportingInterval, maxReportingInterval, dataType, arrayLength, minValue, maxValue, defaultValue, currentValue, realtimeUpdate, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void commandStatusCallback(int status, String responseJson, Object nativeNetworkContext, Object nativeCommandContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().commandStatusCallback(status, responseJson, nativeNetworkContext, nativeCommandContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void networkListCallback(String[] networkIds, String[] networkNames, int[] netTypes, int[] userRoles, int[] accessTypes, Object nativeRequestContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().networkListCallback(networkIds, networkNames, netTypes, userRoles, accessTypes, nativeRequestContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void authCallback(String authorizationEndpoint, String tokenEndpoint) {
        try {
            CocoClient.getInstance().getCallbacksHandler().authCallback(authorizationEndpoint, tokenEndpoint);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void deviceManagementStatusCallback(String networkId, long deviceNodeId, int status, String[] impactedResourcesEuiArr, Object nativeNetworkContext, Object nativeCommandContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().deviceManagementStatusCallback(networkId, deviceNodeId, status, impactedResourcesEuiArr, nativeNetworkContext, nativeCommandContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void infoResponseStatusCallback(int status, Object nativeContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().infoResponseStatusCallback(status, nativeContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void infoRequestCallback(String networkId, long requestNodeId, long responseNodeId, long requestId, long cmdSeqNum, String infoRequestJson, Object nativeNetworkContext, Object nativeCommandContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().infoRequestCallback(networkId, requestNodeId, responseNodeId, requestId, cmdSeqNum, infoRequestJson, nativeNetworkContext, nativeCommandContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void infoResponseCallback(String networkId, long requestNodeId, long requestId, long cmdSeqNum, String infoResponseJson, Object nativeNetworkContext, Object nativeCommandContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().infoResponseCallback(networkId, requestNodeId, requestId, cmdSeqNum, infoResponseJson, nativeNetworkContext, nativeCommandContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void infoRequestStatusCallback(int status, Object nativeContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().infoRequestStatusCallback(status, nativeContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void messageCallback(String title, String message, int messageType, Object nativeNetworkContext, Object nativeCommandContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().messageCallback(title, message, messageType, nativeNetworkContext, nativeCommandContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void advertiseResourceCallback(String networkId, long deviceNodeId, String resourceEui, String resourceName, int protocol, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().advertiseResourceCallback(networkId, deviceNodeId, resourceEui, resourceName, protocol, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void resourceIncludedCallback(String networkId, long[] deviceNodeIds, String[] resourceEuis, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().resourceIncludedCallback(networkId, deviceNodeIds, resourceEuis, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void resourceExcludedCallback(String networkId, long deviceNodeId, String resourceEui, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().resourceExcludedCallback(networkId, deviceNodeId, resourceEui, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void tunnelStatusCallback(long tunnelHandle, int status, int port, Object nativeTunnelContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().tunnelStatusCallback(tunnelHandle, status, port, nativeTunnelContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void zoneInfoCallback(boolean trigger, String networkId, int zoneId, String zoneName, long[] deviceNodeIds, String[] resourceEuis, String[] resourceNames, Object context) {
        try {
            CocoClient.getInstance().getCallbacksHandler().zoneInfoCallback(trigger, networkId, zoneId, zoneName, deviceNodeIds, resourceEuis, resourceNames, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void zoneDeletedCallback(String networkId, int zoneId, Object context) {
        try {
            CocoClient.getInstance().getCallbacksHandler().zoneDeletedCallback(networkId, zoneId, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void sceneInfoCallback(boolean trigger, String networkId, int sceneId, String sceneName, String metadata, String[] resourceCommands, Object context) {
        try {
            CocoClient.getInstance().getCallbacksHandler().sceneInfoCallback(trigger, networkId, sceneId, sceneName, metadata, resourceCommands, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void sceneDeletedCallback(String networkId, int sceneId, Object context) {
        try {
            CocoClient.getInstance().getCallbacksHandler().sceneDeletedCallback(networkId, sceneId, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void ruleInfoCallback(boolean trigger, String networkId, int ruleId, String ruleName, String[] resourceConditions, String[] scheduleConditions, String[] resourceActions, String[] sceneActions, Object nativeContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().ruleInfoCallback(trigger, networkId, ruleId, ruleName, resourceConditions, scheduleConditions, resourceActions, sceneActions, nativeContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void ruleDeletedCallback(String networkId, int ruleId, Object nativeContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().ruleDeletedCallback(networkId, ruleId, nativeContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void networkManagementStatusCallback(String networkId, int commandStatus, int errorCode, String errorMessage, String fieldName, Object commandContext, Object networkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().networkManagementStatusCallback(networkId, commandStatus, errorCode, errorMessage, fieldName, commandContext, networkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void accessTokenCallback(String accessToken, int status, Object context) {
        try {
            CocoClient.getInstance().getCallbacksHandler().accessTokenCallback(accessToken, status, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void nodeConnectionStatusCallback(String networkId, long nodeId, int nativeNodeType, boolean isOnline, Object nativeContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().nodeConnectionStatusCallback(networkId, nodeId, nativeNodeType, isOnline, nativeContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void networkDataCallback(String networkId, int[] resTempZoneIds, String[] resTempIds, String[] resTempNames, String[] resTempIcons, long[] deviceIds, int[] zoneIds, int[] sceneIds, int[] ruleIds, Object context) {
        try {
            CocoClient.getInstance().getCallbacksHandler().networkDataCallback(networkId, resTempZoneIds, resTempIds, resTempNames, resTempIcons, deviceIds, zoneIds, sceneIds, ruleIds, context);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void mediaStreamStatusCallback(long streamHandle, int channelPort, int status, Object networkContext, Object streamContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().mediaStreamStatusCallback(streamHandle, channelPort, status, networkContext, streamContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void mediaStreamReceiveCallback(long streamHandle, int channelPort, long frameIndex, int frameType, long frameDuration, long framePts, ByteBuffer data, Object networkContext, Object streamContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().mediaStreamReceiveCallback(streamHandle, channelPort, frameIndex, frameType, frameDuration, framePts, data, networkContext, streamContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void snapshotReceiveCallback(String filePath, int status, Object snapshotContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().snapshotReceiveCallback(filePath, status, snapshotContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void receiveDataCallback(long sourceNodeId, String data, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().receiveDataCallback(sourceNodeId, data, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void contentInfoCallback(long sourceNodeId, long contentTimestamp, String data, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().contentInfoCallback(sourceNodeId, contentTimestamp, data, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void networkMetadataCallback(String metadata, Object nativeNetworkContext) {
        try {
            CocoClient.getInstance().getCallbacksHandler().networkMetadataCallback(metadata, nativeNetworkContext);
        }
        catch (Throwable tr) {
            NativeCallbacks.logAndRaiseError(tr);
        }
    }

    static void logAndRaiseError(Throwable tr) {
        Log.e(TAG, "logAndRaiseError: error", tr);
        Exception ex = tr instanceof Exception ? (Exception)tr : new Exception(tr);
        try {
            CocoClient.getInstance().getCallbacksHandler().errorCallback(ex);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

