/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.CocoClient;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.CommandIdInterface;
import buzz.getcoco.iot.CommandResponse;
import buzz.getcoco.iot.ConnectivityStateManager;
import buzz.getcoco.iot.DeepSerializer;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.Listener;
import buzz.getcoco.iot.Resource;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.ResourceCondition;
import buzz.getcoco.iot.Rule;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;
import buzz.getcoco.iot.Utils;
import buzz.getcoco.iot.Zone;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Network
implements Iterable<Device> {
    static int clearNetworkForState = Network.createClearOnDisconnectionFlag(State.CONNECTION_ERROR, State.NETWORK_RESET, State.DISCONNECTED);
    @SerializedName(value="networkId")
    private final String id;
    @SerializedName(value="networkName")
    private String name;
    @SerializedName(value="networkUserRole")
    private UserRole userRole;
    @SerializedName(value="networkAccessType")
    private AccessType accessType;
    @SerializedName(value="networkType")
    private NetworkType networkType;
    private transient State state = State.DISCONNECTED;
    private transient ConnectivityStateManager.State connectivityManagerState = ConnectivityStateManager.State.OFFLINE;
    @SerializedName(value="networkDevices")
    private Map<Long, Device> deviceMap;
    @SerializedName(value="networkZones")
    private Map<Integer, Zone> zoneMap;
    @SerializedName(value="networkScenes")
    private Map<Integer, Scene> sceneMap;
    @SerializedName(value="networkRules")
    private Map<Integer, Rule> ruleMap;
    @SerializedName(value="resourceTemplates")
    private List<ResourceTemplate> resourceTemplates;
    @SerializedName(value="metadata")
    private String metadata;
    private transient Iterable<Device> deviceIterable;
    private transient Iterable<Zone> zoneIterable;
    private transient Iterable<Scene> sceneIterable;
    private transient Iterable<Rule> ruleIterable;

    public static int createClearOnDisconnectionFlag(State ... states) {
        int flags = 0;
        for (State state : states) {
            flags |= 1 << state.ordinal();
        }
        return flags;
    }

    public static boolean containsClearFlag(State state) {
        int flag = 1 << state.ordinal();
        return flag == (clearNetworkForState & flag);
    }

    protected Network(String id) {
        Zone defaultZone = Factory.createZone(0, this);
        this.getZoneMap().put(0, defaultZone);
        defaultZone.internalSetName(Zone.defaultZoneName);
        this.id = id;
        this.userRole = UserRole.GUEST;
        this.accessType = AccessType.REMOTE;
    }

    public static void connectWithInvite(String networkId, String networkName, NetworkType networkType, UserRole userRole, AccessType accessType, String inviteUrl, long nodeId) {
        Object network = CocoClient.getInstance().getNetwork(networkId);
        if (null == network) {
            network = Factory.createNetwork(networkId);
        }
        ((Network)network).internalSetNetworkType(networkType);
        ((Network)network).internalSetName(networkName);
        ((Network)network).internalSetAccessType(accessType);
        ((Network)network).internalSetUserRole(userRole);
        Network.connectWithInvite((Network)network, inviteUrl, nodeId);
    }

    public static void connectWithInvite(Network network, String inviteUrl, long nodeId) {
        CocoClient.getInstance().getNativeHandler().connectWithInvite(network, inviteUrl, nodeId);
        CocoClient.getInstance().internalAddNetwork(network);
    }

    public void connect() {
        this.connect(0);
    }

    public void connect(int port) {
        Map<String, Network> networkMap = CocoClient.getInstance().getNetworkMap();
        CocoClient.getInstance().getNativeHandler().connect(this, port);
        networkMap.put(this.getId(), this);
    }

    public void disconnect() {
        CocoClient.getInstance().getNativeHandler().disconnect(this);
    }

    public void leave(LeaveStatusListener listener) {
        CocoClient.getInstance().getNativeHandler().leaveNetwork(this, listener);
    }

    public void sendNetworkManagementCommand(Command<CommandId> command, NetworkManagementStatusListener listener) {
        CocoClient.getInstance().getNativeHandler().sendNetworkManagementCommand(this, command, listener);
    }

    public void createZone(String zoneName, NetworkManagementStatusListener listener) {
        this.sendNetworkManagementCommand(new SetZone(zoneName), listener);
    }

    public void deleteZone(Zone zone, NetworkManagementStatusListener listener) {
        this.deleteZone(new Zone[]{zone}, listener);
    }

    public void deleteZone(Zone[] zones, NetworkManagementStatusListener listener) {
        this.sendNetworkManagementCommand(new RemoveZone(zones), listener);
    }

    public void moveResources(Zone fromZone, Zone toZone, Resource[] resources, NetworkManagementStatusListener listener) {
        this.sendNetworkManagementCommand(new MoveResourcesBetweenZones(fromZone, toZone, resources), listener);
    }

    public void createScene(String sceneName, NetworkManagementStatusListener listener) {
        this.sendNetworkManagementCommand(new SetScene(sceneName), listener);
    }

    public void deleteScene(Scene scene, NetworkManagementStatusListener listener) {
        this.deleteScene(new Scene[]{scene}, listener);
    }

    public void deleteScene(Scene[] scenes, NetworkManagementStatusListener listener) {
        this.sendNetworkManagementCommand(new RemoveScene(scenes), listener);
    }

    public void createRule(String ruleName, NetworkManagementStatusListener listener) {
        this.sendNetworkManagementCommand(new SetRule(ruleName), listener);
    }

    public void deleteRule(Rule rule, NetworkManagementStatusListener listener) {
        this.deleteRule(new Rule[]{rule}, listener);
    }

    public void deleteRule(Rule[] rules, NetworkManagementStatusListener listener) {
        this.sendNetworkManagementCommand(new RemoveRule(rules), listener);
    }

    public final String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public State getState() {
        return this.state;
    }

    public ConnectivityStateManager.State getConnectivityManagerState() {
        return this.connectivityManagerState;
    }

    public UserRole getUserRole() {
        return this.userRole;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public Map<Long, Device> getDeviceMap() {
        if (null == this.deviceMap) {
            this.deviceMap = new ConcurrentHashMap<Long, Device>();
        }
        return this.deviceMap;
    }

    public Map<Integer, Zone> getZoneMap() {
        if (null == this.zoneMap) {
            this.zoneMap = new ConcurrentHashMap<Integer, Zone>();
        }
        return this.zoneMap;
    }

    public Map<Integer, Scene> getSceneMap() {
        if (null == this.sceneMap) {
            this.sceneMap = new ConcurrentHashMap<Integer, Scene>();
        }
        return this.sceneMap;
    }

    public Map<Integer, Rule> getRuleMap() {
        if (null == this.ruleMap) {
            this.ruleMap = new ConcurrentHashMap<Integer, Rule>();
        }
        return this.ruleMap;
    }

    public List<ResourceTemplate> getResourceTemplates() {
        return this.resourceTemplates;
    }

    public final <T extends Device> T getDevice(long deviceNodeId) {
        return (T)((Device)Utils.castUp(this.getDeviceMap().get(deviceNodeId)));
    }

    public final <T extends Zone> T getZone(int zoneId) {
        return (T)((Zone)Utils.castUp(this.getZoneMap().get(zoneId)));
    }

    public final <T extends Scene> T getScene(int sceneId) {
        return (T)((Scene)Utils.castUp(this.getSceneMap().get(sceneId)));
    }

    public final <T extends Rule> T getRule(int ruleId) {
        return (T)((Rule)Utils.castUp(this.getRuleMap().get(ruleId)));
    }

    public String saveState() {
        return DeepSerializer.serialize(this);
    }

    public void restoreNetworkState(String networkState) {
        Network duplicateWithState = CocoClient.getInstance().restoreNetworkState(networkState);
        if (!this.getId().equals(duplicateWithState.getId())) {
            throw new IllegalArgumentException("id mismatch: this:" + this.getId() + ", that: " + duplicateWithState.getId());
        }
        for (Device d : duplicateWithState.getDeviceIterable()) {
            if (this.containsDevice(d.getId())) continue;
            this.internalAddDevice(d);
        }
        for (Zone z : duplicateWithState.getZoneIterable()) {
            if (this.containsZone(z.getId())) continue;
            this.internalAddZone(z);
        }
        for (Scene s : duplicateWithState.getSceneIterable()) {
            if (this.containsScene(s.getId())) continue;
            this.internalAddScene(s);
        }
        for (Rule r : duplicateWithState.getRuleIterable()) {
            if (this.containsRule(r.getId())) continue;
            this.internalAddRule(r);
        }
    }

    protected void internalRemoveNetwork() {
    }

    protected void internalSetResourceTemplates(List<ResourceTemplate> resourceTemplates) {
        if (null == resourceTemplates) {
            resourceTemplates = new ArrayList<ResourceTemplate>();
        }
        this.resourceTemplates = resourceTemplates;
    }

    protected void internalAddDevice(Device device) {
        this.getDeviceMap().put(device.getId(), device);
    }

    protected void internalRemoveDevice(long deviceNodeId) {
        this.getDeviceMap().remove(deviceNodeId);
    }

    public boolean containsDevice(long deviceNodeId) {
        return this.getDeviceMap().containsKey(deviceNodeId);
    }

    protected void internalAddZone(Zone zone) {
        this.getZoneMap().put(zone.getId(), zone);
    }

    protected void internalRemoveZone(int zoneId) {
        this.getZoneMap().remove(zoneId);
    }

    public boolean containsZone(int zoneId) {
        return this.getZoneMap().containsKey(zoneId);
    }

    protected void internalAddScene(Scene scene) {
        this.getSceneMap().put(scene.getId(), scene);
    }

    protected void internalRemoveScene(int sceneId) {
        this.getSceneMap().remove(sceneId);
    }

    public boolean containsScene(int sceneId) {
        return this.getSceneMap().containsKey(sceneId);
    }

    protected void internalAddRule(Rule rule) {
        this.getRuleMap().put(rule.getId(), rule);
    }

    protected void internalRemoveRule(int ruleId) {
        this.getRuleMap().remove(ruleId);
    }

    public boolean containsRule(int ruleId) {
        return this.getRuleMap().containsKey(ruleId);
    }

    protected void internalSetName(String name) {
        this.name = name;
    }

    protected void internalSetUserRole(UserRole userRole) {
        this.userRole = userRole;
    }

    protected void internalSetAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    protected void internalSetState(State state) {
        this.state = state;
    }

    protected void internalSetConnectivityState(ConnectivityStateManager.State state) {
        this.connectivityManagerState = state;
    }

    protected void internalSetNetworkType(NetworkType type) {
        this.networkType = type;
    }

    protected void internalSetMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public Iterator<Device> iterator() {
        return this.getDeviceIterable().iterator();
    }

    public Iterable<Device> getDeviceIterable() {
        if (null != this.deviceIterable) {
            return this.deviceIterable;
        }
        this.deviceIterable = () -> this.getDeviceMap().values().iterator();
        return this.deviceIterable;
    }

    public Iterable<Zone> getZoneIterable() {
        if (null != this.zoneIterable) {
            return this.zoneIterable;
        }
        this.zoneIterable = () -> this.getZoneMap().values().iterator();
        return this.zoneIterable;
    }

    public Iterable<Scene> getSceneIterable() {
        if (null != this.sceneIterable) {
            return this.sceneIterable;
        }
        this.sceneIterable = () -> this.getSceneMap().values().iterator();
        return this.sceneIterable;
    }

    public Iterable<Rule> getRuleIterable() {
        if (null != this.ruleIterable) {
            return this.ruleIterable;
        }
        this.ruleIterable = () -> this.getRuleMap().values().iterator();
        return this.ruleIterable;
    }

    public void sendData(String data, long[] nodeIds) {
        CocoClient.getInstance().getNativeHandler().sendData(this, data, nodeIds);
    }

    public void sendContentInfo(long contentTime, String data, long[] nodeIds) {
        CocoClient.getInstance().getNativeHandler().sendContentInfo(this, contentTime, data, nodeIds);
    }

    public String toString() {
        return "Network{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", userRole=" + (Object)((Object)this.userRole) + ", accessType=" + (Object)((Object)this.accessType) + ", state=" + (Object)((Object)this.state) + ", connectivityManagerState=" + (Object)((Object)this.connectivityManagerState) + ", networkType=" + (Object)((Object)this.networkType) + '}';
    }

    public static interface NetworkManagementStatusListener
    extends Listener {
        public void onStatusChanged(CommandResponse<CommandId> var1, Throwable var2);
    }

    public static interface LeaveStatusListener
    extends Listener {
        public void onResponse(Command.State var1, Throwable var2);
    }

    static final class SdkContext {
        private final String networkId;

        SdkContext(String networkId) {
            this.networkId = networkId;
        }

        public String getNetworkId() {
            return this.networkId;
        }
    }

    public static class ResourceTemplate {
        @SerializedName(value="resTemplateId")
        private final String resourceTemplateId;
        @SerializedName(value="zoneId")
        private final int zoneId;
        @SerializedName(value="name")
        private final String name;
        @SerializedName(value="icon")
        private final String icon;

        public ResourceTemplate(String resourceTemplateId, int zoneId, String name, String icon) {
            this.resourceTemplateId = resourceTemplateId;
            this.zoneId = zoneId;
            this.name = name;
            this.icon = icon;
        }

        public String getResourceTemplateId() {
            return this.resourceTemplateId;
        }

        public int getZoneId() {
            return this.zoneId;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public String toString() {
            return "ResourceTemplate{resourceTemplateId='" + this.resourceTemplateId + '\'' + ", zoneId=" + this.zoneId + ", name='" + this.name + '\'' + ", icon='" + this.icon + '\'' + '}';
        }
    }

    public static class AssignToTemplate
    extends Command<CommandId> {
        @SerializedName(value="zoneId")
        public final int zoneId;
        @SerializedName(value="deviceNodeId")
        private final long deviceId;
        @SerializedName(value="resTemplateId")
        private final String resourceTemplateId;
        @SerializedName(value="resourceEui")
        private final String resourceEui;

        public AssignToTemplate(int zoneId, long deviceId, String resourceTemplateId, String resourceEui) {
            super(CommandId.ASSIGN_TO_TEMPLATE);
            this.zoneId = zoneId;
            this.deviceId = deviceId;
            this.resourceTemplateId = resourceTemplateId;
            this.resourceEui = resourceEui;
        }
    }

    public static class SaveRule
    extends Command<CommandId> {
        @SerializedName(value="ruleId")
        public int id = 0;
        @SerializedName(value="ruleName")
        public String name;
        @SerializedName(value="resrcCondnArr")
        public List<ResourceCondition> resourceConditions;
        @SerializedName(value="schedCondnArr")
        public List<ScheduleCondition> scheduleConditions;
        @SerializedName(value="resrcActionArr")
        public List<ResourceAction> resourceActions;
        @SerializedName(value="sceneActionArr")
        public List<Scene> sceneActions;

        public SaveRule() {
            super(CommandId.SAVE_RULE_SETTINGS);
        }

        public boolean areConditionDataTypesCorrect() {
            for (ResourceCondition cond : this.resourceConditions) {
                Attribute.DataType dataType;
                Attribute attribute = cond.getAttribute();
                Attribute.DataType dataType2 = dataType = null == attribute ? null : attribute.getDataType();
                if (cond.getAttributeDataType() == dataType) continue;
                return false;
            }
            return true;
        }

        public void correctConditionsDataTypes() {
            ArrayList<ResourceCondition.EditableResourceCondition> conditions = new ArrayList<ResourceCondition.EditableResourceCondition>();
            for (ResourceCondition cond : this.resourceConditions) {
                ResourceCondition.EditableResourceCondition editableCond;
                if (cond instanceof ResourceCondition.EditableResourceCondition) {
                    editableCond = (ResourceCondition.EditableResourceCondition)cond;
                    editableCond.setDataType(cond.getAttribute().getDataType());
                    continue;
                }
                editableCond = new ResourceCondition.EditableResourceCondition(cond.getAttribute(), cond.getOperatorType(), cond.getConditionDuration(), cond.getThresholdAttributeValue());
                conditions.add(editableCond);
            }
            this.resourceConditions.clear();
            this.resourceConditions.addAll(conditions);
        }
    }

    public static class RemoveRule
    extends Command<CommandId> {
        @SerializedName(value="ruleIdArr")
        public int[] ruleIds;

        public RemoveRule(Rule[] rules) {
            super(CommandId.REM_RULE);
            this.ruleIds = new int[rules.length];
            for (int i = 0; i < rules.length; ++i) {
                this.ruleIds[i] = rules[i].getId();
            }
        }
    }

    public static class SetRule
    extends Command<CommandId> {
        @SerializedName(value="ruleId")
        public int ruleId = 0;
        @SerializedName(value="ruleName")
        public String ruleName;

        public SetRule(String ruleName) {
            this(null, ruleName);
        }

        public SetRule(Rule rule, String ruleName) {
            super(CommandId.SET_RULE_INFO);
            if (null != rule) {
                this.ruleId = rule.getId();
            }
            this.ruleName = ruleName;
        }
    }

    public static class RemoveSceneResourceActions
    extends Command<CommandId> {
        @SerializedName(value="sceneId")
        public int sceneId;
        @SerializedName(value="resrcActionArr")
        public int[] resourceActions;

        public RemoveSceneResourceActions(Scene scene, ResourceAction[] resourceActions) {
            super(CommandId.REM_SCENE_RES_ACT);
            this.resourceActions = new int[resourceActions.length];
            for (int i = 0; i < resourceActions.length; ++i) {
                this.resourceActions[i] = resourceActions[i].getId();
            }
            this.sceneId = scene.getId();
        }
    }

    public static class SaveSceneResourceActions
    extends SceneResourceActions {
        public SaveSceneResourceActions(Scene scene, ResourceAction[] resourceActions) {
            super(scene, resourceActions, CommandId.SAVE_SCENE_SETTINGS);
        }
    }

    public static class UpdateSceneResourceActions
    extends SceneResourceActions {
        public static ResourceAction[] copy(int[] actionIds, ResourceAction[] actions) {
            if (actionIds.length != actions.length) {
                throw new IllegalArgumentException("array lengths mismatch: " + actionIds.length + ", " + actions.length);
            }
            ResourceAction[] copy = new ResourceAction[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                ResourceAction action;
                copy[i] = action = new ResourceAction(actionIds[i], actions[i].getCapability(), actions[i].getCommand());
            }
            return copy;
        }

        public UpdateSceneResourceActions(Scene scene, int[] resourceActionIds, ResourceAction[] resourceActions) {
            super(scene, UpdateSceneResourceActions.copy(resourceActionIds, resourceActions), CommandId.UPDATE_SCENE_RES_ACT);
        }
    }

    public static class AddSceneResourceAction
    extends SceneResourceActions {
        public AddSceneResourceAction(Scene scene, ResourceAction[] resourceActions) {
            super(scene, resourceActions, CommandId.ADD_SCENE_RES_ACT);
            for (ResourceAction action : resourceActions) {
                if (0 == action.getId()) continue;
                throw new IllegalArgumentException("expecting id: 0, got: " + action.getId());
            }
        }
    }

    public static abstract class SceneResourceActions
    extends Command<CommandId> {
        @SerializedName(value="sceneId")
        public int sceneId;
        @SerializedName(value="resrcActionArr")
        public ResourceAction[] resourceActions;

        public SceneResourceActions(Scene scene, ResourceAction[] resourceActions, CommandId commandId) {
            super(commandId);
            this.sceneId = scene.getId();
            this.resourceActions = resourceActions;
        }
    }

    public static class RemoveScene
    extends Command<CommandId> {
        @SerializedName(value="sceneIdArr")
        public int[] sceneIds;

        public RemoveScene(Scene[] scenes) {
            super(CommandId.REM_SCENE);
            this.sceneIds = new int[scenes.length];
            for (int i = 0; i < scenes.length; ++i) {
                this.sceneIds[i] = scenes[i].getId();
            }
        }
    }

    public static class SetSceneMetadata
    extends Command<CommandId> {
        @SerializedName(value="sceneId")
        public int sceneId = 0;
        @SerializedName(value="sceneMetadata")
        public String sceneMetadata;

        public SetSceneMetadata(Scene scene, String sceneMetadata) {
            super(CommandId.SET_SCENE_METADATA);
            if (null != scene) {
                this.sceneId = scene.getId();
            }
            this.sceneMetadata = sceneMetadata;
        }
    }

    public static class SetScene
    extends Command<CommandId> {
        @SerializedName(value="sceneId")
        public int sceneId = 0;
        @SerializedName(value="sceneName")
        public String sceneName;

        public SetScene(String sceneName) {
            this(null, sceneName);
        }

        public SetScene(Scene scene, String sceneName) {
            super(CommandId.SET_SCENE_INFO);
            if (null != scene) {
                this.sceneId = scene.getId();
            }
            this.sceneName = sceneName;
        }
    }

    @Deprecated
    public static class RemoveResourcesFromZone
    extends Command<CommandId> {
        @SerializedName(value="zoneId")
        public int zoneId;
        @SerializedName(value="resourceArr")
        public Resource[] resources;

        public RemoveResourcesFromZone(Zone zone, Resource[] resources) {
            super(CommandId.REM_ZONE_RES);
            this.zoneId = zone.getId();
            this.resources = resources;
        }
    }

    public static class MoveResourcesBetweenZones
    extends Command<CommandId> {
        @SerializedName(value="oldZoneId")
        public int fromZoneId;
        @SerializedName(value="newZoneId")
        public int toZoneId;
        @SerializedName(value="resourceArr")
        public Resource[] resources;

        public MoveResourcesBetweenZones(Zone fromZone, Zone toZone, Resource[] resources) {
            super(CommandId.MOVE_ZONE_RES);
            this.fromZoneId = fromZone.getId();
            this.toZoneId = toZone.getId();
            this.resources = resources;
        }
    }

    @Deprecated
    public static class AddResourcesToZone
    extends Command<CommandId> {
        @SerializedName(value="zoneId")
        public int zoneId;
        @SerializedName(value="resourceArr")
        public Resource[] resources;

        public AddResourcesToZone(Zone zone, Resource[] resources) {
            super(CommandId.ADD_ZONE_RES);
            this.zoneId = zone.getId();
            this.resources = resources;
        }
    }

    public static class RemoveZone
    extends Command<CommandId> {
        @SerializedName(value="zoneIdArr")
        public int[] zoneIds;

        public RemoveZone(Zone[] zones) {
            super(CommandId.REM_ZONE);
            this.zoneIds = new int[zones.length];
            for (int i = 0; i < zones.length; ++i) {
                this.zoneIds[i] = zones[i].getId();
            }
        }
    }

    public static class SetZone
    extends Command<CommandId> {
        @SerializedName(value="zoneId")
        public int zoneId = 0;
        @SerializedName(value="zoneName")
        public String zoneName;

        public SetZone(String zoneName) {
            this(null, zoneName);
        }

        public SetZone(Zone zone, String zoneName) {
            super(CommandId.SET_ZONE_INFO);
            if (null != zone) {
                this.zoneId = zone.getId();
            }
            this.zoneName = zoneName;
        }
    }

    public static final class ConnectArgs {
        private String networkId;
        private String inviteUrl;
        private long nodeId;
        private String networkName;
        private UserRole userRole;
        private AccessType accessType;
        private NetworkType networkType;

        public ConnectArgs setNetworkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public String getNetworkId() {
            return this.networkId;
        }

        public ConnectArgs setNetworkType(NetworkType networkType) {
            this.networkType = networkType;
            return this;
        }

        public NetworkType getNetworkType() {
            return this.networkType;
        }

        public ConnectArgs setInviteUrl(String inviteUrl) {
            this.inviteUrl = inviteUrl;
            return this;
        }

        public String getInviteUrl() {
            return this.inviteUrl;
        }

        public ConnectArgs setNodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public long getNodeId() {
            return this.nodeId;
        }

        public ConnectArgs setAccessType(AccessType accessType) {
            this.accessType = accessType;
            return this;
        }

        public ConnectArgs setUserRole(UserRole userRole) {
            this.userRole = userRole;
            return this;
        }

        public ConnectArgs setNetworkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public void connect() {
            Network.connectWithInvite(this.getNetworkId(), this.networkName, this.networkType, this.userRole, this.accessType, this.getInviteUrl(), this.getNodeId());
        }
    }

    public static enum NetworkType {
        IOT,
        CALL_NET;


        public static NetworkType getEnum(int index) {
            return (NetworkType)Utils.findEnum((int)index, (Enum[])NetworkType.values());
        }

        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum AccessType {
        LOCAL,
        REMOTE;


        public static AccessType getEnum(int index) {
            return (AccessType)Utils.findEnum((int)index, (Enum[])AccessType.values());
        }

        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum UserRole {
        OWNER,
        ADMIN,
        GUEST;


        public static UserRole getEnum(int index) {
            return (UserRole)Utils.findEnum((int)index, (Enum[])UserRole.values());
        }

        public int getInt() {
            return this.ordinal();
        }
    }

    public static enum State {
        CONNECTED,
        CONNECTING,
        CONNECTION_ERROR,
        NETWORK_RESET,
        DISCONNECTED,
        BLOCKED,
        NOT_PERMITTED;


        static State getEnum(int index) {
            return (State)Utils.findEnum((int)index, (Enum[])State.values());
        }

        int getInt() {
            return this.ordinal();
        }

        public boolean isConnected() {
            return CONNECTED == this;
        }

        public boolean isConnecting() {
            return CONNECTING == this;
        }

        public boolean isConnectedOrConnecting() {
            return this.isConnecting() || this.isConnected();
        }

        public boolean isEquivalentToDisconnected() {
            return !this.isConnectedOrConnecting();
        }

        public boolean isLeftOrDeletedOrBlocked() {
            return this.isLeftOrDeleted() || this.isBlocked();
        }

        public boolean isLeftOrDeleted() {
            return NETWORK_RESET == this;
        }

        public boolean isBlocked() {
            return BLOCKED == this;
        }

        public boolean connectionNotPermitted() {
            return NOT_PERMITTED == this;
        }
    }

    public static enum CommandId implements CommandIdInterface
    {
        SET_ZONE_INFO,
        REM_ZONE,
        ADD_ZONE_RES,
        REM_ZONE_RES,
        MOVE_ZONE_RES,
        SET_SCENE_INFO,
        REM_SCENE,
        ADD_SCENE_RES_ACT,
        UPDATE_SCENE_RES_ACT,
        REM_SCENE_RES_ACT,
        SET_RULE_INFO,
        REM_RULE,
        ADD_RULE_RES_COND,
        UPDATE_RULE_RES_COND,
        REM_RULE_RES_COND,
        ADD_RULE_SCH_COND,
        UPDATE_RULE_SCH_COND,
        REM_RULE_SCH_COND,
        ADD_RULE_RES_ACT,
        UPDATE_RULE_RES_ACT,
        REM_RULE_RES_ACT,
        ADD_RULE_SCENE_ACT,
        REM_RULE_SCENE_ACT,
        SET_SCENE_METADATA,
        SAVE_SCENE_SETTINGS,
        SAVE_RULE_SETTINGS,
        ASSIGN_TO_TEMPLATE;


        static CommandId getEnum(int index) {
            return (CommandId)Utils.findEnum((int)index, (Enum[])CommandId.values());
        }

        @Override
        public int getInt() {
            return this.ordinal();
        }
    }
}

