/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Attribute;
import buzz.getcoco.iot.Capability;
import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Device;
import buzz.getcoco.iot.PowerSource;
import buzz.getcoco.iot.RadioProtocol;
import buzz.getcoco.iot.ReceiverType;
import buzz.getcoco.iot.Utils;
import buzz.getcoco.iot.Zone;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class Resource
implements Iterable<Capability> {
    @SerializedName(value="resourceEui")
    private final String eui;
    @SerializedName(value="resourceName")
    private String name;
    @SerializedName(value="metadata")
    private String metadata;
    @SerializedName(value="manufacturer")
    private String manufacturer;
    @SerializedName(value="model")
    private String model;
    @SerializedName(value="firmwareVersion")
    private String firmware;
    @SerializedName(value="powerSource")
    private PowerSource powerSource;
    @SerializedName(value="receiverType")
    private ReceiverType receiverType;
    @SerializedName(value="protocolId")
    private RadioProtocol protocol;
    private transient Device parentDevice;
    private transient Zone parentZone;
    private transient boolean ready = false;
    @SerializedName(value="capabilityMap")
    private Map<Capability.CapabilityId, Capability> capabilityMap;

    Resource() {
        this.eui = null;
        this.name = null;
        this.metadata = null;
        this.manufacturer = null;
        this.model = null;
        this.firmware = null;
        this.powerSource = null;
        this.receiverType = null;
        this.parentDevice = null;
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(Resource.class, (Object)new ResourceSerializer());
    }

    protected Resource(String eui, Device parentDevice, Zone parentZone) {
        this.eui = eui;
        this.parentDevice = parentDevice;
        this.parentZone = parentZone;
        this.powerSource = null;
        this.receiverType = null;
    }

    public final String getId() {
        return this.eui;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name, Device.DeviceManagementStatusListener listener) {
        this.parentDevice.setResourceName(this, name, listener);
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getModel() {
        return this.model;
    }

    public String getFirmware() {
        return this.firmware;
    }

    public PowerSource getPowerSource() {
        return this.powerSource;
    }

    public ReceiverType getReceiverType() {
        return this.receiverType;
    }

    public final <T extends Device> T getParent() {
        return (T)((Device)Utils.castUp(this.parentDevice));
    }

    public final <T extends Zone> T getParentZone() {
        return (T)((Zone)Utils.castUp(this.parentZone));
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata, Device.DeviceManagementStatusListener listener) {
        this.parentDevice.setResourceMetadata(this, metadata, listener);
    }

    public Map<Capability.CapabilityId, Capability> getCapabilityMap() {
        if (null == this.capabilityMap) {
            this.capabilityMap = new EnumMap<Capability.CapabilityId, Capability>(Capability.CapabilityId.class);
        }
        return this.capabilityMap;
    }

    public <T extends Capability> T getCapability(Capability.CapabilityId capId) {
        return (T)((Capability)Utils.castUp(this.getCapabilityMap().get((Object)capId)));
    }

    public <T extends Attribute> T getAttribute(Capability.AttributeId attrId) {
        T cap = this.getCapability(attrId.getCapabilityId());
        return null == cap ? null : (T)((Capability)cap).getAttribute(attrId);
    }

    public boolean containsCapability(Capability.CapabilityId capabilityId) {
        return this.getCapabilityMap().containsKey((Object)capabilityId);
    }

    protected void internalAddCapability(Capability capability) {
        this.getCapabilityMap().put(capability.getId(), capability);
    }

    protected void internalRemoveCapability(Capability.CapabilityId capabilityId) {
        this.getCapabilityMap().remove((Object)capabilityId);
    }

    public boolean isReady() {
        return this.ready && this.parentDevice.isReady();
    }

    protected void internalSetName(String name) {
        this.name = name;
    }

    protected void internalSetMetadata(String metadata) {
        this.metadata = metadata;
    }

    protected void internalSetManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    protected void internalSetModel(String model) {
        this.model = model;
    }

    protected void internalSetFirmware(String firmware) {
        this.firmware = firmware;
    }

    protected void internalSetPowerSource(PowerSource powerSource) {
        this.powerSource = powerSource;
    }

    protected void internalSetReceiverType(ReceiverType receiverType) {
        this.receiverType = receiverType;
    }

    protected void internalSetParentDevice(Device parentDevice) {
        this.parentDevice = parentDevice;
    }

    protected void internalSetParentZone(Zone parentZone) {
        this.parentZone = parentZone;
    }

    protected void internalMarkAsReady() {
        this.ready = true;
    }

    protected void internalSetProtocol(RadioProtocol protocol) {
        this.protocol = protocol;
    }

    protected void internalRemoveResource() {
    }

    public RadioProtocol getProtocol() {
        return this.protocol;
    }

    public final int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public Iterator<Capability> iterator() {
        return this.getCapabilityMap().values().iterator();
    }

    public String toString() {
        return "Resource{eui='" + this.eui + '\'' + ", name='" + this.name + '\'' + ", metadata='" + this.metadata + '\'' + ", manufacturer='" + this.manufacturer + '\'' + ", model='" + this.model + '\'' + ", firmware='" + this.firmware + '\'' + ", powerSource=" + (Object)((Object)this.powerSource) + ", receiverType=" + (Object)((Object)this.receiverType) + ", protocol=" + (Object)((Object)this.protocol) + ", ready=" + this.ready + '}';
    }

    private static class ResourceSerializer
    implements JsonSerializer<Resource> {
        private ResourceSerializer() {
        }

        public JsonElement serialize(Resource src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("resourceEui", src.getId());
            jsonObject.addProperty("gatewayNodeId", (Number)((Device)src.getParent()).getId());
            return jsonObject;
        }
    }
}

