/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.iot;

import buzz.getcoco.iot.Command;
import buzz.getcoco.iot.Factory;
import buzz.getcoco.iot.Network;
import buzz.getcoco.iot.ResourceAction;
import buzz.getcoco.iot.ResourceCondition;
import buzz.getcoco.iot.Scene;
import buzz.getcoco.iot.ScheduleCondition;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Rule {
    private final int id;
    private List<ResourceCondition> resourceConditions;
    private List<ScheduleCondition> scheduleConditions;
    private List<ResourceAction> resourceActions;
    private List<Scene> sceneActions;
    private String name;
    private transient Network parent;
    private transient boolean ready = false;
    public static final int DEFAULT_RULE_ID = 0;

    protected Rule(int id, Network parent) {
        this.id = id;
        this.parent = parent;
    }

    static void init() {
        Command.GSON_BUILDER.registerTypeAdapter(Rule.class, (Object)new RuleParser());
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Network getParent() {
        return this.parent;
    }

    public List<ResourceCondition> getResourceConditions() {
        if (null == this.resourceConditions) {
            this.resourceConditions = Collections.synchronizedList(new ArrayList());
        }
        return this.resourceConditions;
    }

    public List<ScheduleCondition> getScheduleConditions() {
        if (null == this.scheduleConditions) {
            this.scheduleConditions = Collections.synchronizedList(new ArrayList());
        }
        return this.scheduleConditions;
    }

    public List<ResourceAction> getResourceActions() {
        if (null == this.resourceActions) {
            this.resourceActions = Collections.synchronizedList(new ArrayList());
        }
        return this.resourceActions;
    }

    public List<Scene> getSceneActions() {
        if (null == this.sceneActions) {
            this.sceneActions = Collections.synchronizedList(new ArrayList());
        }
        return this.sceneActions;
    }

    public boolean isReady() {
        return this.ready;
    }

    protected void internalClearAddResourceConditions(Collection<ResourceCondition> resourceConditions) {
        this.getResourceConditions().clear();
        this.getResourceConditions().addAll(resourceConditions);
    }

    protected void internalClearAddScheduleConditions(Collection<ScheduleCondition> scheduleConditions) {
        this.getScheduleConditions().clear();
        this.getScheduleConditions().addAll(scheduleConditions);
    }

    protected void internalClearAddResourceActions(Collection<ResourceAction> resourceActions) {
        this.getResourceActions().clear();
        this.getResourceActions().addAll(resourceActions);
    }

    protected void internalClearAddSceneActions(Collection<Scene> scenesActions) {
        this.getSceneActions().clear();
        this.getSceneActions().addAll(scenesActions);
    }

    protected void internalSetName(String name) {
        this.name = name;
    }

    protected void internalSetParent(Network parent) {
        this.parent = parent;
    }

    protected void internalMarkAsReady() {
        this.ready = true;
    }

    public final int hashCode() {
        return this.getId();
    }

    public String toString() {
        String networkId = null == this.parent ? "?" : this.parent.getId();
        return "Rule{networkId=" + networkId + ", id=" + this.id + ", name='" + this.name + '\'' + ", ready=" + this.ready + ", resourceConditions=" + this.resourceConditions + ", scheduleConditions=" + this.scheduleConditions + ", resourceActions=" + this.resourceActions + ", sceneActions=" + this.sceneActions + '}';
    }

    public static interface Condition {
        public Condition duplicate();
    }

    private static class RuleParser
    implements JsonSerializer<Rule>,
    JsonDeserializer<Rule> {
        private RuleParser() {
        }

        public Rule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            Gson gson = Command.GSON_BUILDER.create();
            int id = jsonObject.get("ruleId").getAsInt();
            String name = jsonObject.get("ruleName").getAsString();
            ArrayList resourceConditions = (ArrayList)gson.fromJson(jsonObject.get("resrcCondnArr"), new TypeToken<ArrayList<ResourceCondition>>(){}.getType());
            ArrayList scheduleConditions = (ArrayList)gson.fromJson(jsonObject.get("schedCondnArr"), new TypeToken<ArrayList<ScheduleCondition>>(){}.getType());
            ArrayList resourceActions = (ArrayList)gson.fromJson(jsonObject.get("resrcActionArr"), new TypeToken<ArrayList<ResourceAction>>(){}.getType());
            ArrayList sceneActions = (ArrayList)gson.fromJson(jsonObject.get("sceneActionArr"), new TypeToken<ArrayList<Scene>>(){}.getType());
            Rule rule = Factory.createRule(id, null);
            rule.internalSetName(name);
            rule.internalClearAddResourceConditions(resourceConditions);
            rule.internalClearAddScheduleConditions(scheduleConditions);
            rule.internalClearAddResourceActions(resourceActions);
            rule.internalClearAddSceneActions(sceneActions);
            return rule;
        }

        public JsonElement serialize(Rule rule, Type typeOfSrc, JsonSerializationContext context) {
            Gson gson = Command.GSON_BUILDER.create();
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("ruleId", (Number)rule.id);
            jsonObject.addProperty("ruleName", rule.name);
            jsonObject.add("resrcActionArr", gson.toJsonTree(rule.getResourceActions()));
            jsonObject.add("sceneActionArr", gson.toJsonTree(rule.getSceneActions()));
            jsonObject.add("resrcCondnArr", gson.toJsonTree(rule.getResourceConditions()));
            jsonObject.add("schedCondnArr", gson.toJsonTree(rule.getScheduleConditions()));
            return jsonObject;
        }
    }
}

